/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.sigle.utilities.geom;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.geom.OpenJUMPMakeValidOp;
import com.vividsolutions.jump.workbench.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.operation.union.UnaryUnionOp;

public class FeatureCollectionUtil {
    public static int getFeatureCollectionDimension(FeatureCollection fc) {
        int type = -1;
        if (fc.getFeatures().size() > 0) {
            GeometryCollection geomCol;
            Iterator<Feature> i = fc.getFeatures().iterator();
            Feature f = i.next();
            type = f.getGeometry().getDimension();
            if (f.getGeometry() instanceof GeometryCollection && (geomCol = (GeometryCollection)f.getGeometry()).getGeometryType().equalsIgnoreCase("GeometryCollection")) {
                type = -1;
            }
            while (i.hasNext() && type != -1) {
                f = i.next();
                if (f.getGeometry() instanceof GeometryCollection && (geomCol = (GeometryCollection)f.getGeometry()).getGeometryType().equalsIgnoreCase("GeometryCollection")) {
                    type = -1;
                }
                if (f.getGeometry().getDimension() == type) continue;
                type = -1;
            }
        }
        return type;
    }

    public static ArrayList getAttributesList(FeatureCollection fc) {
        ArrayList<String> AttributesList = new ArrayList<String>();
        FeatureSchema fs = fc.getFeatureSchema();
        for (int i = 0; i < fs.getAttributeCount() - 1; ++i) {
            AttributesList.add(fs.getAttributeName(i));
        }
        return AttributesList;
    }

    public static void validFeatureCollection(FeatureCollection fc) {
        OpenJUMPMakeValidOp makeValidOp = new OpenJUMPMakeValidOp();
        makeValidOp.setPreserveGeomDim(true);
        makeValidOp.setPreserveDuplicateCoord(false);
        for (Feature feature : fc.getFeatures()) {
            Geometry validGeom = makeValidOp.makeValid(feature.getGeometry());
            feature.setGeometry(validGeom);
        }
    }

    public static void unionByAttributeValue(FeatureCollection featureCollection, String attributeName) throws Exception {
        FeatureSchema schema = featureCollection.getFeatureSchema();
        if (featureCollection.getFeatures().size() > 1 && featureCollection.getFeatures().get(0).getGeometry() != null) {
            featureCollection.getFeatures().get(0).getGeometry().getFactory();
        } else {
            Logger.error(I18N.getInstance().get("ui.plugin.analysis.DissolvePlugIn.needs-two-features-or-more"));
        }
        FeatureSchema newSchema = schema;
        HashMap<Object, FeatureDataset> map = new HashMap<Object, FeatureDataset>();
        for (Feature feature : featureCollection.getFeatures()) {
            Object key = feature.getAttribute(attributeName);
            if (!map.containsKey(key)) {
                FeatureDataset fd = new FeatureDataset(featureCollection.getFeatureSchema());
                fd.add(feature);
                map.put(key, fd);
                continue;
            }
            ((FeatureCollection)map.get(key)).add(feature);
        }
        featureCollection.removeAll(featureCollection.getFeatures());
        for (Object key : map.keySet()) {
            FeatureCollection fca = (FeatureCollection)map.get(key);
            if (fca.size() <= 0) continue;
            Feature feature = FeatureCollectionUtil.union(fca);
            feature.setAttribute(attributeName, key);
            BasicFeature newFeature = new BasicFeature(newSchema);
            int max = newSchema.getAttributeCount();
            for (int j = 0; j < max; ++j) {
                newFeature.setAttribute(j, feature.getAttribute(newSchema.getAttributeName(j)));
            }
            featureCollection.add(newFeature);
        }
    }

    private static Feature union(FeatureCollection fc) {
        GeometryFactory factory = new GeometryFactory();
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        for (Feature f : fc.getFeatures()) {
            Geometry g = f.getGeometry();
            geometries.add(g);
        }
        Geometry unioned = UnaryUnionOp.union(geometries);
        FeatureSchema schema = fc.getFeatureSchema();
        BasicFeature feature = new BasicFeature(schema);
        if (geometries.size() == 0) {
            feature.setGeometry((Geometry)factory.createGeometryCollection(new Geometry[0]));
        } else {
            feature.setGeometry(unioned);
        }
        return feature;
    }
}

