/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.sigle.plugin.joinTable;

import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.workbench.model.Layer;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.openjump.sigle.plugin.joinTable.JoinTableDataSource;
import org.openjump.sigle.plugin.joinTable.JoinTableDataSourceCSV;

public class JoinTable {
    private JoinTableDataSource dataSource = null;
    private ArrayList fieldNames = null;
    private ArrayList fieldTypes = null;
    private Hashtable table = null;
    private int keyIndex = -1;
    private int fieldCount = 0;

    public JoinTable(String filePath) {
        this.dataSource = new JoinTableDataSourceCSV(filePath);
        this.fieldNames = this.dataSource.getFieldNames();
        this.fieldCount = this.fieldNames.size();
    }

    public List getFieldNames() {
        return this.fieldNames;
    }

    public String getFieldName(int indice) {
        return (String)this.fieldNames.get(indice);
    }

    public AttributeType getFieldType(int indice) {
        return (AttributeType)this.fieldTypes.get(indice);
    }

    public int getFieldCount() {
        return this.fieldCount;
    }

    public void setKeyIndex(int keyIndex) {
        this.keyIndex = keyIndex;
    }

    public int getKeyIndex() {
        return this.keyIndex;
    }

    public void build() {
        if (this.keyIndex > -1) {
            this.table = this.dataSource.buildTable(this.keyIndex);
            this.fieldTypes = this.dataSource.getFieldTypes();
        }
    }

    public void join(Layer layer, int attributeIndex) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        layer.setEditable(true);
        String suffixe = "";
        FeatureSchema schema = layer.getFeatureCollectionWrapper().getFeatureSchema().clone();
        int nbOldAttributes = schema.getAttributeCount();
        for (int i = 0; i < this.fieldNames.size(); ++i) {
            if (i == this.keyIndex) continue;
            String nomChamp = (String)this.fieldNames.get(i);
            suffixe = "";
            int j = 0;
            while (schema.hasAttribute(nomChamp + suffixe)) {
                suffixe = String.valueOf(++j);
            }
            nomChamp = nomChamp + suffixe;
            this.fieldNames.set(i, nomChamp);
            AttributeType t = (AttributeType)this.fieldTypes.get(i);
            schema.addAttribute(nomChamp, t);
        }
        FeatureCollectionWrapper fc = layer.getFeatureCollectionWrapper();
        List<Feature> features = fc.getFeatures();
        ArrayList<Feature> newFeatures = new ArrayList<Feature>(features.size());
        for (Feature f : features) {
            int j;
            Feature fNew = f.clone(true);
            fNew.setSchema(schema);
            fNew.setAttributes(new Object[schema.getAttributeCount()]);
            for (j = 0; j < nbOldAttributes; ++j) {
                fNew.setAttribute(j, f.getAttribute(j));
            }
            newFeatures.add(fNew);
            String keyValue = fNew.getString(attributeIndex);
            if (keyValue != null) {
                keyValue = keyValue.trim();
            }
            String[] valeurs = (String[])this.table.get(keyValue);
            for (j = 0; j < this.fieldCount; ++j) {
                if (j == this.keyIndex) continue;
                Object value = valeurs != null ? this.castValue(valeurs[j], (AttributeType)this.fieldTypes.get(j)) : null;
                fNew.setAttribute((String)this.fieldNames.get(j), value);
            }
        }
        layer.setFeatureCollection(new FeatureDataset(newFeatures, schema));
        layer.setEditable(false);
    }

    public void dispose() {
        if (this.table != null) {
            this.table.clear();
        }
        if (this.fieldTypes != null) {
            this.fieldTypes.clear();
        }
        if (this.fieldNames != null) {
            this.fieldNames.clear();
        }
        this.keyIndex = -1;
        this.fieldCount = 0;
        this.table = null;
        this.fieldTypes = null;
        this.fieldNames = null;
        this.dataSource = null;
    }

    private Object castValue(String s, AttributeType t) {
        try {
            Object res = t == AttributeType.DOUBLE ? ((s = s.replace(',', '.').replaceAll(" ", "")).length() == 0 ? null : Double.valueOf(s)) : (t == AttributeType.INTEGER ? ((s = s.replaceAll(" ", "")).length() == 0 ? null : Integer.valueOf(s)) : s.toString());
            return res;
        }
        catch (Exception e) {
            return null;
        }
    }
}

