/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.swing.factory.field;

import com.vividsolutions.jump.workbench.WorkbenchContext;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import org.openjump.core.ui.swing.ComboBoxComponentPanel;
import org.openjump.swing.factory.field.FieldComponentFactory;
import org.openjump.swing.listener.ValueChangeEvent;
import org.openjump.swing.listener.ValueChangeListener;

public class ComboBoxFieldComponentFactory
implements FieldComponentFactory {
    private WorkbenchContext workbenchContext;
    private String option;
    private Object[] items;

    public ComboBoxFieldComponentFactory(WorkbenchContext workbenchContext) {
        this.workbenchContext = workbenchContext;
    }

    public ComboBoxFieldComponentFactory(WorkbenchContext workbenchContext, String option, Object[] items) {
        this.workbenchContext = workbenchContext;
        this.option = option;
        this.items = items;
    }

    @Override
    public Object getValue(JComponent component) {
        if (component instanceof ComboBoxComponentPanel) {
            ComboBoxComponentPanel chooser = (ComboBoxComponentPanel)component;
            return chooser.getSelectedItem();
        }
        return null;
    }

    @Override
    public void setValue(JComponent component, Object value) {
        if (component instanceof ComboBoxComponentPanel) {
            ComboBoxComponentPanel chooser = (ComboBoxComponentPanel)component;
            if (value != null) {
                chooser.getComboBox().setSelectedItem(value);
            }
        }
    }

    @Override
    public JComponent createComponent() {
        ComboBoxComponentPanel chooser = new ComboBoxComponentPanel(this.option, this.items, this.workbenchContext.getErrorHandler());
        return chooser;
    }

    @Override
    public JComponent createComponent(final ValueChangeListener listener) {
        final ComboBoxComponentPanel chooser = new ComboBoxComponentPanel(this.option, this.items, this.workbenchContext.getErrorHandler());
        chooser.getComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object item = chooser.getSelectedItem();
                listener.valueChanged(new ValueChangeEvent(chooser, item));
            }
        });
        return chooser;
    }
}

