/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.swing;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.InternalFrameUI;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;
import javax.swing.plaf.basic.BasicInternalFrameUI;

public class DetachableInternalFrame
extends JInternalFrame {
    private boolean detached = false;
    private JPopupMenu detachPopupMenu = null;
    private JMenuItem detachMenuItem = null;
    private JFrame detachedFrame = null;
    private JRootPane activeRootPane = null;
    private Point internalFrameLocation = null;

    public DetachableInternalFrame(String title, boolean resizable, boolean closable, boolean maximizable, boolean iconifiable) {
        super(title, resizable, closable, maximizable, iconifiable);
        this.init();
    }

    public DetachableInternalFrame(String title, boolean resizable, boolean closable, boolean maximizable) {
        super(title, resizable, closable, maximizable);
        this.init();
    }

    public DetachableInternalFrame(String title, boolean resizable, boolean closable) {
        super(title, resizable, closable);
        this.init();
    }

    public DetachableInternalFrame(String title, boolean resizable) {
        super(title, resizable);
        this.init();
    }

    public DetachableInternalFrame(String title) {
        super(title);
        this.init();
    }

    public DetachableInternalFrame() {
        this.init();
    }

    private void init() {
        BasicInternalFrameUI bifui;
        JComponent northPane;
        this.detachPopupMenu = new JPopupMenu();
        this.detachMenuItem = new JMenuItem(I18N.getInstance().get("org.openjump.core.ui.swing.DetachableInternalFrame.detach-window"));
        this.detachMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DetachableInternalFrame.this.detach();
            }
        });
        this.detachPopupMenu.add(this.detachMenuItem);
        InternalFrameUI ifui = this.getUI();
        if (ifui instanceof BasicInternalFrameUI && (northPane = (bifui = (BasicInternalFrameUI)ifui).getNorthPane()) instanceof BasicInternalFrameTitlePane) {
            northPane.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    super.mouseClicked(e);
                    if (SwingUtilities.isRightMouseButton(e)) {
                        DetachableInternalFrame.this.detachPopupMenu.show((Component)e.getSource(), e.getX(), e.getY());
                    }
                }
            });
        }
    }

    public boolean detach() {
        if (this.detached) {
            return false;
        }
        Rectangle bounds = this.getBounds();
        Point screenLocation = this.getLocationOnScreen();
        bounds.x = screenLocation.x;
        bounds.y = screenLocation.y;
        this.activeRootPane = this.getRootPane();
        this.internalFrameLocation = this.getLocation();
        this.setLocation(0 - bounds.width, 0 - bounds.height);
        this.detachedFrame = this.getFrame();
        this.detachedFrame.setIconImage(GUIUtil.toImage(this.getFrameIcon()));
        this.detachedFrame.setDefaultCloseOperation(0);
        this.detachedFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DetachableInternalFrame.this.attach();
            }
        });
        this.detachedFrame.setTitle(this.getTitle());
        this.detachedFrame.setBounds(bounds);
        this.detachedFrame.setVisible(true);
        this.detached = true;
        return true;
    }

    public boolean attach() {
        if (!this.detached) {
            return false;
        }
        this.detachedFrame.dispose();
        this.setRootPane(this.activeRootPane);
        this.setLocation(this.internalFrameLocation);
        this.detached = false;
        return true;
    }

    public boolean isDetached() {
        return this.detached;
    }

    public void setDetachMenuItemText(String text) {
        this.detachMenuItem.setText(text);
    }

    public JFrame getFrame() {
        return new JFrame(){

            @Override
            protected JRootPane createRootPane() {
                return DetachableInternalFrame.this.getRootPane();
            }
        };
    }
}

