/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.wms.panels;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.WMSLayer;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.Border;

public class WMSTransparencyPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Border border1;
    private JLabel transparencyLabel = new JLabel();
    private WMSLayer layer;
    private LayerViewPanel panel;
    protected JSlider transparencySlider = new JSlider();
    protected Dictionary sliderLabelDictionary = new Hashtable();

    public String getTitle() {
        return I18N.getInstance().get("ui.plugin.wms.EditWMSQueryPanel.transparency");
    }

    public WMSTransparencyPanel(WMSLayer layer, LayerViewPanel panel) {
        this.initialize();
        this.layer = layer;
        int alpha = layer.getAlpha();
        this.panel = panel;
        panel.setName(this.getTitle());
        this.setAlpha(alpha);
    }

    public int getAlpha() {
        return 255 - this.transparencySlider.getValue() * 255 / 100;
    }

    private void setAlpha(int alpha) {
        this.transparencySlider.setValue(255 - alpha * 255 / 100);
    }

    private void initialize() {
        this.border1 = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        this.setLayout(new GridBagLayout());
        this.setBorder(this.border1);
        this.setToolTipText("");
        this.transparencyLabel.setText(I18N.getInstance().get("ui.plugin.wms.EditWMSQueryPanel.transparency"));
        Insets defaultInsets = new Insets(3, 3, 3, 3);
        this.add(new JLabel(" " + I18N.getInstance().get("org.openjump.core.ui.plugin.layer.pirolraster.RasterImageLayerControllPanel.set-overall-transparency")));
        for (int i = 0; i <= 100; i += 25) {
            this.sliderLabelDictionary.put(new Integer(i), new JLabel(i + "%"));
        }
        this.transparencySlider.setLabelTable(this.sliderLabelDictionary);
        this.transparencySlider.setPaintLabels(true);
        this.transparencySlider.setMaximum(100);
        this.transparencySlider.setMinimum(0);
        this.transparencySlider.setMajorTickSpacing(10);
        this.transparencySlider.setMinorTickSpacing(5);
        this.transparencySlider.setPaintTicks(true);
        this.transparencySlider.setMinimumSize(new Dimension(150, 20));
        this.transparencySlider.setValue(this.getAlpha());
        this.setLayout(new GridLayout(2, 1));
        this.add(this.transparencySlider);
    }

    public void updateStyles() {
        this.layer.setAlpha(this.getAlpha());
        this.layer.fireAppearanceChanged();
    }
}

