/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.window;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import org.openjump.core.ui.images.IconLoader;
import org.openjump.core.ui.plugin.AbstractUiPlugIn;
import org.openjump.core.ui.swing.DetachableInternalFrame;

public class MosaicInternalFramesPlugIn
extends AbstractUiPlugIn {
    public static final ImageIcon ICON = IconLoader.icon("application_mosaic.png");

    public MosaicInternalFramesPlugIn() {
        super(I18N.getInstance().get("org.openjump.core.ui.plugin.window.MosaicInternalFramesPlugIn.Mosaic"), ICON);
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        JMenuItem jmi = context.getFeatureInstaller().addMainMenuItem(new String[]{MenuNames.WINDOW}, (AbstractUiPlugIn)this, Integer.MAX_VALUE);
    }

    @Override
    public EnableCheck getEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(this.workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck());
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        int nbFrames;
        ArrayList<JInternalFrame> iframeList = new ArrayList<JInternalFrame>();
        for (JInternalFrame iframe : context.getWorkbenchFrame().getInternalFrames()) {
            if (iframe instanceof DetachableInternalFrame && ((DetachableInternalFrame)iframe).isDetached()) continue;
            iframeList.add(iframe);
        }
        JInternalFrame[] iframes = new JInternalFrame[]{};
        iframes = iframeList.toArray(iframes);
        int n = nbFrames = iframes.length;
        for (int i = 0; i < nbFrames; ++i) {
            if (!iframes[i].isIcon()) continue;
            --n;
        }
        int iconified_frame_strip = 0;
        if (n != nbFrames) {
            iconified_frame_strip = 30;
        }
        if (n == 0) {
            return true;
        }
        int nColumns = (int)Math.sqrt(n);
        if (n != nColumns * nColumns) {
            ++nColumns;
        }
        int nLines = (n - 1) / nColumns + 1 < nColumns ? nColumns - 1 : nColumns;
        int dx = context.getWorkbenchFrame().getDesktopPane().getWidth() / nColumns;
        int dy = context.getWorkbenchFrame().getDesktopPane().getHeight() / nLines - iconified_frame_strip;
        int k = 0;
        for (int i = 0; i < nColumns; ++i) {
            for (int j = 0; j < nColumns && k < n; ++j, ++k) {
                iframes[i * nColumns + j].setBounds(j * dx, i * dy, dx, dy);
            }
        }
        return true;
    }
}

