/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools.statistics;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.AttributeTypeFilter;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.GenericNames;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.openjump.core.ui.plot.Plot2DPanelOJ;
import org.openjump.sextante.gui.additionalResults.AdditionalResults;

public class CreateBarPlotPlugIn
extends AbstractPlugIn
implements ThreadedPlugIn {
    private String sBarPlot = "Bar-Plot";
    private String sNthfeature = "n-th feature";
    private String CLAYER = "select layer";
    private String ATTRIBUTE = "select attribute";
    private Layer selLayer = null;
    private String selAttribute = null;
    private String sName = "Create Bar Plot";
    private String sWrongDataType = "Wrong datatype of chosen attribute";

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        this.ATTRIBUTE = GenericNames.SELECT_ATTRIBUTE;
        this.CLAYER = GenericNames.SELECT_LAYER;
        this.sBarPlot = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.statistics.CreateBarPlotPlugIn.Bar-Plot");
        this.sNthfeature = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.statistics.CreateBarPlotPlugIn.n-th-feature");
        this.sName = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.statistics.CreateBarPlotPlugIn");
        this.sWrongDataType = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.statistics.CreateBarPlotPlugIn.Wrong-datatype-of-chosen-attribute");
        FeatureInstaller featureInstaller = context.getFeatureInstaller();
        featureInstaller.addMainMenuPlugin(this, new String[]{MenuNames.TOOLS, MenuNames.STATISTICS, MenuNames.PLOT}, this.sName + "...", false, null, CreateBarPlotPlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createAtLeastNLayersMustExistCheck(1)).add(checkFactory.createWindowWithAssociatedTaskFrameMustBeActiveCheck());
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.sName, true);
        this.setDialogValues(dialog, context);
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        return true;
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        this.createPlot(context, this.selLayer);
    }

    private void setDialogValues(final MultiInputDialog dialog, PlugInContext context) {
        dialog.addLayerComboBox(this.CLAYER, context.getCandidateLayer(0), context.getLayerManager());
        List<String> list = AttributeTypeFilter.NUMERIC_FILTER.filter(context.getCandidateLayer(0));
        String val = list.size() > 0 ? list.get(0) : null;
        final JComboBox<String> jcb_attribute = dialog.addComboBox(this.ATTRIBUTE, val, list, this.ATTRIBUTE);
        if (list.size() == 0) {
            jcb_attribute.setEnabled(false);
        }
        dialog.getComboBox(this.CLAYER).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<String> list = AttributeTypeFilter.NUMERIC_FILTER.filter(dialog.getLayer(CreateBarPlotPlugIn.this.CLAYER));
                if (list.size() == 0) {
                    jcb_attribute.setModel(new DefaultComboBoxModel<String>(new String[0]));
                    jcb_attribute.setEnabled(false);
                }
                jcb_attribute.setModel(new DefaultComboBoxModel<String>(list.toArray(new String[0])));
            }
        });
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.selLayer = dialog.getLayer(this.CLAYER);
        this.selAttribute = dialog.getText(this.ATTRIBUTE);
    }

    private boolean createPlot(PlugInContext context, Layer selLayer) throws Exception {
        FeatureCollectionWrapper fc = selLayer.getFeatureCollectionWrapper();
        FeatureSchema fs = fc.getFeatureSchema();
        AttributeType type = fs.getAttributeType(this.selAttribute);
        if (type != AttributeType.DOUBLE && type != AttributeType.INTEGER && type != AttributeType.LONG) {
            context.getWorkbenchFrame().warnUser(this.sWrongDataType);
            return false;
        }
        double[] data = new double[fc.size()];
        int[] fID = new int[fc.size()];
        int i = 0;
        for (Feature f : fc.getFeatures()) {
            Object val = f.getAttribute(this.selAttribute);
            if (val == null || !(val instanceof Number)) continue;
            data[i] = ((Number)val).doubleValue();
            fID[i] = f.getID();
            ++i;
        }
        double[] data2 = new double[i];
        System.arraycopy(data, 0, data2, 0, i);
        int[] fID2 = new int[i];
        System.arraycopy(fID, 0, fID2, 0, i);
        Plot2DPanelOJ plot = new Plot2DPanelOJ();
        plot.addBarPlotOJ(this.selAttribute, data2, fID2, context, selLayer);
        plot.plotToolBar.setVisible(true);
        plot.setAxisLabel(0, this.sNthfeature);
        plot.setAxisLabel(1, this.selAttribute);
        AdditionalResults.addAdditionalResultAndShow(this.sBarPlot, (Object)plot);
        return true;
    }
}

