/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools.statistics;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.AttributeTypeFilter;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.GenericNames;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.apache.commons.lang3.ArrayUtils;
import org.math.array.StatisticSample;
import org.openjump.core.apitools.FeatureSchemaTools;

public class CalcVarianceAndMeanPerClassPlugIn
extends AbstractPlugIn
implements ThreadedPlugIn {
    private String sidetext = "Calculates mean and variance for a specified attribute in accordance with the classes, which need to be given";
    private String OLAYER = "select origin layer";
    private String ATTRIBUTEA = "Select attribute to calculate ratio from";
    private String ATTRIBUTEB = "Select attribute with classification";
    private Layer selLayerO = null;
    private String selAttributeA = null;
    private String selAttributeB = null;
    private String sName = "Calculate Mean and Variance Per Class";
    private String sWrongDataType = "Wrong datatype of chosen attribute";
    private String sCalcRatios = "calculating ratios";

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        this.sidetext = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.statistics.CalcVarianceAndMeanPerClassPlugIn.descriptiontext");
        this.OLAYER = GenericNames.SELECT_LAYER;
        this.ATTRIBUTEA = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.statistics.CalcVarianceAndMeanPerClassPlugIn.Select-attribute-to-calculate-statistics-from");
        this.ATTRIBUTEB = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.statistics.CalcVarianceAndMeanPerClassPlugIn.Select-attribute-with-classification");
        this.sName = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.statistics.CalcVarianceAndMeanPerClassPlugIn");
        this.sWrongDataType = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.statistics.CreateBarPlotPlugIn.Wrong-datatype-of-chosen-attribute");
        this.sCalcRatios = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.statistics.CalcVarianceAndMeanPerClassPlugIn.calculating-statistics");
        context.getFeatureInstaller().addMainMenuPlugin(this, new String[]{MenuNames.TOOLS, MenuNames.STATISTICS}, this.sName + "...", false, null, CalcVarianceAndMeanPerClassPlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithAssociatedTaskFrameMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustExistCheck(1));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.sName, true);
        this.setDialogValues(dialog, context);
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        return true;
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        this.calcClass(context, monitor, this.selLayerO);
    }

    private void setDialogValues(final MultiInputDialog dialog, PlugInContext context) {
        List<String> classAttributes;
        dialog.setSideBarDescription(this.sidetext);
        dialog.addLayerComboBox(this.OLAYER, context.getCandidateLayer(0), context.getLayerManager());
        List<String> numAttributes = AttributeTypeFilter.NUMERIC_FILTER.filter(context.getCandidateLayer(0));
        String valA = numAttributes.size() > 0 ? numAttributes.get(0) : null;
        final JComboBox<String> jcb_attributeA = dialog.addComboBox(this.ATTRIBUTEA, valA, numAttributes, this.ATTRIBUTEA);
        if (numAttributes.size() == 0) {
            jcb_attributeA.setEnabled(false);
        }
        String valB = (classAttributes = AttributeTypeFilter.NO_GEOMETRY_FILTER.filter(context.getCandidateLayer(0))).size() > 0 ? classAttributes.get(0) : null;
        final JComboBox<String> jcb_attributeB = dialog.addComboBox(this.ATTRIBUTEB, valB, classAttributes, this.ATTRIBUTEB);
        if (classAttributes.size() == 0) {
            jcb_attributeB.setEnabled(false);
        }
        dialog.getComboBox(this.OLAYER).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<String> list = AttributeTypeFilter.NUMERIC_FILTER.filter(dialog.getLayer(CalcVarianceAndMeanPerClassPlugIn.this.OLAYER));
                if (list.size() == 0) {
                    jcb_attributeA.setModel(new DefaultComboBoxModel<String>(new String[0]));
                    jcb_attributeA.setEnabled(false);
                }
                jcb_attributeA.setModel(new DefaultComboBoxModel<String>(list.toArray(new String[0])));
            }
        });
        dialog.getComboBox(this.OLAYER).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<String> list = AttributeTypeFilter.NO_GEOMETRY_FILTER.filter(dialog.getLayer(CalcVarianceAndMeanPerClassPlugIn.this.OLAYER));
                if (list.size() == 0) {
                    jcb_attributeB.setModel(new DefaultComboBoxModel<String>(new String[0]));
                    jcb_attributeB.setEnabled(false);
                }
                jcb_attributeB.setModel(new DefaultComboBoxModel<String>(list.toArray(new String[0])));
            }
        });
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.selLayerO = dialog.getLayer(this.OLAYER);
        this.selAttributeA = dialog.getText(this.ATTRIBUTEA);
        this.selAttributeB = dialog.getText(this.ATTRIBUTEB);
    }

    private boolean calcClass(PlugInContext context, TaskMonitor monitor, Layer orgLayer) throws Exception {
        Object vals;
        FeatureCollectionWrapper fcO = orgLayer.getFeatureCollectionWrapper();
        FeatureSchema fsO = fcO.getFeatureSchema();
        AttributeType typeA = fsO.getAttributeType(this.selAttributeA);
        if (typeA != AttributeType.DOUBLE && typeA != AttributeType.INTEGER && typeA != AttributeType.LONG) {
            context.getWorkbenchFrame().warnUser(this.sWrongDataType);
            return false;
        }
        HashMap<Object, ArrayList<Double>> classes = new HashMap<Object, ArrayList<Double>>();
        HashMap mean_var = new HashMap();
        monitor.report(this.sCalcRatios);
        for (Feature feature : fcO.getFeatures()) {
            Object key = feature.getAttribute(this.selAttributeB);
            Object val = feature.getAttribute(this.selAttributeA);
            ArrayList<Double> vals2 = (ArrayList<Double>)classes.get(key);
            if (vals2 == null) {
                vals2 = new ArrayList<Double>();
                classes.put(key, vals2);
            }
            if (val == null) continue;
            vals2.add(((Number)val).doubleValue());
        }
        for (Map.Entry entry : classes.entrySet()) {
            vals = ArrayUtils.toPrimitive((Double[])((List)entry.getValue()).toArray(new Double[0]));
            mean_var.put(entry.getKey(), new double[]{vals == null || ((double[])vals).length == 0 ? Double.NaN : StatisticSample.mean((double[])vals), vals == null || ((double[])vals).length == 0 ? Double.NaN : StatisticSample.variance((double[])vals)});
        }
        FeatureSchema newFeatureSchema = fsO.clone();
        if (!newFeatureSchema.hasAttribute(this.selAttributeA + "_mean")) {
            newFeatureSchema.addAttribute(this.selAttributeA + "_mean", AttributeType.DOUBLE);
        }
        if (!newFeatureSchema.hasAttribute(this.selAttributeA + "_var")) {
            newFeatureSchema.addAttribute(this.selAttributeA + "_var", AttributeType.DOUBLE);
        }
        FeatureDataset featureDataset = new FeatureDataset(newFeatureSchema);
        vals = fcO.getFeatures().iterator();
        while (vals.hasNext()) {
            Feature feature = (Feature)vals.next();
            Feature newFeature = FeatureSchemaTools.copyFeature(feature, newFeatureSchema);
            newFeature.setAttribute(this.selAttributeA + "_mean", (Object)((double[])mean_var.get(feature.getAttribute(this.selAttributeB)))[0]);
            newFeature.setAttribute(this.selAttributeA + "_var", (Object)((double[])mean_var.get(feature.getAttribute(this.selAttributeB)))[1]);
            featureDataset.add(newFeature);
        }
        String name = this.selAttributeA + "_mean_var";
        context.addLayer(StandardCategoryNames.WORKING, name, featureDataset);
        return true;
    }
}

