/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools.geometrychange;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.Macro;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.AttributeTypeFilter;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;

public class PointsToPathsPlugIn
extends AbstractPlugIn
implements ThreadedPlugIn {
    private static final String KEY = PointsToPathsPlugIn.class.getName();
    private static final String P_LAYER_NAME = "LayerName";
    private static final String P_USE_SELECTION = "UseSelection";
    private static final String P_ORDER_BY_ATTRIBUTE = "OrderBy";
    private static final String P_GROUP_BY_ATTRIBUTE = "GroupBy";
    private static String UI_LAYER;
    private static String UI_USE_SELECTION;
    private static String UI_ORDER_BY_ATTRIBUTE;
    private static String UI_ORDER_BY_ATTRIBUTE_TT;
    private static String UI_GROUP_BY;
    private static String UI_GROUP_BY_ATTRIBUTE;
    private static String UI_GROUP_BY_ATTRIBUTE_TT;

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        context.getFeatureInstaller().addMainMenuPlugin(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_EDIT_GEOMETRY}, this.getName(), false, null, PointsToPathsPlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustExistCheck(1));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        UI_USE_SELECTION = I18N.getInstance().get(KEY + ".use-selection");
        UI_LAYER = I18N.getInstance().get(KEY + ".layer");
        UI_ORDER_BY_ATTRIBUTE = I18N.getInstance().get(KEY + ".order-by-attribute");
        UI_ORDER_BY_ATTRIBUTE_TT = I18N.getInstance().get(KEY + ".order-by-attribute-tooltip");
        UI_GROUP_BY = I18N.getInstance().get(KEY + ".group-by-option");
        UI_GROUP_BY_ATTRIBUTE = I18N.getInstance().get(KEY + ".group-by-attribute");
        UI_GROUP_BY_ATTRIBUTE_TT = I18N.getInstance().get(KEY + ".group-by-attribute-tooltip");
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), I18N.getInstance().get(KEY), true);
        this.setDialogValues(dialog, context);
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        return true;
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        List<Feature> list;
        Layer layer = context.getLayerManager().getLayer((String)this.getParameter(P_LAYER_NAME));
        final String orderByAttribute = this.getStringParam(P_ORDER_BY_ATTRIBUTE);
        FeatureSchema featureSchema = layer.getFeatureCollectionWrapper().getFeatureSchema();
        FeatureDataset dataset = new FeatureDataset(featureSchema);
        List<Feature> input = this.getBooleanParam(P_USE_SELECTION) != false ? new ArrayList<Feature>(context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems(layer)) : layer.getFeatureCollectionWrapper().getFeatures();
        HashMap map = new HashMap();
        String keyName = this.getStringParam(P_GROUP_BY_ATTRIBUTE);
        int countNonPoint = 0;
        for (Feature feature : input) {
            if (feature.getGeometry() instanceof Point) {
                Object key = keyName == null ? "" : feature.getAttribute(keyName);
                list = (ArrayList<Feature>)map.get(key);
                if (list == null) {
                    list = new ArrayList<Feature>();
                    map.put((String)key, list);
                }
                list.add(feature);
                continue;
            }
            ++countNonPoint;
        }
        if (countNonPoint > 0) {
            context.getWorkbenchFrame().warnUser(I18N.getInstance().get(KEY + ".non-point-warning"));
        }
        Comparator<Feature> comparator = Comparator.comparing(new Function<Feature, Comparable>(){

            @Override
            public Comparable apply(Feature f) {
                if (f.getSchema().hasAttribute(orderByAttribute)) {
                    return (Comparable)f.getAttribute(orderByAttribute);
                }
                return Integer.valueOf(f.getID());
            }
        });
        for (Map.Entry entry : map.entrySet()) {
            list = (List)entry.getValue();
            list.sort(comparator);
            Feature f = ((Feature)list.get(0)).clone(false);
            CoordinateList coords = new CoordinateList();
            for (Feature p : list) {
                coords.add(p.getGeometry().getCoordinate(), false);
            }
            if (coords.size() > 1) {
                f.setGeometry((Geometry)((Feature)list.get(0)).getGeometry().getFactory().createLineString(coords.toCoordinateArray()));
            } else {
                context.getWorkbenchFrame().warnUser(I18N.getInstance().get(KEY + ".invalid-path"));
                f.setGeometry((Geometry)((Feature)list.get(0)).getGeometry().getFactory().createPoint(coords.getCoordinate(0)));
            }
            dataset.add(f);
        }
        if (dataset.isEmpty()) {
            context.getWorkbenchFrame().warnUser(I18N.getInstance().get("ui.plugin.analysis.BufferPlugIn.empty-result-set"));
            return;
        }
        context.addLayer(StandardCategoryNames.RESULT, layer.getName() + "-paths", dataset);
        if (context.getWorkbenchContext().getBlackboard().get("MacroStarted", false)) {
            ((Macro)context.getWorkbenchContext().getBlackboard().get("Macro")).addProcess(this);
        }
    }

    private void setDialogValues(final MultiInputDialog dialog, final PlugInContext context) {
        JComboBox<Layer> layerComboBox = dialog.addLayerComboBox(UI_LAYER, context.getCandidateLayer(0), context.getLayerManager());
        boolean hasSelection = !context.getLayerViewPanel().getSelectionManager().getSelectedItems(context.getCandidateLayer(0)).isEmpty();
        final JCheckBox useSelectionCheckBox = dialog.addCheckBox(UI_USE_SELECTION, hasSelection);
        useSelectionCheckBox.setEnabled(hasSelection);
        dialog.addSeparator();
        JComboBox<String> orderByAttributeComboBox = dialog.addAttributeComboBox(UI_ORDER_BY_ATTRIBUTE, UI_LAYER, new AttributeTypeFilter(158), UI_ORDER_BY_ATTRIBUTE_TT);
        dialog.addSeparator();
        final JCheckBox groupByCheckBox = dialog.addCheckBox(UI_GROUP_BY, false);
        final JComboBox<String> groupByAttributeComboBox = dialog.addAttributeComboBox(UI_GROUP_BY_ATTRIBUTE, UI_LAYER, new AttributeTypeFilter(134), UI_GROUP_BY_ATTRIBUTE_TT);
        groupByAttributeComboBox.setEnabled(groupByCheckBox.isSelected());
        layerComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean hasSelection = !context.getLayerViewPanel().getSelectionManager().getSelectedItems(dialog.getLayer(UI_LAYER)).isEmpty();
                useSelectionCheckBox.setEnabled(hasSelection);
                if (!hasSelection) {
                    useSelectionCheckBox.setSelected(hasSelection);
                }
                groupByCheckBox.setEnabled(AttributeTypeFilter.NO_GEOMETRY_FILTER.filter(dialog.getLayer(UI_LAYER)).size() > 1);
                groupByAttributeComboBox.setEnabled(AttributeTypeFilter.NO_GEOMETRY_FILTER.filter(dialog.getLayer(UI_LAYER)).size() > 1);
                dialog.getLayer(UI_LAYER).getFeatureCollectionWrapper().getFeatureSchema();
            }
        });
        groupByCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                groupByAttributeComboBox.setEnabled(groupByCheckBox.isSelected());
            }
        });
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.addParameter(P_USE_SELECTION, dialog.getBoolean(UI_USE_SELECTION));
        this.addParameter(P_LAYER_NAME, dialog.getLayer(UI_LAYER).getName());
        this.addParameter(P_ORDER_BY_ATTRIBUTE, dialog.getValue(UI_ORDER_BY_ATTRIBUTE));
        if (dialog.getBoolean(UI_GROUP_BY)) {
            this.addParameter(P_GROUP_BY_ATTRIBUTE, dialog.getValue(UI_GROUP_BY_ATTRIBUTE));
        } else {
            this.addParameter(P_GROUP_BY_ATTRIBUTE, null);
        }
    }
}

