/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools.generate;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.task.RefreshRated;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.task.TaskMonitorV2Util;
import com.vividsolutions.jump.util.Timer;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.util.Assert;
import org.openjump.core.ui.images.IconLoader;
import org.openjump.core.ui.plugin.AbstractUiPlugIn;

public class CreateGridPlugIn
extends AbstractUiPlugIn
implements ThreadedPlugIn {
    private static final String EXTENT = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.generate.CreateGridPlugIn.extent");
    private static final String ALL_LAYERS = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.generate.CreateGridPlugIn.all-layers");
    private static final String SELECTED_LAYERS = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.generate.CreateGridPlugIn.selected-layers");
    private static final String SELECTED_FEATURES = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.generate.CreateGridPlugIn.selected-features");
    private static final String VIEW = I18N.getInstance().get("ui.MenuNames.VIEW");
    private static final String SYNCHRONIZE = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.generate.CreateGridPlugIn.synchronize");
    private static final String DX = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.generate.CreateGridPlugIn.dx");
    private static final String DY = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.generate.CreateGridPlugIn.dy");
    private static final String CREATE_POINTS = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.generate.CreateGridPlugIn.points");
    private static final String CREATE_LINES = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.generate.CreateGridPlugIn.lines");
    private static final String CREATE_POLYS = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.generate.CreateGridPlugIn.polygons");
    private static final String POINT_GRID = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.generate.CreateGridPlugIn.point-grid");
    private static final String LINE_GRID = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.generate.CreateGridPlugIn.line-grid");
    private static final String POLY_GRID = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.generate.CreateGridPlugIn.poly_grid");
    private static final String NULL_EXTENT = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.generate.CreateGridPlugIn.null-extent");
    String extent = ALL_LAYERS;
    boolean synchronize = true;
    double dx = 1000.0;
    double dy = 1000.0;
    boolean createPoints = false;
    boolean createLines = true;
    boolean createPolys = false;
    TaskMonitor taskMonitor = null;
    private int interval = 300;
    private long lastMsg = 0L;

    @Override
    public void initialize(PlugInContext context) throws Exception {
        context.getFeatureInstaller().addMainMenuPlugin(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_GENERATE}, this.getName() + "...", false, IconLoader.icon("create_grid.gif"), this.createEnableCheck(context.getWorkbenchContext()), -1);
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createTaskWindowMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustExistCheck(1));
    }

    @Override
    public Icon getIcon() {
        return IconLoader.icon("create_grid.gif");
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        this.initDialog(dialog, context);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        return true;
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        this.taskMonitor = monitor;
        TaskMonitorV2Util.setTitle(monitor, this.getName());
        monitor.allowCancellationRequests();
        if (monitor instanceof RefreshRated) {
            ((RefreshRated)((Object)monitor)).setRefreshRate(this.interval);
        }
        this.createGrid(context);
    }

    private void initDialog(MultiInputDialog dialog, PlugInContext context) {
        JComboBox<String> extentComboBox = dialog.addComboBox(EXTENT, this.extent, Arrays.asList(ALL_LAYERS, SELECTED_LAYERS, SELECTED_FEATURES, VIEW), null);
        final JCheckBox synchronizeCheckBox = dialog.addCheckBox(SYNCHRONIZE, this.synchronize);
        final JTextField dxField = dialog.addDoubleField(DX, this.dx, 12);
        final JTextField dyField = dialog.addDoubleField(DY, this.dy, 12);
        JCheckBox outputPointsCheckBox = dialog.addCheckBox(CREATE_POINTS, this.createPoints);
        JCheckBox outputLinesCheckBox = dialog.addCheckBox(CREATE_LINES, this.createLines);
        JCheckBox outputPolysCheckBox = dialog.addCheckBox(CREATE_POLYS, this.createPolys);
        final DocumentListener dxListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                dyField.setText(dxField.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                dyField.setText(dxField.getText());
            }
        };
        dxField.getDocument().addDocumentListener(dxListener);
        dyField.setEditable(false);
        synchronizeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (synchronizeCheckBox.isSelected()) {
                    dxField.getDocument().addDocumentListener(dxListener);
                    dyField.setText(dxField.getText());
                    dyField.setEditable(false);
                } else {
                    dxField.getDocument().removeDocumentListener(dxListener);
                    dyField.setEditable(true);
                }
            }
        });
        GUIUtil.centreOnWindow(dialog);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.extent = dialog.getText(EXTENT);
        this.dx = dialog.getDouble(DX);
        this.dy = dialog.getDouble(DY);
        this.createPoints = dialog.getBoolean(CREATE_POINTS);
        this.createLines = dialog.getBoolean(CREATE_LINES);
        this.createPolys = dialog.getBoolean(CREATE_POLYS);
    }

    public void createGrid(PlugInContext context) {
        FeatureCollection fc;
        Envelope env = this.getEnvelope(context);
        if (env.isNull()) {
            context.getWorkbenchFrame().warnUser(NULL_EXTENT);
            return;
        }
        double xm = Math.floor(env.getMinX() / this.dx) * this.dx;
        double ym = Math.floor(env.getMinY() / this.dy) * this.dy;
        double xM = Math.ceil(env.getMaxX() / this.dx) * this.dx;
        double yM = Math.ceil(env.getMaxY() / this.dy) * this.dy;
        if (this.createPoints) {
            fc = this.createPoints(context, xm, ym, xM, yM);
            if (!this.isCancelled()) {
                context.getLayerManager().addLayer(StandardCategoryNames.WORKING, POINT_GRID, fc);
            }
        }
        if (this.createLines) {
            fc = this.createLines(context, xm, ym, xM, yM);
            if (!this.isCancelled()) {
                context.getLayerManager().addLayer(StandardCategoryNames.WORKING, LINE_GRID, fc);
            }
        }
        if (this.createPolys) {
            fc = this.createPolys(context, xm, ym, xM, yM);
            if (!this.isCancelled()) {
                context.getLayerManager().addLayer(StandardCategoryNames.WORKING, POLY_GRID, fc);
            }
        }
    }

    private Envelope getEnvelope(PlugInContext context) {
        Envelope env = new Envelope();
        if (this.extent.equals(ALL_LAYERS)) {
            env = context.getLayerManager().getEnvelopeOfAllLayers(true);
        } else {
            if (this.extent.equals(SELECTED_LAYERS)) {
                Layer[] layers;
                for (Layer layer : layers = context.getLayerNamePanel().getSelectedLayers()) {
                    env.expandToInclude(layer.getFeatureCollectionWrapper().getEnvelope());
                }
                return env;
            }
            if (this.extent.equals(SELECTED_FEATURES)) {
                Collection<Feature> features = context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems();
                Iterator<Feature> iterator = features.iterator();
                while (iterator.hasNext()) {
                    Feature o;
                    Feature feature = o = iterator.next();
                    env.expandToInclude(feature.getGeometry().getEnvelopeInternal());
                }
            } else if (this.extent.equals(VIEW)) {
                env = context.getWorkbenchContext().getLayerViewPanel().getViewport().getEnvelopeInModelCoordinates();
            } else {
                Assert.shouldNeverReachHere();
            }
        }
        return env;
    }

    private FeatureCollection createPoints(PlugInContext context, double xm, double ym, double xM, double yM) {
        TaskMonitorV2Util.report(this.taskMonitor, this.getName());
        FeatureSchema fs = new FeatureSchema();
        fs.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        fs.addAttribute("NUM", AttributeType.STRING);
        FeatureDataset ds = new FeatureDataset(fs);
        GeometryFactory gf = new GeometryFactory();
        long numPoints = (long)((xM - xm + this.dx) / this.dx * ((yM - ym + this.dy) / this.dy));
        long curPoint = 0L;
        for (double x = xm; x <= xM && !this.isCancelled(); x += this.dx) {
            for (double y = yM; y >= ym && !this.isCancelled(); y -= this.dy) {
                Point point = gf.createPoint(new Coordinate(x, y));
                BasicFeature f = new BasicFeature(fs);
                f.setGeometry((Geometry)point);
                f.setAttribute("NUM", (Object)("" + x + "-" + y));
                ds.add(f);
                this.reportItems(++curPoint, numPoints, CREATE_POINTS);
            }
        }
        return ds;
    }

    private FeatureCollection createLines(PlugInContext context, double xm, double ym, double xM, double yM) {
        BasicFeature f;
        LineString line;
        FeatureSchema fs = new FeatureSchema();
        fs.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        fs.addAttribute("NUM", AttributeType.STRING);
        final long numLines = (long)((xM - xm) / this.dx + (yM - ym) / this.dy);
        FeatureDataset ds = new FeatureDataset(fs){

            @Override
            public void add(Feature feature) {
                super.add(feature);
                CreateGridPlugIn.this.reportItems(this.getFeatures().size(), numLines, CREATE_LINES);
            }
        };
        GeometryFactory gf = new GeometryFactory();
        for (double x = xm; x <= xM && !this.isCancelled(); x += this.dx) {
            line = gf.createLineString(new Coordinate[]{new Coordinate(x, yM), new Coordinate(x, ym)});
            f = new BasicFeature(fs);
            f.setGeometry((Geometry)line);
            f.setAttribute("NUM", (Object)("" + x));
            ds.add(f);
        }
        for (double y = yM; y >= ym && !this.isCancelled(); y -= this.dy) {
            line = gf.createLineString(new Coordinate[]{new Coordinate(xm, y), new Coordinate(xM, y)});
            f = new BasicFeature(fs);
            f.setGeometry((Geometry)line);
            f.setAttribute("NUM", (Object)("" + y));
            ds.add(f);
        }
        return ds;
    }

    private FeatureCollection createPolys(PlugInContext context, double xm, double ym, double xM, double yM) {
        FeatureSchema fs = new FeatureSchema();
        fs.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        fs.addAttribute("NUM", AttributeType.STRING);
        final long numPolys = (long)((xM - xm) / this.dx * ((yM - ym) / this.dx));
        FeatureDataset ds = new FeatureDataset(fs){

            @Override
            public void add(Feature feature) {
                super.add(feature);
                CreateGridPlugIn.this.reportItems(this.getFeatures().size(), numPolys, CREATE_POLYS);
            }
        };
        GeometryFactory gf = new GeometryFactory();
        for (double x = xm; x <= xM - this.dx && !this.isCancelled(); x += this.dx) {
            for (double y = yM; y >= ym + this.dy && !this.isCancelled(); y -= this.dy) {
                Polygon poly = gf.createPolygon(gf.createLinearRing(new Coordinate[]{new Coordinate(x, y), new Coordinate(x + this.dx, y), new Coordinate(x + this.dx, y - this.dy), new Coordinate(x, y - this.dy), new Coordinate(x, y)}), new LinearRing[0]);
                BasicFeature f = new BasicFeature(fs);
                f.setGeometry((Geometry)poly);
                f.setAttribute("NUM", (Object)("" + x + "-" + y));
                ds.add(f);
            }
        }
        return ds;
    }

    private void reportItems(long itemsDone, long itemsTotal, String message) {
        long now = Timer.milliSecondsSince(0L);
        if (now - (long)this.interval >= this.lastMsg) {
            this.lastMsg = now;
            TaskMonitorV2Util.report(this.taskMonitor, itemsDone, itemsTotal, message);
        }
    }

    private boolean isCancelled() {
        return this.taskMonitor.isCancelRequested();
    }
}

