/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.tools.AttributeMapping;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.AttributeTypeFilter;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.locationtech.jts.geom.Geometry;
import org.openjump.core.ui.plugin.AbstractThreadedUiPlugIn;

public class JoinTableFromExistingLayerPlugIn
extends AbstractThreadedUiPlugIn {
    private static final String sSidebar = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.JoinTableFromExistingLayerPlugIn.description");
    private static final String BASE_LAYER = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.JoinTableFromExistingLayerPlugIn.Base-layer-that-should-be-extended");
    private static final String JOIN_LAYER = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.JoinTableFromExistingLayerPlugIn.Layer-with-attributes-to-join");
    private static final String BASE_LAYER_ID = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.JoinTableFromExistingLayerPlugIn.Base-layer-attribute-with-unique-feature-IDs");
    private static final String JOIN_LAYER_ID = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.JoinTableFromExistingLayerPlugIn.Attribute-with-unique-IDs");
    private static final String sDisplayUnmatched = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.JoinTableFromExistingLayerPlugIn.display-unmatched-items-from-base-layer");
    private static final String sAllMatched = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.JoinTableFromExistingLayerPlugIn.All-items-matched-no-layer-with-unmatched-features");
    private static final String sItemsProcessed = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.generate.PointLayerFromAttributeTablePlugIn.items-processed");
    private static final String sJoinResult = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.JoinTableFromExistingLayerPlugIn.join-result");
    private static final String sUnmatchedItems = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.JoinTableFromExistingLayerPlugIn.unmatched-items");
    private static final String sTooManyItems = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.JoinTableFromExistingLayerPlugIn.multiple-matches");
    private static final String sMultiMatchesMsg = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.JoinTableFromExistingLayerPlugIn.multiple-matches-for-feature-FID");
    private Layer baseLayer = null;
    private Layer joinLayer = null;
    private String baseLayerIdAttribute = "";
    private String joinLayerJoinAttribute = "";
    private boolean displayUnmatched = true;
    private MultiInputDialog dialog;

    @Override
    public String getName() {
        return I18N.getInstance().get("org.openjump.core.ui.plugin.tools.JoinTableFromExistingLayerPlugIn") + "...";
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        context.getFeatureInstaller().addMainMenuPlugin(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_EDIT_ATTRIBUTES}, this.getName(), false, null, JoinTableFromExistingLayerPlugIn.createEnableCheck(context.getWorkbenchContext()), -1);
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createTaskWindowMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustExistCheck(2));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.initDialog(context);
        this.dialog.setVisible(true);
        if (!this.dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(this.dialog);
        return true;
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        monitor.allowCancellationRequests();
        FeatureCollectionWrapper baseFC = this.baseLayer.getFeatureCollectionWrapper();
        FeatureCollectionWrapper joinFC = this.joinLayer.getFeatureCollectionWrapper();
        int baseLayerAttributeIndex = baseFC.getFeatureSchema().getAttributeIndex(this.baseLayerIdAttribute);
        int joinLayerAttributeIndex = joinFC.getFeatureSchema().getAttributeIndex(this.joinLayerJoinAttribute);
        AttributeMapping mapping = new AttributeMapping(baseFC.getFeatureSchema(), joinFC.getFeatureSchema());
        FeatureDataset featuresFound = new FeatureDataset(mapping.createSchema("Geometry"));
        FeatureDataset featuresMissing = new FeatureDataset(baseFC.getFeatureSchema());
        FeatureDataset featuresWithManyMatches = new FeatureDataset(mapping.createSchema("Geometry"));
        int i = 0;
        int baseLayerSize = baseFC.size();
        for (Feature baseFeature : baseFC.getFeatures()) {
            monitor.report(i++, baseLayerSize, sItemsProcessed);
            Object baseId = baseFeature.getAttribute(baseLayerAttributeIndex);
            Feature firstJoinFeature = null;
            ArrayList<Feature> nextJoinFeatures = new ArrayList<Feature>();
            int countMatches = 0;
            for (Feature joinCandidateFeature : joinFC.getFeatures()) {
                Object joinId = joinCandidateFeature.getAttribute(joinLayerAttributeIndex);
                if (baseId == null || joinId == null || !baseId.toString().equals(joinId.toString())) continue;
                if (countMatches == 0) {
                    firstJoinFeature = joinCandidateFeature;
                } else {
                    nextJoinFeatures.add(joinCandidateFeature);
                    context.getWorkbenchFrame().warnUser(sMultiMatchesMsg + " : " + baseFeature.getID());
                }
                ++countMatches;
            }
            if (countMatches > 0) {
                BasicFeature newFeature = new BasicFeature(featuresFound.getFeatureSchema());
                mapping.transferAttributes(baseFeature, firstJoinFeature, newFeature);
                newFeature.setGeometry((Geometry)baseFeature.getGeometry().clone());
                if (countMatches == 1) {
                    featuresFound.add(newFeature);
                    continue;
                }
                featuresWithManyMatches.add(newFeature);
                for (Feature match : nextJoinFeatures) {
                    newFeature = new BasicFeature(featuresFound.getFeatureSchema());
                    mapping.transferAttributes(baseFeature, match, newFeature);
                    newFeature.setGeometry((Geometry)baseFeature.getGeometry().clone());
                    featuresWithManyMatches.add(newFeature);
                }
                continue;
            }
            featuresMissing.add(baseFeature.clone(true));
        }
        if (featuresFound.size() > 0) {
            context.addLayer(StandardCategoryNames.RESULT, this.baseLayer.getName() + " - " + sJoinResult, featuresFound);
        }
        if (featuresWithManyMatches.size() > 0) {
            context.addLayer(StandardCategoryNames.RESULT, this.baseLayer.getName() + " - " + sTooManyItems, featuresWithManyMatches);
        }
        if (this.displayUnmatched && featuresMissing.size() > 0) {
            context.addLayer(StandardCategoryNames.RESULT, this.baseLayer.getName() + " - " + sUnmatchedItems, featuresMissing);
        } else {
            context.getWorkbenchFrame().warnUser(sAllMatched);
        }
    }

    private void initDialog(PlugInContext context) {
        this.dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        this.dialog.setSideBarDescription(sSidebar);
        this.dialog.addLayerComboBox(BASE_LAYER, context.getCandidateLayer(0), null, context.getLayerManager());
        List<String> baseLayerAttributeList = AttributeTypeFilter.NUMSTRING_FILTER.filter(context.getCandidateLayer(0));
        String valBaseAttribute = baseLayerAttributeList.size() > 0 ? baseLayerAttributeList.get(0) : null;
        final JComboBox<String> baseAttributeBox = this.dialog.addComboBox(BASE_LAYER_ID, valBaseAttribute, baseLayerAttributeList, BASE_LAYER_ID);
        if (baseLayerAttributeList.size() == 0) {
            baseAttributeBox.setEnabled(false);
        }
        this.dialog.addSeparator();
        this.dialog.addLayerComboBox(JOIN_LAYER, context.getCandidateLayer(0), null, context.getLayerManager());
        List<String> joinLayerAttributeList = AttributeTypeFilter.NUMSTRING_FILTER.filter(context.getCandidateLayer(0));
        String valJoinAttribute = joinLayerAttributeList.size() > 0 ? joinLayerAttributeList.get(0) : null;
        final JComboBox<String> tableAttributeBox = this.dialog.addComboBox(JOIN_LAYER_ID, valJoinAttribute, joinLayerAttributeList, JOIN_LAYER_ID);
        if (joinLayerAttributeList.size() == 0) {
            tableAttributeBox.setEnabled(false);
        }
        this.dialog.addSeparator();
        this.dialog.addCheckBox(sDisplayUnmatched, this.displayUnmatched);
        this.dialog.getComboBox(BASE_LAYER).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<String> list = AttributeTypeFilter.NUMSTRING_FILTER.filter(JoinTableFromExistingLayerPlugIn.this.dialog.getLayer(BASE_LAYER));
                if (list.size() == 0) {
                    baseAttributeBox.setModel(new DefaultComboBoxModel<String>(new String[0]));
                    baseAttributeBox.setEnabled(false);
                } else {
                    baseAttributeBox.setModel(new DefaultComboBoxModel<String>(list.toArray(new String[0])));
                    baseAttributeBox.setEnabled(true);
                }
            }
        });
        this.dialog.getComboBox(JOIN_LAYER).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<String> list = AttributeTypeFilter.NUMSTRING_FILTER.filter(JoinTableFromExistingLayerPlugIn.this.dialog.getLayer(JOIN_LAYER));
                if (list.size() == 0) {
                    tableAttributeBox.setModel(new DefaultComboBoxModel<String>(new String[0]));
                    tableAttributeBox.setEnabled(false);
                } else {
                    tableAttributeBox.setModel(new DefaultComboBoxModel<String>(list.toArray(new String[0])));
                    tableAttributeBox.setEnabled(true);
                }
            }
        });
        GUIUtil.centreOnWindow(this.dialog);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.baseLayer = dialog.getLayer(BASE_LAYER);
        this.joinLayer = dialog.getLayer(JOIN_LAYER);
        this.baseLayerIdAttribute = dialog.getText(BASE_LAYER_ID);
        this.joinLayerJoinAttribute = dialog.getText(JOIN_LAYER_ID);
        this.displayUnmatched = dialog.getBoolean(sDisplayUnmatched);
    }
}

