/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.MeasureLayerFinder;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.OptionsDialog;
import com.vividsolutions.jump.workbench.ui.cursortool.CoordinateListMetrics;
import com.vividsolutions.jump.workbench.ui.cursortool.PolygonTool;
import com.vividsolutions.jump.workbench.ui.cursortool.QuasimodeTool;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.Timer;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.openide.awt.DropDownButtonFactory;
import org.openjump.core.ui.plugin.tools.AdvancedMeasureOptionsPanel;

public class AdvancedMeasureTool
extends PolygonTool
implements ActionListener {
    public static final int MEASURE_MODE_DISTANCE = 1;
    public static final int MEASURE_MODE_AREA = 2;
    JPopupMenu popupMenu;
    JMenuItem distanceMenuItem;
    JMenuItem areaMenuItem;
    JMenuItem optionsMenuItem;
    private int measureMode = 1;
    private JToggleButton toolbarButton = null;
    WorkbenchContext context;
    Point mousePosition = null;
    Shape lastShape = null;
    private static Timer doubleClickTimer;

    public AdvancedMeasureTool(WorkbenchContext context) {
        super(context);
        this.context = context;
        this.allowSnapping();
        this.setMetricsDisplay(new CoordinateListMetrics());
        this.setCloseRing(false);
        this.popupMenu = new JPopupMenu();
        this.distanceMenuItem = new JMenuItem(I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AdvancedMeasureTool.distance-measuring"), IconLoader.icon("Ruler.gif"));
        this.distanceMenuItem.addActionListener(this);
        this.popupMenu.add(this.distanceMenuItem);
        this.areaMenuItem = new JMenuItem(I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AdvancedMeasureTool.area-measuring"), IconLoader.icon("Ruler_area.gif"));
        this.areaMenuItem.addActionListener(this);
        this.popupMenu.add(this.areaMenuItem);
        this.popupMenu.addSeparator();
        this.optionsMenuItem = new JMenuItem(I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AdvancedMeasureTool.options"));
        this.optionsMenuItem.addActionListener(this);
        this.popupMenu.add(this.optionsMenuItem);
        this.toolbarButton = DropDownButtonFactory.createDropDownToggleButton(this.getIcon(), this.getPopupMenu());
    }

    @Override
    public Icon getIcon() {
        String iconName = "Ruler.gif";
        switch (this.measureMode) {
            case 1: {
                iconName = "Ruler.gif";
                break;
            }
            case 2: {
                iconName = "Ruler_area.gif";
            }
        }
        return IconLoader.icon(iconName);
    }

    @Override
    public Cursor getCursor() {
        String cursorName = "RulerCursor.gif";
        switch (this.measureMode) {
            case 1: {
                cursorName = "RulerCursor.gif";
                break;
            }
            case 2: {
                cursorName = "RulerCursor_area.gif";
            }
        }
        return AdvancedMeasureTool.createCursor(IconLoader.icon(cursorName).getImage());
    }

    @Override
    public void mouseLocationChanged(MouseEvent e) {
        this.mousePosition = e.getPoint();
        try {
            if (this.isShapeOnScreen()) {
                ArrayList<Coordinate> currentCoordinates = new ArrayList<Coordinate>(this.getCoordinates());
                currentCoordinates.add(this.getPanel().getViewport().toModelCoordinate(e.getPoint()));
            }
            super.mouseLocationChanged(e);
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.getCoordinates().size() == 1 && e.getButton() == 1) {
            int clickCount = e.getClickCount();
            if (clickCount == 1) {
                int multiClickInterval = (Integer)Toolkit.getDefaultToolkit().getDesktopProperty("awt.multiClickInterval");
                doubleClickTimer = new Timer(multiClickInterval, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FeatureCollectionWrapper featureCollectionWrapper;
                        MeasureLayerFinder measureLayerFinder = new MeasureLayerFinder(AdvancedMeasureTool.this.getPanel(), AdvancedMeasureTool.this.context);
                        if (measureLayerFinder.getLayer() != null && (featureCollectionWrapper = measureLayerFinder.getMeasureLayer().getFeatureCollectionWrapper()).getFeatures().size() > 0) {
                            featureCollectionWrapper.clear();
                        }
                    }
                });
                doubleClickTimer.setRepeats(false);
                doubleClickTimer.start();
            } else if (clickCount == 2) {
                doubleClickTimer.stop();
            }
        }
    }

    @Override
    protected boolean isFinishingRelease(MouseEvent e) {
        boolean finishingRelease = super.isFinishingRelease(e);
        return finishingRelease && this.getCoordinates().size() > 1;
    }

    private boolean doubleClicked() {
        return this.getCoordinates().size() == 1;
    }

    @Override
    protected void gestureFinished() throws NoninvertibleTransformException {
        this.reportNothingToUndoYet();
        this.getMetrics().displayMetrics(this.getCoordinates(), this.getPanel(), this.measureMode == 2);
        LineString measureGeometry = null;
        if (this.doubleClicked()) {
            measureGeometry = null;
        } else if (this.measureMode == 1) {
            List<Coordinate> coordinates = this.getCoordinates();
            measureGeometry = new GeometryFactory().createLineString(this.toArray(coordinates));
        } else if (this.measureMode == 2) {
            if (!this.checkPolygon()) {
                return;
            }
            this.getPanel().setViewportInitialized(true);
            measureGeometry = this.getPolygon();
        }
        MeasureLayerFinder measureLayerFinder = new MeasureLayerFinder(this.getPanel(), this.context);
        measureLayerFinder.setMeasure((Geometry)measureGeometry);
        if (!measureLayerFinder.getLayer().isVisible()) {
            measureLayerFinder.getLayer().setVisible(true);
        }
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public JToggleButton getToolbarButton() {
        return this.toolbarButton;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.distanceMenuItem) {
            this.measureMode = 1;
            if (this.toolbarButton != null) {
                this.toolbarButton.setIcon(IconLoader.icon("Ruler.gif"));
                this.toolbarButton.setToolTipText(I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AdvancedMeasureTool.distance-measuring"));
                this.toolbarButton.setSelected(true);
                this.context.getLayerViewPanel().setCurrentCursorTool(QuasimodeTool.createWithDefaults(this));
            }
            this.setCloseRing(false);
        } else if (e.getSource() == this.areaMenuItem) {
            this.measureMode = 2;
            if (this.toolbarButton != null) {
                this.toolbarButton.setIcon(IconLoader.icon("Ruler_area.gif"));
                this.toolbarButton.setToolTipText(I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AdvancedMeasureTool.area-measuring"));
                this.toolbarButton.setSelected(true);
                this.context.getLayerViewPanel().setCurrentCursorTool(QuasimodeTool.createWithDefaults(this));
            }
            this.setCloseRing(true);
        } else if (e.getSource() == this.optionsMenuItem) {
            OptionsDialog optionsDialog = OptionsDialog.instance(this.context.getWorkbench());
            JTabbedPane tabbedPane = optionsDialog.getTabbedPane();
            for (int i = 0; i < tabbedPane.getTabCount(); ++i) {
                if (!(tabbedPane.getComponentAt(i) instanceof AdvancedMeasureOptionsPanel)) continue;
                tabbedPane.setSelectedIndex(i);
                break;
            }
            GUIUtil.centreOnWindow(optionsDialog);
            optionsDialog.setVisible(true);
        }
        this.context.getLayerViewPanel().setCursor(this.getCursor());
    }
}

