/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.raster;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.media.jai.PlanarImage;
import org.apache.commons.imaging.ImageInfo;
import org.apache.commons.imaging.Imaging;
import org.locationtech.jts.geom.Envelope;
import org.openjump.core.rasterimage.RasterImageLayer;

public class RasterImageLayerProperties {
    private static int datatype;
    private static String type;
    private static final String[] Q;

    public static String getFileSizeMegaBytes(long bytes) {
        for (int i = 6; i > 0; --i) {
            double step = Math.pow(1024.0, i);
            if (!((double)bytes > step)) continue;
            return String.format("%3.1f %s", (double)bytes / step, Q[i]);
        }
        return Long.toString(bytes);
    }

    public static long getFileSizeBytes(RasterImageLayer layer) {
        File rfile = new File(layer.getImageFileName());
        return rfile.length();
    }

    public static String getFileExtension(RasterImageLayer layer) {
        File f = new File(layer.getImageFileName());
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toUpperCase();
        }
        return ext;
    }

    public static String numBands(RasterImageLayer layer) {
        int bands = layer.getNumBands();
        return String.valueOf(bands);
    }

    public static String getDataType(Raster raster) throws IOException {
        SampleModel sm = raster.getSampleModel();
        datatype = sm.getDataType();
        switch (datatype) {
            case 0: {
                type = "byte";
                break;
            }
            case 2: {
                type = "short";
                break;
            }
            case 1: {
                type = "ushort";
                break;
            }
            case 3: {
                type = "int";
                break;
            }
            case 4: {
                type = "float";
                break;
            }
            case 5: {
                type = "double";
                break;
            }
            case 32: {
                type = "undefined";
            }
        }
        return type;
    }

    public static String getColorDepth(Raster raster, File file) throws IOException {
        int colordepth;
        String components = "(Cannot read num componets)";
        try {
            SampleModel sm = raster.getSampleModel();
            ColorModel cm = PlanarImage.createColorModel((SampleModel)sm);
            colordepth = cm.getNumColorComponents();
        }
        catch (Exception e) {
            try {
                BufferedImage buf = Imaging.getBufferedImage((File)file);
                ColorModel cm = buf.getColorModel();
                colordepth = cm.getNumColorComponents();
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                BufferedImage buf = ImageIO.read(file);
                ColorModel cm = buf.getColorModel();
                colordepth = cm.getNumColorComponents();
            }
        }
        components = String.valueOf(colordepth);
        return components + " bpp";
    }

    public static String getDPI(Raster raster, File file) throws IOException {
        int pixelSize;
        String pixelSizeS = "";
        try {
            SampleModel sm = raster.getSampleModel();
            ColorModel cm = PlanarImage.createColorModel((SampleModel)sm);
            pixelSize = cm.getPixelSize();
        }
        catch (Exception e) {
            ImageInfo imageInfo = Imaging.getImageInfo((File)file);
            pixelSize = imageInfo.getBitsPerPixel();
        }
        try {
            pixelSizeS = String.valueOf(pixelSize);
        }
        catch (Exception ex) {
            pixelSizeS = "Not recognized";
        }
        return pixelSizeS;
    }

    public static double cellSizeX(Raster raster, Envelope env) throws IOException {
        return env.getWidth() / (double)raster.getWidth();
    }

    public static double cellSizeY(Raster raster, Envelope env) throws IOException {
        return env.getHeight() / (double)raster.getHeight();
    }

    public static int getNumColumns(Raster raster) throws IOException {
        return raster.getWidth();
    }

    public static int getNumRows(Raster raster) throws IOException {
        return raster.getHeight();
    }

    public static int getNodataCellNumber(Raster raster, double nodata) throws IOException, RasterImageLayer.RasterDataNotFoundException {
        int counter = 0;
        int nx = raster.getWidth();
        int ny = raster.getHeight();
        for (int y = 0; y < ny; ++y) {
            for (int x = 0; x < nx; ++x) {
                double value = raster.getSampleDouble(x, y, 0);
                if (value != nodata) continue;
                ++counter;
            }
        }
        return counter;
    }

    public static int getValidCellsNumber(Raster raster, double nodata) throws IOException, RasterImageLayer.RasterDataNotFoundException {
        return raster.getWidth() * raster.getHeight() - RasterImageLayerProperties.getNodataCellNumber(raster, nodata);
    }

    static {
        Q = new String[]{"", "KB", "MB", "GB", "TB", "PB", "EB"};
    }
}

