/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.raster;

public class ProfileGraphAlgorithms {
    private int m_iCount = 0;
    private double m_dZMin;
    private double m_dZMax;
    private double m_dPlanetLenght = 0.0;
    private double m_dTerrainLength = 0.0;
    private final double totTime;
    private double m_dSlopeAll = 0.0;
    private double[] doubleZ = new double[]{0.0};
    private double[] doublePlanet = new double[]{0.0};
    private double[] doubleTerrain;
    private double[] doubleRelativeSlope;
    private double[] doubleAbsoluteSlope;

    public ProfileGraphAlgorithms() {
        this.m_dZMin = Double.MAX_VALUE;
        this.totTime = 0.0;
        this.m_dZMax = Double.NEGATIVE_INFINITY;
        this.doubleTerrain = new double[]{0.0};
        this.doubleRelativeSlope = new double[]{0.0};
        this.doubleAbsoluteSlope = new double[]{0.0};
    }

    public void calculateValues(double[][] dataTableDouble) {
        this.doubleZ = new double[dataTableDouble.length];
        this.doublePlanet = new double[dataTableDouble.length];
        this.doubleTerrain = new double[dataTableDouble.length];
        this.doubleRelativeSlope = new double[dataTableDouble.length];
        this.doubleAbsoluteSlope = new double[dataTableDouble.length];
        for (int i = 0; i < dataTableDouble.length; ++i) {
            ++this.m_iCount;
            this.doubleZ[i] = dataTableDouble[i][1];
            this.doublePlanet[i] = dataTableDouble[i][0];
            this.m_dZMax = Math.max(this.m_dZMax, this.doubleZ[i]);
            this.m_dPlanetLenght = this.doublePlanet[this.doublePlanet.length - 1];
            this.m_dZMin = Math.min(this.m_dZMin, this.doubleZ[i]);
            if (i == 0) {
                this.doubleTerrain[i] = 0.0;
                this.doubleRelativeSlope[i] = 0.0;
                this.doubleAbsoluteSlope[i] = 0.0;
                continue;
            }
            double dDist1 = dataTableDouble[i][0];
            double dDist0 = dataTableDouble[i - 1][0];
            double Z1 = dataTableDouble[i][1];
            double Z0 = dataTableDouble[i - 1][1];
            this.doubleTerrain[i] = Math.sqrt(Math.pow(Z1 - Z0, 2.0) + Math.pow(dDist1 - dDist0, 2.0)) + this.doubleTerrain[i - 1];
            this.m_dTerrainLength = this.doubleTerrain[this.doubleTerrain.length - 1];
            double slope = Math.atan((Z1 - Z0) / (dDist1 - dDist0));
            this.doubleRelativeSlope[i] = Math.toDegrees(slope);
            this.m_dSlopeAll += this.doubleRelativeSlope[i];
            if (slope > 0.0 || slope == 0.0) {
                this.doubleAbsoluteSlope[i] = this.doubleRelativeSlope[i];
                continue;
            }
            if (!(slope < 0.0)) continue;
            this.doubleAbsoluteSlope[i] = this.doubleRelativeSlope[i] * -1.0;
        }
    }

    public double getTime() {
        return this.totTime;
    }

    public double getSlope() {
        return this.m_dSlopeAll / (double)(this.m_iCount - 1);
    }

    public double[] getRelativeSlopeData() {
        return this.doubleRelativeSlope;
    }

    public double[] getAbsoluteSlopeData() {
        return this.doubleAbsoluteSlope;
    }

    public double[] getZData() {
        return this.doubleZ;
    }

    public double[] getPlanetData() {
        return this.doublePlanet;
    }

    public double[] getTerrainData() {
        return this.doubleTerrain;
    }

    public int getCount() {
        return this.m_iCount;
    }

    public double getZMin() {
        return this.m_dZMin;
    }

    public double getTerrainLength() {
        return this.m_dTerrainLength;
    }

    public double getPlanetLength() {
        return this.m_dPlanetLenght;
    }

    public double getZMax() {
        return this.m_dZMax;
    }
}

