/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.raster;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.openjump.core.apitools.LayerTools;
import org.openjump.core.rasterimage.RasterImageLayer;
import org.openjump.core.rasterimage.sextante.OpenJUMPSextanteRasterLayer;
import org.openjump.core.rasterimage.sextante.rasterWrappers.GridWrapperNotInterpolated;

public class CreatePolygonGridFromSelectedImageLayerPlugIn
extends AbstractPlugIn
implements ThreadedPlugIn {
    private MultiInputDialog dialog;
    private final String sName = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.CreatePolygonGridFromSelectedImageLayerPlugIn.Create-Polygon-Grid-from-Raster");
    public String sRemoveZeroCells = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.CreatePolygonGridFromSelectedImageLayerPlugIn.remove-cells-with-values") + " =< 0";
    private final String sSidebar = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.CreatePolygonGridFromSelectedImageLayerPlugIn.Creates-a-polygon-grid-from-the-selected-raster");
    public String sMaxCellsToDisplay = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.CreatePolygonGridFromSelectedImageLayerPlugIn.max-cells-to-display");
    private final String sCreatingPolygons = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.CreatePolygonGridFromSelectedImageLayerPlugIn.Creating-polygons") + "...";
    private final String sGrid = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.CreatePolygonGridFromSelectedImageLayerPlugIn.grid");
    public static String Source_Layer = I18N.getInstance().get("ui.GenericNames.Source-Layer");
    private final String sToManyPolygons = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.CreatePolygonGridFromSelectedImageLayerPlugIn.To-many-polygons-to-generate");
    private final String sBand = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.CreatePolygonGridFromSelectedImageLayerPlugIn.band");
    GeometryFactory gfactory = new GeometryFactory();
    public int maxCells = 200000;
    public boolean removeZeroCells = false;
    private JComboBox<RasterImageLayer> layerableComboBox = new JComboBox();
    private RasterImageLayer rLayer;
    List<RasterImageLayer> fLayers = new ArrayList<RasterImageLayer>();

    @Override
    public String getName() {
        return this.sName;
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithAssociatedTaskFrameMustBeActiveCheck()).add(checkFactory.createAtLeastNLayerablesOfTypeMustExistCheck(1, RasterImageLayer.class));
    }

    public String getIconString() {
        return null;
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.setDialogValues(context);
        this.dialog.setVisible(true);
        if (!this.dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(this.dialog);
        return true;
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        monitor.allowCancellationRequests();
        GeometryFactory gf = new GeometryFactory();
        if (this.rLayer == null) {
            context.getWorkbenchFrame().warnUser(I18N.getInstance().get("pirol.plugIns.EditAttributeByFormulaPlugIn.no-layer-selected"));
            return;
        }
        OpenJUMPSextanteRasterLayer rstLayer = new OpenJUMPSextanteRasterLayer();
        rstLayer.create(this.rLayer, false);
        GridWrapperNotInterpolated gwrapper = new GridWrapperNotInterpolated(rstLayer, rstLayer.getLayerGridExtent());
        FeatureSchema fs = new FeatureSchema();
        fs.addAttribute("geometry", AttributeType.GEOMETRY);
        int numBands = rstLayer.getBandsCount();
        for (int i = 0; i < numBands; ++i) {
            fs.addAttribute(this.sBand + "_" + i, AttributeType.DOUBLE);
        }
        FeatureDataset fd = new FeatureDataset(fs);
        monitor.report(this.sCreatingPolygons);
        int nx = rstLayer.getLayerGridExtent().getNX();
        int ny = rstLayer.getLayerGridExtent().getNY();
        double halfCellDimX = 0.5 * rstLayer.getLayerGridExtent().getCellSize().x;
        double halfCellDimY = 0.5 * rstLayer.getLayerGridExtent().getCellSize().y;
        int numPoints = nx * ny;
        if (numPoints > this.maxCells) {
            context.getWorkbenchFrame().warnUser(this.sToManyPolygons + ": " + numPoints + " > " + this.maxCells);
            return;
        }
        for (int x = 0; x < nx; ++x) {
            for (int y = 0; y < ny; ++y) {
                Coordinate[] coords;
                BasicFeature ftemp = new BasicFeature(fs);
                Point2D pt = rstLayer.getLayerGridExtent().getWorldCoordsFromGridCoords(x, y);
                coords = new Coordinate[]{new Coordinate(pt.getX() - halfCellDimX, pt.getY() + halfCellDimY), new Coordinate(pt.getX() + halfCellDimX, pt.getY() + halfCellDimY), new Coordinate(pt.getX() + halfCellDimX, pt.getY() - halfCellDimY), new Coordinate(pt.getX() - halfCellDimX, pt.getY() - halfCellDimY), (Coordinate)coords[0].clone()};
                LinearRing lr = gf.createLinearRing(coords);
                Polygon poly = gf.createPolygon(lr, null);
                ftemp.setGeometry((Geometry)poly);
                double sumvalue = 0.0;
                for (int i = 0; i < numBands; ++i) {
                    double value = gwrapper.getCellValueAsDouble(x, y, i);
                    ftemp.setAttribute(this.sBand + "_" + i, (Object)value);
                    sumvalue += value;
                }
                if (this.removeZeroCells) {
                    if (sumvalue > 0.0) {
                        fd.add(ftemp);
                    }
                } else {
                    fd.add(ftemp);
                }
                if (!monitor.isCancelRequested()) continue;
                if (fd.size() > 0) {
                    context.addLayer(StandardCategoryNames.RESULT, rstLayer.getName() + "_cancel_" + this.sGrid, fd);
                }
                return;
            }
        }
        if (fd.size() > 0) {
            context.addLayer(StandardCategoryNames.RESULT, rstLayer.getName() + "_" + this.sGrid, fd);
        }
    }

    private void setDialogValues(PlugInContext context) {
        this.dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.sName, true);
        this.dialog.setSideBarDescription(this.sSidebar);
        this.rLayer = !context.getLayerNamePanel().selectedNodes(RasterImageLayer.class).isEmpty() ? (RasterImageLayer)LayerTools.getSelectedLayerable(context, RasterImageLayer.class) : context.getTask().getLayerManager().getLayerables(RasterImageLayer.class).get(0);
        this.fLayers = context.getTask().getLayerManager().getLayerables(RasterImageLayer.class);
        this.layerableComboBox = this.dialog.addLayerableComboBox(Source_Layer, this.rLayer, "", this.fLayers);
        this.layerableComboBox.setSize(200, this.layerableComboBox.getPreferredSize().height);
        this.dialog.addCheckBox(this.sRemoveZeroCells, this.removeZeroCells);
        this.dialog.addIntegerField(this.sMaxCellsToDisplay, this.maxCells, 10, this.sMaxCellsToDisplay);
        GUIUtil.centreOnWindow(this.dialog);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.rLayer = (RasterImageLayer)dialog.getLayerable(Source_Layer);
        this.removeZeroCells = dialog.getBoolean(this.sRemoveZeroCells);
        this.maxCells = dialog.getInteger(this.sMaxCellsToDisplay);
    }
}

