/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.raster;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.openjump.core.apitools.LayerTools;
import org.openjump.core.rasterimage.RasterImageLayer;
import org.openjump.core.rasterimage.sextante.OpenJUMPSextanteRasterLayer;
import org.openjump.core.rasterimage.sextante.rasterWrappers.GridWrapperNotInterpolated;

public class CreateLatticeFromSelectedImageLayerPlugIn
extends AbstractPlugIn
implements ThreadedPlugIn {
    GeometryFactory gfactory = new GeometryFactory();
    private final String sName = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.CreateLatticeFromSelectedImageLayerPlugIn.Create-Lattice-from-Raster");
    private final String sBand = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.CreatePolygonGridFromSelectedImageLayerPlugIn.band");
    private final String sLattice = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.CreateLatticeFromSelectedImageLayerPlugIn.lattice");
    private final String sCreatePoints = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.CreateLatticeFromSelectedImageLayerPlugIn.creating-points");
    private static String Source_Layer = I18N.getInstance().get("ui.GenericNames.Source-Layer");
    private final String sSidebar = this.sLattice;
    private MultiInputDialog dialog;
    private JComboBox<RasterImageLayer> layerableComboBox = new JComboBox();
    private RasterImageLayer rLayer;
    List<RasterImageLayer> fLayers = new ArrayList<RasterImageLayer>();

    @Override
    public String getName() {
        return this.sName;
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithAssociatedTaskFrameMustBeActiveCheck()).add(checkFactory.createAtLeastNLayerablesOfTypeMustExistCheck(1, RasterImageLayer.class));
    }

    public String getIconString() {
        return null;
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.setDialogValues(context);
        this.dialog.setVisible(true);
        if (!this.dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(this.dialog);
        return true;
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.rLayer = (RasterImageLayer)dialog.getLayerable(Source_Layer);
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        monitor.allowCancellationRequests();
        GeometryFactory gf = new GeometryFactory();
        if (this.rLayer == null) {
            context.getWorkbenchFrame().warnUser(I18N.getInstance().get("pirol.plugIns.EditAttributeByFormulaPlugIn.no-layer-selected"));
            return;
        }
        OpenJUMPSextanteRasterLayer rstLayer = new OpenJUMPSextanteRasterLayer();
        rstLayer.create(this.rLayer, false);
        GridWrapperNotInterpolated gwrapper = new GridWrapperNotInterpolated(rstLayer, rstLayer.getLayerGridExtent());
        FeatureSchema fs = new FeatureSchema();
        fs.addAttribute("geometry", AttributeType.GEOMETRY);
        fs.addAttribute("cellid_x", AttributeType.INTEGER);
        fs.addAttribute("cellid_y", AttributeType.INTEGER);
        int numBands = rstLayer.getBandsCount();
        for (int i = 0; i < numBands; ++i) {
            fs.addAttribute(this.sBand + "_" + i, AttributeType.DOUBLE);
        }
        FeatureDataset fd = new FeatureDataset(fs);
        monitor.report(this.sCreatePoints);
        int nx = rstLayer.getLayerGridExtent().getNX();
        int ny = rstLayer.getLayerGridExtent().getNY();
        for (int x = 0; x < nx; ++x) {
            for (int y = 0; y < ny; ++y) {
                BasicFeature ftemp = new BasicFeature(fs);
                Point2D pt = rstLayer.getLayerGridExtent().getWorldCoordsFromGridCoords(x, y);
                Point centerPoint = gf.createPoint(new Coordinate(pt.getX(), pt.getY()));
                ftemp.setGeometry((Geometry)centerPoint);
                for (int i = 0; i < numBands; ++i) {
                    double value = gwrapper.getCellValueAsDouble(x, y, i);
                    ftemp.setAttribute(this.sBand + "_" + i, (Object)value);
                }
                ftemp.setAttribute("cellid_x", (Object)x);
                ftemp.setAttribute("cellid_y", (Object)y);
                fd.add(ftemp);
                if (!monitor.isCancelRequested()) continue;
                if (fd.size() > 0) {
                    context.addLayer(StandardCategoryNames.RESULT, rstLayer.getName() + "_cancel_" + this.sLattice, fd);
                }
                return;
            }
        }
        if (fd.size() > 0) {
            context.addLayer(StandardCategoryNames.RESULT, rstLayer.getName() + "_" + this.sLattice, fd);
        }
    }

    private void setDialogValues(PlugInContext context) {
        this.dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.sName, true);
        this.dialog.setSideBarDescription(this.sSidebar);
        this.rLayer = !context.getLayerNamePanel().selectedNodes(RasterImageLayer.class).isEmpty() ? (RasterImageLayer)LayerTools.getSelectedLayerable(context, RasterImageLayer.class) : context.getTask().getLayerManager().getLayerables(RasterImageLayer.class).get(0);
        this.fLayers = context.getTask().getLayerManager().getLayerables(RasterImageLayer.class);
        this.layerableComboBox = this.dialog.addLayerableComboBox(Source_Layer, this.rLayer, "", this.fLayers);
        this.layerableComboBox.setSize(200, this.layerableComboBox.getPreferredSize().height);
        GUIUtil.centreOnWindow(this.dialog);
    }
}

