/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.queries;

import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.util.FlexibleDateParser;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.index.strtree.STRtree;
import org.openjump.core.ui.plugin.queries.Function;
import org.openjump.core.ui.plugin.queries.Operator;
import org.openjump.core.ui.plugin.queries.QueryDialog;

public class Condition {
    private static final SimpleDateFormat[] DATE_PARSERS = new SimpleDateFormat[]{new SimpleDateFormat(), new SimpleDateFormat("dd/MM/yy"), new SimpleDateFormat("dd/MM/yyyy"), new SimpleDateFormat("dd-MM-yy"), new SimpleDateFormat("dd-MM-yyyy"), new SimpleDateFormat("yyyy-MM-dd"), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss"), new SimpleDateFormat("yyyy")};
    private static final FlexibleDateParser FLEXIBLE_DATE_PARSER = new FlexibleDateParser();
    private QueryDialog query;
    private Function ft;
    private Operator op;
    private Pattern pattern;
    private PlugInContext context;
    private Map<String, STRtree> spatialIndices;

    public Condition(QueryDialog query, PlugInContext context) {
        this.query = query;
        this.ft = query.function;
        this.op = query.operator;
        if (this.op == Operator.MATC || this.op == Operator.FIND) {
            this.pattern = query.caseSensitive.getState() ? Pattern.compile((String)query.valueCB.getSelectedValue()) : Pattern.compile((String)query.valueCB.getSelectedValue(), 2);
        }
        if (this.op.type == 'G') {
            this.spatialIndices = new HashMap<String, STRtree>();
        }
        this.context = context;
    }

    public String toString() {
        String att = this.query.attribute.trim().equals("") ? "GEOMETRY" : this.query.attribute;
        String func = this.ft.toString().trim().equals("") ? "" : "." + this.ft;
        return "" + att + func + " " + this.op + " \"" + this.query.valueCB.getSelectedValue() + "\"";
    }

    public boolean test(Feature feature) throws Exception {
        if (this.query.attributeType == 'G') {
            Geometry o = feature.getGeometry();
            if (this.ft.type == 'G') {
                return this.test(this.gfunction(o));
            }
            if (this.ft.type == 'N') {
                return this.test(this.nfunction(o));
            }
            if (this.ft.type == 'B') {
                return this.test(this.bfunction(o));
            }
            return false;
        }
        Object o = feature.getAttribute(this.query.attribute);
        if (this.ft == Function.ISNULL) {
            return this.test(o == null);
        }
        if (o == null) {
            if (this.op == Operator.NE || this.op == Operator.BNE || this.op == Operator.DIFF) {
                return this.query.valueCB.getSelectedValue().toString().trim().length() != 0;
            }
            if (this.op == Operator.EQ || this.op == Operator.BEQ || this.op == Operator.EQUA) {
                return this.query.valueCB.getSelectedValue().toString().trim().length() == 0;
            }
            if (this.ft.type == 'S') {
                return this.test(this.sfunction(""));
            }
            if (this.ft.type == 'N') {
                return this.test(this.nfunction(""));
            }
        }
        if (o instanceof Boolean) {
            return this.test((Boolean)o);
        }
        if (o instanceof Integer) {
            return this.test(((Integer)o).doubleValue());
        }
        if (o instanceof Long) {
            return this.test(((Long)o).doubleValue());
        }
        if (o instanceof Double) {
            return this.test((Double)o);
        }
        if (o instanceof BigDecimal) {
            return this.test(((BigDecimal)o).doubleValue());
        }
        if (o instanceof Date) {
            return this.test(this.dfunction((Date)o));
        }
        if (o instanceof String && this.ft.type == 'S') {
            return this.test(this.sfunction((String)o));
        }
        if (o instanceof String && this.ft.type == 'N') {
            return this.test(this.nfunction((String)o));
        }
        return false;
    }

    private boolean test(boolean b) throws Exception {
        boolean value;
        boolean bl = value = this.query.valueCB.getSelectedIndex() == 0;
        if (b == value && this.op == Operator.BEQ) {
            return true;
        }
        return b != value && this.op == Operator.BNE;
    }

    private boolean test(double d) throws Exception {
        double value = Double.parseDouble((String)this.query.valueCB.getSelectedValue());
        if (this.op == Operator.EQ && d == value) {
            return true;
        }
        if (this.op == Operator.NE && d != value) {
            return true;
        }
        if (this.op == Operator.LT && d < value) {
            return true;
        }
        if (this.op == Operator.GT && d > value) {
            return true;
        }
        if (this.op == Operator.LE && d <= value) {
            return true;
        }
        return this.op == Operator.GE && d >= value;
    }

    private boolean test(Date d) throws Exception {
        Date value = null;
        for (SimpleDateFormat sdf : DATE_PARSERS) {
            try {
                value = sdf.parse((String)this.query.valueCB.getSelectedValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (value != null) break;
        }
        if (value == null) {
            try {
                value = FLEXIBLE_DATE_PARSER.parse((String)this.query.valueCB.getSelectedValue(), true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.op == Operator.EQ && d == value) {
            return true;
        }
        if (this.op == Operator.NE && d != value) {
            return true;
        }
        if (this.op == Operator.EQ && d.equals(value)) {
            return true;
        }
        if (this.op == Operator.NE && !d.equals(value)) {
            return true;
        }
        if (this.op == Operator.LT && d.before(value)) {
            return true;
        }
        if (this.op == Operator.GT && d.after(value)) {
            return true;
        }
        if (this.op == Operator.LE && (d.before(value) || d.equals(value))) {
            return true;
        }
        return this.op == Operator.GE && (d.after(value) || d.equals(value));
    }

    private boolean test(String s) throws Exception {
        String value = (String)this.query.valueCB.getSelectedValue();
        if (this.query.caseSensitive.getState()) {
            if (this.op == Operator.EQUA) {
                return s.equals(value);
            }
            if (this.op == Operator.DIFF) {
                return !s.equals(value);
            }
            if (this.op == Operator.STAR) {
                return s.startsWith(value);
            }
            if (this.op == Operator.ENDS) {
                return s.endsWith(value);
            }
            if (this.op == Operator.MATC) {
                return this.pattern.matcher(s).matches();
            }
            if (this.op == Operator.FIND) {
                return this.pattern.matcher(s).find();
            }
            if (this.op == Operator.BEFO) {
                return s.compareTo(value) <= 0;
            }
            if (this.op == Operator.AFTE) {
                return s.compareTo(value) >= 0;
            }
            return false;
        }
        if (this.op == Operator.EQUA) {
            return s.equalsIgnoreCase(value);
        }
        if (this.op == Operator.DIFF) {
            return !s.equalsIgnoreCase(value);
        }
        if (this.op == Operator.STAR) {
            return s.toUpperCase().startsWith(value.toUpperCase());
        }
        if (this.op == Operator.ENDS) {
            return s.toUpperCase().endsWith(value.toUpperCase());
        }
        if (this.op == Operator.MATC) {
            return this.pattern.matcher(s).matches();
        }
        if (this.op == Operator.FIND) {
            return this.pattern.matcher(s).find();
        }
        if (this.op == Operator.BEFO) {
            return s.compareToIgnoreCase(value) <= 0;
        }
        if (this.op == Operator.AFTE) {
            return s.compareToIgnoreCase(value) >= 0;
        }
        return false;
    }

    private boolean test(Geometry g) throws Exception {
        int pos = this.query.valueCB.getSelectedIndex();
        if (pos == 1) {
            Collection candidates = this.candidates(g, "$SELECTION", this.query.selection);
            for (Geometry p : candidates) {
                if (this.op == Operator.INTER && g.intersects(p)) {
                    return true;
                }
                if (this.op == Operator.CONTA && g.contains(p)) {
                    return true;
                }
                if (this.op == Operator.WITHI && g.within(p)) {
                    return true;
                }
                if (this.op == Operator.WSTRI && g.relate(p, "TFF*FF***")) {
                    return true;
                }
                if (this.op == Operator.WDIST && g.distance(p) < Double.parseDouble(this.op.arg.toString())) {
                    return true;
                }
                if (this.op == Operator.TOUCH && g.touches(p)) {
                    return true;
                }
                if (this.op == Operator.CROSS && g.crosses(p)) {
                    return true;
                }
                if (this.op == Operator.OVERL && g.overlaps(p)) {
                    return true;
                }
                if (this.op == Operator.RELAT && g.relate(p, this.op.arg.toString())) {
                    return true;
                }
                if (this.op == Operator.INTIP && g.intersects((Geometry)p.getInteriorPoint())) {
                    return true;
                }
                if (this.op != Operator.IPINT || !g.getInteriorPoint().intersects(p)) continue;
                return true;
            }
            return false;
        }
        if (pos == 2) {
            int i = 0;
            Layer[] ll = this.context.getLayerNamePanel().getSelectedLayers();
            if (i < ll.length) {
                FeatureCollectionWrapper fc = ll[i].getFeatureCollectionWrapper();
                Collection candidates = this.candidates(g, ll[i].getName(), fc);
                Iterator it = candidates.iterator();
                while (it.hasNext()) {
                    Geometry p = ((Feature)it.next()).getGeometry();
                    if (this.op == Operator.INTER && g.intersects(p)) {
                        return true;
                    }
                    if (this.op == Operator.CONTA && g.contains(p)) {
                        return true;
                    }
                    if (this.op == Operator.WITHI && g.within(p)) {
                        return true;
                    }
                    if (this.op == Operator.WSTRI && g.relate(p, "TFF*FF***")) {
                        return true;
                    }
                    if (this.op == Operator.WDIST && g.distance(p) < Double.parseDouble(this.op.arg.toString())) {
                        return true;
                    }
                    if (this.op == Operator.TOUCH && g.touches(p)) {
                        return true;
                    }
                    if (this.op == Operator.CROSS && g.crosses(p)) {
                        return true;
                    }
                    if (this.op == Operator.OVERL && g.overlaps(p)) {
                        return true;
                    }
                    if (this.op == Operator.RELAT && g.relate(p, this.op.arg.toString())) {
                        return true;
                    }
                    if (this.op == Operator.INTIP && g.intersects((Geometry)p.getInteriorPoint())) {
                        return true;
                    }
                    if (this.op != Operator.IPINT || !g.getInteriorPoint().intersects(p)) continue;
                    return true;
                }
                return false;
            }
        } else if (pos == 0) {
            int i = 0;
            List<Layer> ll = this.context.getLayerManager().getLayers();
            if (i < ll.size()) {
                FeatureCollectionWrapper fc = ll.get(i).getFeatureCollectionWrapper();
                Collection candidates = this.candidates(g, ll.get(i).getName(), fc);
                Iterator it = candidates.iterator();
                while (it.hasNext()) {
                    Geometry p = ((Feature)it.next()).getGeometry();
                    if (this.op == Operator.INTER && g.intersects(p)) {
                        return true;
                    }
                    if (this.op == Operator.CONTA && g.contains(p)) {
                        return true;
                    }
                    if (this.op == Operator.WITHI && g.within(p)) {
                        return true;
                    }
                    if (this.op == Operator.WSTRI && g.relate(p, "TFF*FF***")) {
                        return true;
                    }
                    if (this.op == Operator.WDIST && g.distance(p) < Double.parseDouble(this.op.arg.toString())) {
                        return true;
                    }
                    if (this.op == Operator.TOUCH && g.touches(p)) {
                        return true;
                    }
                    if (this.op == Operator.CROSS && g.crosses(p)) {
                        return true;
                    }
                    if (this.op == Operator.OVERL && g.overlaps(p)) {
                        return true;
                    }
                    if (this.op == Operator.RELAT && g.relate(p, this.op.arg.toString())) {
                        return true;
                    }
                    if (this.op == Operator.INTIP && g.intersects((Geometry)p.getInteriorPoint())) {
                        return true;
                    }
                    if (this.op != Operator.IPINT || !g.getInteriorPoint().intersects(p)) continue;
                    return true;
                }
                return false;
            }
        } else {
            Layer layer = this.context.getLayerManager().getLayer((String)this.query.valueCB.getSelectedValue());
            FeatureCollectionWrapper fc = layer.getFeatureCollectionWrapper();
            Collection candidates = this.candidates(g, layer.getName(), fc);
            Iterator it = candidates.iterator();
            while (it.hasNext()) {
                Geometry p = ((Feature)it.next()).getGeometry();
                if (this.op == Operator.INTER && g.intersects(p)) {
                    return true;
                }
                if (this.op == Operator.CONTA && g.contains(p)) {
                    return true;
                }
                if (this.op == Operator.WITHI && g.within(p)) {
                    return true;
                }
                if (this.op == Operator.WSTRI && g.relate(p, "TFF*FF***")) {
                    return true;
                }
                if (this.op == Operator.WDIST && g.distance(p) < Double.parseDouble(this.op.arg.toString())) {
                    return true;
                }
                if (this.op == Operator.TOUCH && g.touches(p)) {
                    return true;
                }
                if (this.op == Operator.CROSS && g.crosses(p)) {
                    return true;
                }
                if (this.op == Operator.OVERL && g.overlaps(p)) {
                    return true;
                }
                if (this.op == Operator.RELAT && g.relate(p, this.op.arg.toString())) {
                    return true;
                }
                if (this.op == Operator.INTIP && g.intersects((Geometry)p.getInteriorPoint())) {
                    return true;
                }
                if (this.op != Operator.IPINT || !g.getInteriorPoint().intersects(p)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private STRtree createIndex(Collection geometries) {
        STRtree index = new STRtree();
        for (Object geometry : geometries) {
            index.insert(((Geometry)geometry).getEnvelopeInternal(), geometry);
        }
        return index;
    }

    private STRtree createIndex(FeatureCollection fc) {
        STRtree index = new STRtree();
        for (Feature f : fc.getFeatures()) {
            index.insert(f.getGeometry().getEnvelopeInternal(), (Object)f);
        }
        return index;
    }

    private Collection candidates(Geometry g, String collectionName, Collection collection) {
        if (collection.size() > 256 && Arrays.asList(Operator.INTER, Operator.CONTA, Operator.WITHI, Operator.WSTRI, Operator.WDIST, Operator.TOUCH, Operator.CROSS, Operator.OVERL, Operator.INTIP, Operator.IPINT).contains(this.op)) {
            STRtree index = this.spatialIndices.get(collectionName);
            if (index == null) {
                index = this.createIndex(collection);
                this.spatialIndices.put(collectionName, index);
            }
            Envelope e = g.getEnvelopeInternal();
            if (this.op == Operator.WDIST) {
                e.expandBy(Double.parseDouble(this.op.arg.toString()));
            }
            return index.query(e);
        }
        return collection;
    }

    private Collection candidates(Geometry g, String collectionName, FeatureCollection collection) {
        if (collection.size() > 256 && Arrays.asList(Operator.INTER, Operator.CONTA, Operator.WITHI, Operator.WSTRI, Operator.WDIST, Operator.TOUCH, Operator.CROSS, Operator.OVERL, Operator.INTIP, Operator.IPINT).contains(this.op)) {
            STRtree index = this.spatialIndices.get(collectionName);
            if (index == null) {
                index = this.createIndex(collection);
                this.spatialIndices.put(collectionName, index);
            }
            Envelope e = g.getEnvelopeInternal();
            if (this.op == Operator.WDIST) {
                e.expandBy(Double.parseDouble(this.op.arg.toString()));
            }
            return index.query(e);
        }
        return collection.getFeatures();
    }

    private String sfunction(String s) {
        if (this.ft == Function.SNOF) {
            return s;
        }
        if (this.ft == Function.TRIM) {
            return s.trim();
        }
        if (this.ft == Function.SUBS && this.ft.args.length == 1) {
            return s.substring(this.ft.args[0]);
        }
        if (this.ft == Function.SUBS && this.ft.args.length == 2) {
            return s.substring(this.ft.args[0], this.ft.args[1]);
        }
        return s;
    }

    private double nfunction(String s) {
        if (this.ft == Function.LENG) {
            return s.length();
        }
        return 0.0;
    }

    private Geometry gfunction(Geometry g) {
        if (this.ft == Function.GNOF) {
            return g;
        }
        if (this.ft == Function.CENT) {
            return g.getInteriorPoint();
        }
        if (this.ft == Function.BUFF) {
            return g.buffer(this.ft.arg);
        }
        return g;
    }

    private Date dfunction(Date d) {
        if (this.ft == Function.DNOF) {
            return d;
        }
        if (this.ft == Function.DDAY || this.ft == Function.DYEA) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(d);
            GregorianCalendar rcal = new GregorianCalendar();
            rcal.clear();
            if (this.ft == Function.DDAY) {
                rcal.set(cal.get(1), cal.get(2), cal.get(5));
            } else if (this.ft == Function.DYEA) {
                rcal.set(1, cal.get(1));
            }
            return rcal.getTime();
        }
        return d;
    }

    private double nfunction(Geometry g) {
        if (this.ft == Function.LENG) {
            return g.getLength();
        }
        if (this.ft == Function.AREA) {
            return g.getArea();
        }
        if (this.ft == Function.NBPT) {
            return g.getNumPoints();
        }
        if (this.ft == Function.NBPA) {
            if (g.isEmpty()) {
                return 0.0;
            }
            if (g instanceof GeometryCollection) {
                return ((GeometryCollection)g).getNumGeometries();
            }
            return 1.0;
        }
        return 0.0;
    }

    private boolean bfunction(Geometry g) {
        if (this.ft == Function.EMPT) {
            return g.isEmpty();
        }
        if (this.ft == Function.SIMP) {
            return g.isSimple();
        }
        if (this.ft == Function.VALI) {
            return g.isValid();
        }
        return false;
    }
}

