/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.mousemenu;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.ImageIcon;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.Geometry;

public class MoveAlongAnglePlugIn
extends AbstractPlugIn {
    private static final String sMoveAlongAngle = I18N.getInstance().get("org.openjump.core.ui.plugin.mousemenu.MoveAlongAnglePlugIn.Move-Along-Angle");
    private static final String sMoveSelectedFeaturesAlongAngle = I18N.getInstance().get("org.openjump.core.ui.plugin.mousemenu.MoveAlongAnglePlugIn.Move-Selected-Features-Along-Angle");
    private static final String sTheDistanceInMapUnitsToMove = I18N.getInstance().get("org.openjump.core.ui.plugin.mousemenu.MoveAlongAnglePlugIn.The-distance-in-map-units-to-move");
    private static final String sTheAngleInDegreesToMove = I18N.getInstance().get("org.openjump.core.ui.plugin.mousemenu.MoveAlongAnglePlugIn.The-angle-in-degrees-to-move");
    private static final String sWillCovert = I18N.getInstance().get("org.openjump.core.ui.plugin.mousemenu.MoveAlongAnglePlugIn.Will-convert-input-value-from-feet-to-meters");
    private WorkbenchContext workbenchContext;
    private static final String ANGLE = I18N.getInstance().get("org.openjump.core.ui.plugin.mousemenu.MoveAlongAnglePlugIn.Move-Angle");
    private static final String DISTANCE = I18N.getInstance().get("org.openjump.core.ui.plugin.mousemenu.MoveAlongAnglePlugIn.Move-Distance");
    private final double Deg2Rad = 0.0174532925199432;
    private MultiInputDialog dialog;
    private double moveAngle = 0.0;
    private double moveDistance = 1.0;
    private static final String CONVERTTOMETERS = I18N.getInstance().get("org.openjump.core.ui.plugin.mousemenu.MoveAlongAnglePlugIn.Convert-Feet-to-Meters");
    private double conversionFactor = 1.0;

    @Override
    public String getName() {
        return sMoveAlongAngle;
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        ArrayList<EditTransaction> transactions = new ArrayList<EditTransaction>();
        this.reportNothingToUndoYet(context);
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        this.setDialogValues(dialog, context);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        double angle = 0.0174532925199432 * this.moveAngle;
        double x = Math.cos(angle) * this.moveDistance * this.conversionFactor;
        double y = Math.sin(angle) * this.moveDistance * this.conversionFactor;
        Coordinate displacement = new Coordinate(x, y);
        this.workbenchContext = context.getWorkbenchContext();
        for (Layer layerWithSelectedItems : this.workbenchContext.getLayerViewPanel().getSelectionManager().getLayersWithSelectedItems()) {
            transactions.add(this.createTransaction(layerWithSelectedItems, displacement));
        }
        EditTransaction.commit(transactions);
        return true;
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        dialog.setSideBarImage(new ImageIcon(this.getClass().getResource("Compass.png")));
        dialog.setSideBarDescription(sMoveSelectedFeaturesAlongAngle);
        dialog.addDoubleField(DISTANCE, this.moveDistance, 6, sTheDistanceInMapUnitsToMove);
        dialog.addDoubleField(ANGLE, this.moveAngle, 6, sTheAngleInDegreesToMove);
        dialog.addCheckBox(CONVERTTOMETERS, this.conversionFactor != 1.0, sWillCovert);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.conversionFactor = dialog.getCheckBox(CONVERTTOMETERS).isSelected() ? 0.3048 : 1.0;
        this.moveDistance = dialog.getDouble(DISTANCE);
        this.moveAngle = dialog.getDouble(ANGLE);
    }

    private EditTransaction createTransaction(Layer layer, final Coordinate displacement) {
        EditTransaction transaction = EditTransaction.createTransactionOnSelection(new EditTransaction.SelectionEditor(){

            public Geometry edit(Geometry geometryWithSelectedItems, Collection selectedItems) {
                for (Geometry item : selectedItems) {
                    MoveAlongAnglePlugIn.this.move(item, displacement);
                }
                return geometryWithSelectedItems;
            }
        }, this.workbenchContext.getLayerViewPanel(), this.workbenchContext.getLayerViewPanel().getContext(), this.getName(), layer, false, false);
        return transaction;
    }

    private void move(Geometry geometry, final Coordinate displacement) {
        geometry.apply(new CoordinateFilter(){

            public void filter(Coordinate coordinate) {
                coordinate.x += displacement.x;
                coordinate.y += displacement.y;
            }
        });
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createAtLeastNFeaturesMustHaveSelectedItemsCheck(1)).add(checkFactory.createSelectedItemsLayersMustBeEditableCheck());
    }
}

