/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.mousemenu;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.SelectionManagerProxy;
import java.util.Collection;
import javax.swing.JComponent;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.openjump.core.ui.plugin.mousemenu.EditSelectedSideDialog;

public class EditSelectedSidePlugIn
extends AbstractPlugIn {
    private static final String sEditSelectedSide = I18N.getInstance().get("org.openjump.core.ui.plugin.mousemenu.EditSelectedSidePlugIn.Edit-Selected-Side");
    private static final String sPointsDoNotHaveSides = I18N.getInstance().get("org.openjump.core.ui.plugin.mousemenu.EditSelectedSidePlugIn.Points-do-not-have-sides");
    private static final String sSelectOnlyOnePart = I18N.getInstance().get("org.openjump.core.ui.plugin.mousemenu.EditSelectedSidePlugIn.Select-only-one-part");

    @Override
    public String getName() {
        return sEditSelectedSide;
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        EditSelectedSideDialog dialog = new EditSelectedSideDialog(context, sEditSelectedSide, false);
        dialog.setVisible(true);
        return true;
    }

    public EnableCheck noPointsMayBeSelectedCheck(final WorkbenchContext workbenchContext) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                Collection<Geometry> selectedItems = ((SelectionManagerProxy)((Object)workbenchContext.getWorkbench().getFrame().getActiveInternalFrame())).getSelectionManager().getSelectedItems();
                Geometry selectedGeo = selectedItems.iterator().next();
                return selectedGeo instanceof Point ? sPointsDoNotHaveSides : null;
            }
        };
    }

    public EnableCheck noMultiShapesMayBeSelectedCheck(final WorkbenchContext workbenchContext) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                Collection<Geometry> selectedItems = ((SelectionManagerProxy)((Object)workbenchContext.getWorkbench().getFrame().getActiveInternalFrame())).getSelectionManager().getSelectedItems();
                Geometry selectedGeo = selectedItems.iterator().next();
                return selectedGeo instanceof MultiPoint || selectedGeo instanceof MultiLineString || selectedGeo instanceof MultiPolygon || selectedGeo instanceof GeometryCollection ? sSelectOnlyOnePart : null;
            }
        };
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createExactlyNItemsMustBeSelectedCheck(1)).add(this.noPointsMayBeSelectedCheck(workbenchContext)).add(this.noMultiShapesMayBeSelectedCheck(workbenchContext)).add(checkFactory.createSelectedItemsLayersMustBeEditableCheck());
    }
}

