/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.file;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.OKCancelDialog;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.renderer.LayerRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.Renderer;
import com.vividsolutions.jump.workbench.ui.renderer.RenderingManager;
import com.vividsolutions.jump.workbench.ui.renderer.java2D.Java2DConverter;
import java.awt.Component;
import java.awt.Graphics;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.locationtech.jts.geom.Envelope;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class SaveImageAsSVGPlugIn
extends AbstractPlugIn
implements ThreadedPlugIn {
    private File selFile = null;

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        ClassLoader cl = this.getClass().getClassLoader();
        Class<?> c = null;
        Class<?> c2 = null;
        try {
            c = cl.loadClass("org.apache.batik.dom.GenericDOMImplementation");
            c2 = cl.loadClass("org.apache.batik.svggen.SVGGraphics2D");
        }
        catch (ClassNotFoundException e) {
            Logger.warn("Could not load class from batik", e);
        }
        if (c == null || c2 == null) {
            context.getWorkbenchFrame().log(this.getClass().getName() + " not initialized because batik is missing.");
            return;
        }
        context.getFeatureInstaller().addMainMenuPlugin(this, new String[]{MenuNames.FILE, MenuNames.FILE_SAVEVIEW}, this.getName(), false, null, SaveImageAsSVGPlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    @Override
    public String getName() {
        return I18N.getInstance().get("org.openjump.core.ui.plugin.file.SaveImageAsSVGPlugIn.save-image-in-svg-format");
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        JFileChooser fc = GUIUtil.createJFileChooserWithOverwritePrompting("svg");
        fc.showSaveDialog(context.getWorkbenchFrame());
        File file = fc.getSelectedFile();
        try {
            String name = file.getPath();
            name = this.addExtension(name, "svg");
            this.selFile = new File(name);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        Runner.run(monitor, context, this.selFile);
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createTaskWindowMustBeActiveCheck());
    }

    private String addExtension(String path, String extension) {
        if (path.toUpperCase().endsWith(extension.toUpperCase())) {
            return path;
        }
        if (path.endsWith(".")) {
            return path + extension;
        }
        return path + "." + extension;
    }

    private static class Runner {
        private Runner() {
        }

        public static void run(TaskMonitor monitor, PlugInContext context, File selFile) throws Exception {
            DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
            Document document = domImpl.createDocument(null, "svg", null);
            SVGGraphics2D svgGenerator = new SVGGraphics2D(document);
            LayerViewPanel lvp = context.getLayerViewPanel();
            RenderingManager rms = lvp.getRenderingManager();
            List<Layer> layers = context.getLayerManager().getVisibleLayers(false);
            int totalNumberOfFeatures = 0;
            Envelope view = context.getLayerViewPanel().getViewport().getEnvelopeInModelCoordinates();
            for (Layer layer : layers) {
                FeatureCollectionWrapper fc = layer.getFeatureCollectionWrapper();
                totalNumberOfFeatures += fc.query(view).size();
            }
            if (totalNumberOfFeatures > 100000) {
                JTextArea labelArea = new JTextArea();
                labelArea.setEditable(false);
                labelArea.setOpaque(false);
                labelArea.setFont(new JLabel().getFont());
                labelArea.setText(I18N.getInstance().get("org.openjump.core.ui.plugin.file.SaveImageAsSVGPlugIn.large-dataset-message"));
                OKCancelDialog dialog = new OKCancelDialog(context.getWorkbenchFrame(), I18N.getInstance().get("org.openjump.core.ui.plugin.file.SaveImageAsSVGPlugIn.warning-message-title"), true, (Component)labelArea, null);
                dialog.setVisible(true);
                if (!dialog.wasOKPressed()) {
                    return;
                }
            }
            for (Layer layer : layers) {
                Renderer myR = rms.getRenderer(layer);
                if (!(myR instanceof LayerRenderer)) continue;
                LayerRenderer myRnew = (LayerRenderer)myR;
                myRnew.setMaxFeatures(10000000);
            }
            Viewport viewport = lvp.getViewport();
            Java2DConverter oldConverter = viewport.getJava2DConverter();
            viewport.setJava2DConverter(new Java2DConverter(viewport, 0.001));
            svgGenerator.scale(0.9375000000000001, 0.9375000000000001);
            lvp.paintComponent((Graphics)svgGenerator);
            lvp.getViewport().setJava2DConverter(oldConverter);
            for (Layer layer : layers) {
                Renderer myR = rms.getRenderer(layer);
                if (!(myR instanceof LayerRenderer)) continue;
                LayerRenderer myRnew = (LayerRenderer)myR;
                myRnew.setMaxFeatures(100);
            }
            try {
                FileOutputStream fos = new FileOutputStream(selFile, false);
                OutputStreamWriter out = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);
                svgGenerator.stream((Writer)out, true);
                out.close();
            }
            catch (Exception e) {
                context.getWorkbenchFrame().handleThrowable(e);
            }
        }
    }
}

