/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.file;

import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JMenu;
import javax.swing.event.MenuListener;
import org.openjump.core.ui.plugin.AbstractUiPlugIn;
import org.openjump.core.ui.plugin.file.OpenFilePlugIn;
import org.openjump.core.ui.plugin.file.OpenProjectPlugIn;
import org.openjump.swing.listener.InvokeMethodPropertyChangeListener;

public class OpenRecentPlugIn
extends AbstractUiPlugIn {
    private static final String KEY = OpenRecentPlugIn.class.getName();
    private static final String RECENT_FILES_KEY = KEY + ".FILES";
    private static final String RECENT_PROJECTS_KEY = KEY + ".PROJECTS";
    private final Set<PropertyChangeListener> listeners = new LinkedHashSet<PropertyChangeListener>();
    private Set<String> recentFiles = new LinkedHashSet<String>();
    private Set<String> recentProjects = new LinkedHashSet<String>();
    private FeatureInstaller featureInstaller;
    private JMenu recentMenu;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OpenRecentPlugIn get(WorkbenchContext context) throws Exception {
        Blackboard blackboard = context.getBlackboard();
        String string = KEY;
        synchronized (string) {
            OpenRecentPlugIn plugin = (OpenRecentPlugIn)blackboard.get(KEY);
            if (plugin == null) {
                plugin = new OpenRecentPlugIn();
                plugin.initialize(context.createPlugInContext());
                blackboard.put(KEY, plugin);
            }
            return plugin;
        }
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        this.featureInstaller = context.getFeatureInstaller();
        this.recentFiles = this.getFileNames(RECENT_FILES_KEY);
        this.recentProjects = this.getFileNames(RECENT_PROJECTS_KEY);
        FeatureInstaller featureInstaller = context.getFeatureInstaller();
        this.recentMenu = featureInstaller.addMainMenu(new String[]{MenuNames.FILE}, this.getName());
        InvokeMethodPropertyChangeListener listener = new InvokeMethodPropertyChangeListener(this, "updateFileAndProjectMenu", new Object[]{this.recentMenu}, true);
        this.addPropertyChangeListener(listener);
        this.updateFileAndProjectMenu(this.recentMenu);
    }

    public synchronized List<String> getRecentFiles() {
        return new ArrayList<String>(this.recentFiles);
    }

    public synchronized List<String> getRecentProjects() {
        return new ArrayList<String>(this.recentProjects);
    }

    private synchronized Set<String> getFileNames(String key) {
        Blackboard blackboard = PersistentBlackboardPlugIn.get(this.workbenchContext);
        LinkedHashSet fileNames = (LinkedHashSet)blackboard.get(key);
        if (fileNames == null) {
            fileNames = new LinkedHashSet();
            blackboard.put(key, fileNames);
        }
        return fileNames;
    }

    public void addRecentFile(File file) {
        this.addRecent(this.recentFiles, RECENT_FILES_KEY, file);
    }

    public void addRecentProject(File file) {
        this.addRecent(this.recentProjects, RECENT_PROJECTS_KEY, file);
    }

    public void updateMenu() {
        this.updateFileAndProjectMenu(this.recentMenu);
    }

    private synchronized void addRecent(Set<String> files, String key, File file) {
        try {
            String fileName = file.getCanonicalPath();
            files.remove(fileName);
            files.add(fileName);
            while (files.size() > 10) {
                files.remove(files.iterator().next());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.firePropertyChange(new PropertyChangeEvent(OpenRecentPlugIn.class, key, null, files));
    }

    private void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    private void firePropertyChange(PropertyChangeEvent event) {
        for (PropertyChangeListener listener : this.listeners) {
            listener.propertyChange(event);
        }
    }

    public boolean hasRecentItems() {
        return !this.recentFiles.isEmpty() || !this.recentProjects.isEmpty();
    }

    public synchronized void updateFileAndProjectMenu(JMenu recentMenu) {
        String[] menuPath = new String[]{MenuNames.FILE, this.getName()};
        for (MenuListener listener : recentMenu.getMenuListeners()) {
            recentMenu.removeMenuListener(listener);
        }
        recentMenu.setEnabled(this.hasRecentItems());
        recentMenu.removeAll();
        List<String> files = this.getRecentFiles();
        Collections.reverse(files);
        for (String fileName : files) {
            File file = new File(fileName);
            OpenRecentFilePlugin openFilePlugin = new OpenRecentFilePlugin(this.workbenchContext, file);
            this.featureInstaller.addMainMenuPlugin(openFilePlugin, menuPath);
        }
        List<String> projects = this.getRecentProjects();
        if (!files.isEmpty() && !projects.isEmpty()) {
            recentMenu.addSeparator();
        }
        Collections.reverse(projects);
        for (String fileName : projects) {
            File file = new File(fileName);
            OpenRecentProjectPlugin openProjectPlugin = new OpenRecentProjectPlugin(this.workbenchContext, file);
            this.featureInstaller.addMainMenuPlugin(openProjectPlugin, menuPath);
        }
    }

    class OpenRecentProjectPlugin
    extends OpenProjectPlugIn {
        public OpenRecentProjectPlugin(WorkbenchContext workbenchContext, File file) {
            super(workbenchContext, file);
        }

        public OpenRecentProjectPlugin(WorkbenchContext workbenchContext, File[] files) {
            super(workbenchContext, files);
        }
    }

    class OpenRecentFilePlugin
    extends OpenFilePlugIn {
        public OpenRecentFilePlugin(WorkbenchContext workbenchContext, File file) {
            super(workbenchContext, file);
        }

        public OpenRecentFilePlugin(WorkbenchContext workbenchContext, File[] files) {
            super(workbenchContext, files);
        }
    }
}

