/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.edittoolbox.cursortools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelProxy;
import com.vividsolutions.jump.workbench.ui.OKCancelDialog;
import com.vividsolutions.jump.workbench.ui.cursortool.NClickTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.FeatureDrawingUtil;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Shape;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.operation.polygonize.Polygonizer;

public class FillPolygonTool
extends NClickTool {
    public static final String AREA_NOT_CLOSED = I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.cursortools.FillPolygonTool.clicked-area-is-not-closed");
    public static final String EXTEND_SEARCH = I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.cursortools.FillPolygonTool.do-you-want-to-extend-search-out-of-the-view");
    public static final String INTERRUPTION = I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.cursortools.FillPolygonTool.interrupted-operation");
    public static final String COMPUTING = I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.cursortools.FillPolygonTool.computing");
    private WorkbenchContext context;
    private static long START = 0L;
    private static long END = 0L;
    private static boolean INTERRUPTED = false;
    final OKCancelDialog okCancelDialog;
    final JDialog progressDialog;

    public FillPolygonTool(WorkbenchContext context) {
        super(context, 1);
        this.context = context;
        this.okCancelDialog = new OKCancelDialog(context.getWorkbench().getFrame(), I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.cursortools.FillPolygonTool"), true, (Component)this.getOKCancelPanel(), null);
        this.progressDialog = new JDialog(context.getWorkbench().getFrame(), COMPUTING + "...", true);
        this.initProgressDialog();
    }

    private JPanel getOKCancelPanel() {
        JPanel panel = new JPanel(new GridLayout(2, 1));
        panel.add(new JLabel(AREA_NOT_CLOSED));
        panel.add(new JLabel(EXTEND_SEARCH));
        return panel;
    }

    private void initProgressDialog() {
        JProgressBar jpb = new JProgressBar();
        jpb.setIndeterminate(true);
        this.progressDialog.add(jpb);
        this.progressDialog.pack();
        this.progressDialog.setLocationRelativeTo(this.context.getWorkbench().getFrame());
        this.progressDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                try {
                    if (START > END) {
                        INTERRUPTED = true;
                    } else {
                        INTERRUPTED = false;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                finally {
                    INTERRUPTED = false;
                }
            }
        });
    }

    @Override
    protected Shape getShape() throws NoninvertibleTransformException {
        return null;
    }

    @Override
    public Icon getIcon() {
        return new ImageIcon(this.getClass().getResource("FillPolygon.gif"));
    }

    @Override
    public String getName() {
        return I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.cursortools.FillPolygonTool");
    }

    @Override
    protected void gestureFinished() throws Exception {
        this.reportNothingToUndoYet();
        FeatureDrawingUtil featureDrawingUtil = new FeatureDrawingUtil((LayerNamePanelProxy)((Object)this.context.getLayerNamePanel()));
        if (new Date().getTime() < END + 500L) {
            return;
        }
        Polygon polygon = this.getPolygon(true);
        if (INTERRUPTED) {
            this.context.getWorkbench().getFrame().warnUser(INTERRUPTION);
        } else if (polygon != null && !polygon.isEmpty()) {
            UndoableCommand command = featureDrawingUtil.createAddCommand((Geometry)polygon, this.isRollingBackInvalidEdits(), this.getPanel(), this);
            if (command != null) {
                this.execute(command);
            }
        } else {
            GUIUtil.centreOnWindow(this.okCancelDialog);
            this.okCancelDialog.setVisible(true);
            if (this.okCancelDialog.wasOKPressed()) {
                polygon = this.getPolygon(false);
                if (INTERRUPTED) {
                    this.context.getWorkbench().getFrame().warnUser(INTERRUPTION);
                } else if (!polygon.isEmpty()) {
                    this.execute(featureDrawingUtil.createAddCommand((Geometry)polygon, this.isRollingBackInvalidEdits(), this.getPanel(), this), true);
                } else {
                    this.context.getWorkbench().getFrame().warnUser(AREA_NOT_CLOSED);
                }
            } else {
                this.context.getWorkbench().getFrame().warnUser(INTERRUPTION);
            }
        }
        INTERRUPTED = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Polygon getPolygon(final boolean inViewportOnly) throws NoninvertibleTransformException {
        block7: {
            final ArrayList polys = new ArrayList();
            INTERRUPTED = false;
            Thread t = new Thread(){

                @Override
                public void run() {
                    START = new Date().getTime();
                    Polygonizer polygonizer = new Polygonizer();
                    polygonizer.add((Collection)FillPolygonTool.this.getVisibleGeometries(inViewportOnly));
                    polys.addAll(polygonizer.getPolygons());
                    END = new Date().getTime();
                    if (FillPolygonTool.this.progressDialog.isShowing()) {
                        FillPolygonTool.this.progressDialog.dispose();
                    }
                }
            };
            t.start();
            this.progressDialog.setVisible(true);
            GUIUtil.centreOnWindow(this.progressDialog);
            try {
                t.join();
                if (INTERRUPTED) break block7;
                Coordinate c = this.getCoordinates().get(0);
                Point p = new GeometryFactory().createPoint(c);
                for (Object poly : polys) {
                    if (!((Polygon)poly).intersects((Geometry)p)) continue;
                    Polygon polygon = (Polygon)poly;
                    return polygon;
                }
                GeometryFactory gf = new GeometryFactory();
                Polygon polygon = gf.createPolygon(gf.createLinearRing(new Coordinate[0]), null);
                return polygon;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                INTERRUPTED = false;
            }
        }
        return null;
    }

    private Set<Geometry> getVisibleGeometries(boolean inViewportOnly) {
        List<Layer> layers = this.context.getLayerManager().getVisibleLayers(false);
        Envelope env = null;
        HashSet<Geometry> list = new HashSet<Geometry>();
        if (inViewportOnly) {
            env = this.context.getLayerViewPanel().getViewport().getEnvelopeInModelCoordinates();
        } else {
            env = new Envelope();
            for (Layer layer : layers) {
                env.expandToInclude(layer.getFeatureCollectionWrapper().getEnvelope());
            }
        }
        for (Layer layer : layers) {
            List<Feature> features = layer.getFeatureCollectionWrapper().getFeatures();
            for (Object e : features) {
                Geometry geom = ((Feature)e).getGeometry();
                if (!geom.getEnvelopeInternal().intersects(env) || geom.getDimension() <= 0) continue;
                this.extractLinearComponents(geom, list);
            }
        }
        return list;
    }

    private void extractLinearComponents(Geometry geom, Set<Geometry> linearComponents) {
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            Geometry g = geom.getGeometryN(i);
            if (g instanceof Polygon) {
                this.extractLinearComponents((Polygon)g, linearComponents);
                continue;
            }
            if (g instanceof LineString) {
                this.extractLinearComponents((LineString)g, linearComponents);
                continue;
            }
            if (g instanceof Point) continue;
            this.extractLinearComponents(g, linearComponents);
        }
    }

    private void extractLinearComponents(Polygon poly, Set<Geometry> linearComponents) {
        this.extractLinearComponents((LineString)poly.getExteriorRing(), linearComponents);
        for (int i = 0; i < poly.getNumInteriorRing(); ++i) {
            this.extractLinearComponents((LineString)poly.getInteriorRingN(i), linearComponents);
        }
    }

    private void extractLinearComponents(LineString line, Set<Geometry> linearComponents) {
        Coordinate[] cc = line.getCoordinates();
        for (int i = 1; i < cc.length; ++i) {
            LineString ls = line.getFactory().createLineString(new Coordinate[]{new Coordinate(cc[i - 1]), new Coordinate(cc[i])});
            ls.normalize();
            linearComponents.add((Geometry)ls);
        }
    }
}

