/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.edittoolbox.cursortools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.LayerableNamePanel;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.PolygonTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.FeatureDrawingUtil;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;

public class CutPolygonTool
extends PolygonTool {
    static final String sCookieCut = I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.cursortools.CutPolygonTool.Create-Cookie-Cut");
    Geometry geomSelected = null;
    Geometry geomDraw = null;
    Geometry newGeomIntersect = null;
    Geometry newGeomDiff = null;
    private FeatureDrawingUtil featureDrawingUtil;

    protected CutPolygonTool(WorkbenchContext context, FeatureDrawingUtil featureDrawingUtil) {
        super(context);
        this.featureDrawingUtil = featureDrawingUtil;
    }

    public static CursorTool create(WorkbenchContext context) {
        FeatureDrawingUtil featureDrawingUtil = new FeatureDrawingUtil(context);
        return featureDrawingUtil.prepare(new CutPolygonTool(context, featureDrawingUtil), true);
    }

    @Override
    public Icon getIcon() {
        return new ImageIcon(this.getClass().getResource("CutPolygon.gif"));
    }

    @Override
    public String getName() {
        return sCookieCut;
    }

    @Override
    protected void gestureFinished() throws Exception {
        WorkbenchContext context = this.getWorkbench().getContext();
        this.reportNothingToUndoYet();
        LayerableNamePanel layernamepanel = context.getLayerableNamePanel();
        Layer[] selectedLayers = layernamepanel.getSelectedLayers();
        if (selectedLayers.length == 0) {
            JOptionPane.showMessageDialog(null, I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.At-least-one-layer-must-be-selected", 1), I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.Information"), 1);
        } else if (selectedLayers.length > 1) {
            JOptionPane.showMessageDialog(null, I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.Exactly-one-layer-must-have-selected-items", 1), I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.Information"), 1);
        } else {
            Layer activeLayer = selectedLayers[0];
            Collection<Feature> selectedFeatures = context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems(activeLayer);
            if (activeLayer.isEditable()) {
                if (!this.checkPolygon()) {
                    return;
                }
                for (Feature featureSelected : selectedFeatures) {
                    this.geomSelected = featureSelected.getGeometry();
                    this.geomDraw = this.getPolygon();
                    if (!this.getPolygon().intersects(this.geomSelected) || !(this.geomSelected instanceof Polygon) && !(this.geomSelected instanceof MultiPolygon)) continue;
                    this.newGeomIntersect = this.geomSelected.intersection(this.geomDraw);
                    this.newGeomDiff = this.geomSelected.difference(this.geomDraw);
                    BasicFeature featureIntersect = new BasicFeature(activeLayer.getFeatureCollectionWrapper().getFeatureSchema());
                    BasicFeature featureDiff = new BasicFeature(activeLayer.getFeatureCollectionWrapper().getFeatureSchema());
                    FeatureUtil.copyAttributes(featureSelected, featureIntersect);
                    featureIntersect.setGeometry(this.newGeomIntersect);
                    FeatureUtil.copyAttributes(featureSelected, featureDiff);
                    featureDiff.setGeometry(this.newGeomDiff);
                    FeatureCollection features = activeLayer.getFeatureCollectionWrapper().getUltimateWrappee();
                    EditTransaction edtr = new EditTransaction(new ArrayList<Feature>(), "cut polygon", activeLayer, true, true, context.getLayerViewPanel());
                    edtr.deleteFeature(featureSelected);
                    edtr.createFeature(featureIntersect);
                    edtr.createFeature(featureDiff);
                    edtr.commit();
                    edtr.clearEnvelopeCaches();
                }
            } else {
                JOptionPane.showMessageDialog(null, I18N.getInstance().get("ui.SchemaPanel.layer-must-be-editable"), I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.Information"), 1);
            }
        }
    }

    protected boolean isRollingBackInvalidEdits(WorkbenchContext context) {
        return PersistentBlackboardPlugIn.get(context).get(EditTransaction.ROLLING_BACK_INVALID_EDITS_KEY, false);
    }
}

