/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.edittoolbox.cursortools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.PolygonTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.FeatureDrawingUtil;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;

public class AutoCompletePolygonCursorTool
extends PolygonTool {
    static final String sAutoComplete = I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.cursortools.AutoCompletePolygonCursorTool.Auto-Complete-Polygon");
    static final String sCanNotAdd = I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.cursortools.AutoCompletePolygonCursorTool.Can-not-add-polygon");
    private FeatureDrawingUtil featureDrawingUtil;

    protected AutoCompletePolygonCursorTool(WorkbenchContext context, FeatureDrawingUtil featureDrawingUtil) {
        super(context);
        this.featureDrawingUtil = featureDrawingUtil;
    }

    @Override
    public String getName() {
        return sAutoComplete;
    }

    public AutoCompletePolygonCursorTool(WorkbenchContext context) {
        super(context);
        this.allowSnapping();
    }

    public static CursorTool create(WorkbenchContext context) {
        FeatureDrawingUtil featureDrawingUtil = new FeatureDrawingUtil(context);
        return featureDrawingUtil.prepare(new AutoCompletePolygonCursorTool(context, featureDrawingUtil), true);
    }

    @Override
    protected void gestureFinished() throws Exception {
        Geometry newGeo;
        this.reportNothingToUndoYet();
        WorkbenchContext context = this.getWorkbench().getContext();
        Collection<Layer> editableLayers = this.getPanel().getLayerManager().getEditableLayers();
        if (editableLayers.size() == 0) {
            this.getPanel().getContext().warnUser(I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.At-least-one-layer-must-be-editable"));
            return;
        }
        Collection<Feature> mask = this.getPanel().getSelectionManager().getFeaturesWithSelectedItems();
        if (!this.checkPolygon()) {
            return;
        }
        if (mask.isEmpty()) {
            if (editableLayers.size() > 1) {
                editableLayers.retainAll(Arrays.asList(context.getLayerableNamePanel().getSelectedLayers()));
            }
            if (editableLayers.size() > 1) {
                this.getPanel().getContext().warnUser(I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.Exactly-one-selected-layer-must-be-editable"));
                return;
            }
            Layer layer = editableLayers.iterator().next();
            mask = layer.getFeatureCollectionWrapper().getFeatures();
        }
        Polygon poly = this.getPolygon();
        Geometry diffGeo = newGeo = poly.getGeometryN(0);
        try {
            for (Feature feature : mask) {
                diffGeo = diffGeo.difference(feature.getGeometry());
            }
            if (diffGeo instanceof Polygon) {
                this.featureDrawingUtil.drawRing((Polygon)diffGeo, this.isRollingBackInvalidEdits(), this, this.getPanel());
            }
        }
        catch (Exception e) {
            this.getPanel().getContext().warnUser(sCanNotAdd + " " + e);
        }
    }

    @Override
    public Icon getIcon() {
        return new ImageIcon(this.getClass().getResource("AutoCompletePoly.gif"));
    }
}

