/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.UndoableEditReceiver;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.ErrorHandler;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.task.TaskMonitorManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;

public abstract class AbstractUiPlugIn
extends AbstractPlugIn
implements ActionListener {
    private Icon icon;
    private String name;
    protected WorkbenchContext workbenchContext;
    private String toolTip;
    protected EnableCheck enableCheck = new MultiEnableCheck();

    public AbstractUiPlugIn() {
    }

    public AbstractUiPlugIn(String name) {
        this.name = name;
    }

    public AbstractUiPlugIn(Icon icon) {
        this.icon = icon;
    }

    public AbstractUiPlugIn(String name, String toolTip) {
        this.name = name;
        this.toolTip = toolTip;
    }

    public AbstractUiPlugIn(String name, Icon icon) {
        this.name = name;
        this.icon = icon;
    }

    public AbstractUiPlugIn(String name, Icon icon, String toolTip) {
        this.name = name;
        this.icon = icon;
        this.toolTip = toolTip;
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        this.workbenchContext = context.getWorkbenchContext();
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        return true;
    }

    @Override
    protected void reportNothingToUndoYet(PlugInContext context) {
        LayerManager layerManager = context.getLayerManager();
        if (layerManager != null) {
            layerManager.getUndoableEditReceiver().reportNothingToUndoYet();
        }
    }

    @Override
    protected boolean isRollingBackInvalidEdits(PlugInContext context) {
        return PersistentBlackboardPlugIn.get(context.getWorkbenchContext()).get(EditTransaction.ROLLING_BACK_INVALID_EDITS_KEY, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            JUMPWorkbench workbench = this.workbenchContext.getWorkbench();
            if (workbench != null) {
                WorkbenchFrame frame = workbench.getFrame();
                frame.setStatusMessage("");
                Logger.info(I18N.getInstance().get("plugin.AbstractPlugIn.executing") + " " + this.getName());
            }
            PlugInContext plugInContext = this.workbenchContext.createPlugInContext();
            LayerManager layerManager = this.workbenchContext.getLayerManager();
            UndoableEditReceiver undoableEditReceiver = null;
            if (layerManager != null && (undoableEditReceiver = layerManager.getUndoableEditReceiver()) != null) {
                undoableEditReceiver.startReceiving();
            }
            try {
                boolean executeComplete = this.execute(plugInContext);
                if (executeComplete && this instanceof ThreadedPlugIn) {
                    new TaskMonitorManager().execute((ThreadedPlugIn)((Object)this), plugInContext);
                }
            }
            finally {
                if (undoableEditReceiver != null) {
                    undoableEditReceiver.stopReceiving();
                }
            }
            if (workbench != null) {
                WorkbenchFrame frame = workbench.getFrame();
                Logger.info(I18N.getInstance().get("plugin.AbstractPlugIn.done-current-committed-memory") + frame.getMBCommittedMemory() + " MB");
            }
        }
        catch (Throwable t) {
            ErrorHandler errorHandler = this.workbenchContext.getErrorHandler();
            errorHandler.handleThrowable(t);
        }
    }

    @Override
    public EnableCheck getEnableCheck() {
        return this.enableCheck;
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public String getName() {
        return this.name != null ? this.name : super.getName();
    }

    public String getToolTip() {
        return this.toolTip;
    }

    protected void setWorkbenchContext(WorkbenchContext workbenchContext) {
        this.workbenchContext = workbenchContext;
    }
}

