/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.rasterimage.styler.ui;

import com.vividsolutions.jump.workbench.Logger;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openjump.core.rasterimage.RasterImageLayer;
import org.openjump.core.rasterimage.RasterSymbology;
import org.openjump.core.rasterimage.styler.ColorMapEntry;
import org.openjump.core.rasterimage.styler.ColorUtils;
import org.openjump.core.rasterimage.styler.I18N;
import org.openjump.core.rasterimage.styler.ui.ColorsTablePanel;
import org.openjump.core.rasterimage.styler.ui.GUIUtils;
import org.openjump.core.rasterimage.styler.ui.GradientCanvas;
import org.openjump.core.rasterimage.styler.ui.GradientComboBox;

public class SingleValuesPanel
extends JPanel {
    private final Component parent;
    private double[] rasterDataNoNull;
    private final RasterImageLayer rasterImageLayer;
    private ColorsTablePanel colorsTablePanel = null;
    private GradientComboBox jComboBox_Gradient;
    private boolean integerValues;
    private boolean firstTimeShown = true;
    private JButton jButton1;
    private JButton jButton_Ramp;
    private JButton jButton_Random;
    private JPanel jPanel_Table;

    public SingleValuesPanel(Component parent, double[] rasterDataNoNull, RasterImageLayer rasterImageLayer) {
        this.initComponents();
        this.parent = parent;
        this.rasterDataNoNull = rasterDataNoNull;
        this.rasterImageLayer = rasterImageLayer;
        this.fixComponents();
    }

    public void reset() {
        try {
            this.findUniqueValues();
            this.rampAll(true);
        }
        catch (Exception ex) {
            Logger.error(ex);
        }
    }

    private void initComponents() {
        this.jPanel_Table = new JPanel();
        this.jButton_Ramp = new JButton();
        this.jButton_Random = new JButton();
        this.jButton1 = new JButton();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                SingleValuesPanel.this.formComponentShown(evt);
            }
        });
        GridBagLayout layout = new GridBagLayout();
        layout.columnWidths = new int[]{0, 5, 0, 5, 0};
        layout.rowHeights = new int[]{0, 5, 0, 5, 0, 5, 0};
        this.setLayout(layout);
        this.jPanel_Table.setBorder(BorderFactory.createEtchedBorder());
        GroupLayout jPanel_TableLayout = new GroupLayout(this.jPanel_Table);
        this.jPanel_Table.setLayout(jPanel_TableLayout);
        jPanel_TableLayout.setHorizontalGroup(jPanel_TableLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 246, Short.MAX_VALUE));
        jPanel_TableLayout.setVerticalGroup(jPanel_TableLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 166, Short.MAX_VALUE));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel_Table, gridBagConstraints);
        this.jButton_Ramp.setText(I18N.get("org.openjump.core.rasterimage.styler.ui.SingleValuesPanel.jButton_RampAll"));
        this.jButton_Ramp.addActionListener(this::jButton_RampActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jButton_Ramp, gridBagConstraints);
        this.jButton_Random.setText(I18N.get("org.openjump.core.rasterimage.styler.ui.SingleValuesPanel.jButton_Random"));
        this.jButton_Random.addActionListener(this::jButton_RandomActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jButton_Random, gridBagConstraints);
        this.jButton1.setText(I18N.get("org.openjump.core.rasterimage.styler.ui.SingleValuesPanel.jButton_Ramp"));
        this.jButton1.addActionListener(this::jButton1ActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jButton1, gridBagConstraints);
    }

    private void jButton_RampActionPerformed(ActionEvent evt) {
        try {
            this.rampAll(false);
        }
        catch (Exception ex) {
            Logger.error(ex);
        }
    }

    private void jButton_RandomActionPerformed(ActionEvent evt) {
        try {
            this.rampAll(true);
        }
        catch (Exception ex) {
            Logger.error(ex);
        }
    }

    private void formComponentShown(ComponentEvent evt) {
        if (this.firstTimeShown) {
            this.firstTimeShown = false;
            try {
                this.findUniqueValues();
                this.rampAll(true);
            }
            catch (Exception ex) {
                Logger.error(ex);
            }
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        try {
            this.rampColors();
        }
        catch (Exception ex) {
            Logger.error(ex);
        }
    }

    private void fixComponents() {
        this.jComboBox_Gradient = GUIUtils.createStandardGradientComboBox(200, 18);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jComboBox_Gradient, gridBagConstraints);
        GUIUtils.addGradientComboBoxToList(this.jComboBox_Gradient);
    }

    private void findUniqueValues() {
        TreeSet<Double> uniqueValues_m = new TreeSet<Double>();
        this.integerValues = true;
        for (int v = 0; v < this.rasterDataNoNull.length; ++v) {
            uniqueValues_m.add(this.rasterDataNoNull[v]);
            if (this.rasterDataNoNull[v] == (double)((int)this.rasterDataNoNull[v])) continue;
            this.integerValues = false;
        }
        this.rasterDataNoNull = new double[uniqueValues_m.size()];
        Iterator iter = uniqueValues_m.iterator();
        int pos = 0;
        while (iter.hasNext()) {
            double value = (Double)iter.next();
            this.rasterDataNoNull[pos++] = value;
        }
    }

    private void rampAll(boolean randomColors) throws Exception {
        ColorUtils colorUtils = new ColorUtils();
        ColorMapEntry[] colorMapEntries = new ColorMapEntry[this.rasterDataNoNull.length];
        if (randomColors) {
            for (int c = 0; c < this.rasterDataNoNull.length; ++c) {
                colorMapEntries[c] = new ColorMapEntry(this.rasterDataNoNull[c], colorUtils.randomColor());
            }
        } else {
            ColorMapEntry[] paletteColorMapEntries = ((GradientCanvas)this.jComboBox_Gradient.getSelectedItem()).getColorMapEntries();
            int colorsCount = paletteColorMapEntries.length;
            for (int c = 0; c < this.rasterDataNoNull.length; ++c) {
                double cellRelDistance = (double)c / (double)(this.rasterDataNoNull.length - 1);
                double colorRelDistance = cellRelDistance * (double)(colorsCount - 1);
                Color startColor = paletteColorMapEntries[(int)Math.floor(colorRelDistance)].getColor();
                Color endColor = paletteColorMapEntries[(int)Math.ceil(colorRelDistance)].getColor();
                Color color = colorUtils.interpolateColor(startColor, endColor, cellRelDistance);
                colorMapEntries[c] = new ColorMapEntry(this.rasterDataNoNull[c], color);
            }
        }
        this.updateTable(colorMapEntries);
    }

    private void rampColors() throws Exception {
        if (this.colorsTablePanel.getSelectedRowsCount() != 2) {
            JOptionPane.showMessageDialog(this, I18N.get("org.openjump.core.rasterimage.styler.ui.SingleValuesPanel.message.SelectTwoRows"), "Raster Styles", 2);
        }
        this.colorsTablePanel.rampColors();
    }

    public RasterSymbology getRasterStyler() throws Exception {
        RasterSymbology rasterSymbolizer = new RasterSymbology("SINGLE");
        for (ColorMapEntry colorMapEntry : this.colorsTablePanel.getColorMapEntries()) {
            rasterSymbolizer.addColorMapEntry(colorMapEntry.getUpperValue(), colorMapEntry.getColor());
        }
        return rasterSymbolizer;
    }

    public void plugRasterSymbology(RasterSymbology rasterSymbology) {
        this.updateTable(rasterSymbology.getColorMapEntries());
    }

    private void updateTable(ColorMapEntry[] colorMapEntries) {
        if (this.colorsTablePanel == null) {
            this.colorsTablePanel = new ColorsTablePanel(this.parent, ColorsTablePanel.TableType.VALUES, colorMapEntries, this.rasterImageLayer.getNoDataValue(), this.integerValues);
            GridBagLayout layout = (GridBagLayout)this.getLayout();
            GridBagConstraints gbc = layout.getConstraints(this.jPanel_Table);
            this.remove(this.jPanel_Table);
            this.add((Component)this.colorsTablePanel, gbc);
            this.validate();
        } else {
            this.colorsTablePanel.updateTable(colorMapEntries);
        }
    }

    public GradientComboBox getGradientComboBox() {
        return this.jComboBox_Gradient;
    }
}

