/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.rasterimage.styler.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import org.openjump.core.rasterimage.styler.ColorMapEntry;

public class GradientCanvas
extends JComponent {
    private final ColorMapEntry[] colorMapEntries;
    private final float width;
    private final float height;
    private final GradientType type;
    private final GradientOrientation orientation;

    public GradientCanvas(ColorMapEntry[] colorMapEntries, int width, int height, GradientType type) {
        this.colorMapEntries = colorMapEntries;
        this.width = width;
        this.height = height;
        this.type = type;
        this.orientation = GradientOrientation.DIRECT;
        super.setSize(new Dimension(width, height));
    }

    public GradientCanvas(ColorMapEntry[] colorMapEntries, int width, int height, GradientType type, GradientOrientation orientation) {
        this.colorMapEntries = colorMapEntries;
        this.width = width;
        this.height = height;
        this.type = type;
        this.orientation = orientation;
        super.setSize(new Dimension(width, height));
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        LinearGradientPaint paint = null;
        TreeMap<Float, Color> map = new TreeMap<Float, Color>();
        for (ColorMapEntry colorMapEntry : this.colorMapEntries) {
            float f = (float)(colorMapEntry.getUpperValue() / this.colorMapEntries[this.colorMapEntries.length - 1].getUpperValue());
            map.put(Float.valueOf(f), colorMapEntry.getColor());
        }
        float[] fractions = new float[map.size()];
        Color[] colors = new Color[map.size()];
        int index = 0;
        for (Map.Entry entry : map.entrySet()) {
            fractions[index] = ((Float)entry.getKey()).floatValue();
            colors[index] = (Color)entry.getValue();
            ++index;
        }
        System.out.println(Arrays.toString(fractions));
        if (this.type == GradientType.HORIZONTAL) {
            if (this.orientation == GradientOrientation.DIRECT) {
                paint = new LinearGradientPaint(0.0f, 0.0f, this.width, this.height, fractions, colors);
            } else if (this.orientation == GradientOrientation.INVERSE) {
                paint = new LinearGradientPaint(this.width, this.height, 0.0f, 0.0f, fractions, colors);
            }
        } else if (this.type == GradientType.VERTICAL) {
            if (this.orientation == GradientOrientation.DIRECT) {
                paint = new LinearGradientPaint(this.width / 2.0f, 0.0f, this.width / 2.0f, this.height, fractions, colors);
            }
            if (this.orientation == GradientOrientation.INVERSE) {
                paint = new LinearGradientPaint(this.width / 2.0f, this.height, this.width / 2.0f, 0.0f, fractions, colors);
            }
        }
        Paint oldPaint = g2d.getPaint();
        g2d.setPaint(paint);
        g2d.fillRect(0, 0, (int)this.width, (int)this.height);
        g2d.setPaint(oldPaint);
    }

    public GradientType getType() {
        return this.type;
    }

    public ColorMapEntry[] getColorMapEntries() {
        return this.colorMapEntries;
    }

    public GradientCanvas copy() {
        return new GradientCanvas(this.colorMapEntries, (int)this.width, (int)this.height, this.type);
    }

    public static enum GradientOrientation {
        DIRECT,
        INVERSE;

    }

    public static enum GradientType {
        HORIZONTAL,
        VERTICAL;

    }
}

