/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.rasterimage;

import java.awt.Color;
import java.util.Map;
import java.util.TreeMap;
import org.openjump.core.rasterimage.styler.ColorMapEntry;

public class RasterSymbology {
    private TreeMap<Double, Color> colorMapEntries_tm;
    private String colorMapType;
    private double transparency = 0.0;
    public static final String TYPE_RAMP = "RAMP";
    public static final String TYPE_INTERVALS = "INTERVALS";
    public static final String TYPE_SINGLE = "SINGLE";

    public RasterSymbology() {
    }

    public RasterSymbology(String colorMapType) {
        this.colorMapType = colorMapType;
        this.colorMapEntries_tm = new TreeMap();
    }

    public void addColorMapEntry(double upperValue, Color color) {
        this.colorMapEntries_tm.put(upperValue, color);
    }

    private ColorMapEntry getColorMapEntry(double cellValue) {
        if (this.colorMapEntries_tm.floorEntry(cellValue) != null) {
            return new ColorMapEntry(this.colorMapEntries_tm.floorEntry(cellValue).getKey(), this.colorMapEntries_tm.floorEntry(cellValue).getValue());
        }
        return null;
    }

    private ColorMapEntry getNextColorMapEntry(double cellValue) {
        if (this.colorMapEntries_tm.higherEntry(cellValue) != null) {
            return new ColorMapEntry(this.colorMapEntries_tm.higherEntry(cellValue).getKey(), this.colorMapEntries_tm.higherEntry(cellValue).getValue());
        }
        return null;
    }

    public String getColorMapType() {
        return this.colorMapType;
    }

    public void setColorMapType(String colorMapType) {
        this.colorMapType = colorMapType;
    }

    public TreeMap<Double, Color> getColorMapEntries_tm() {
        return this.colorMapEntries_tm;
    }

    public void setColorMapEntries_tm(TreeMap<Double, Color> colorMapEntries_tm) {
        this.colorMapEntries_tm = colorMapEntries_tm;
    }

    public ColorMapEntry[] getColorMapEntries() {
        ColorMapEntry[] colorMapEntries = new ColorMapEntry[this.getColorMapEntries_tm().size()];
        int pos = 0;
        for (Map.Entry<Double, Color> colorMapEntry : this.getColorMapEntries_tm().entrySet()) {
            colorMapEntries[pos] = new ColorMapEntry(colorMapEntry.getKey(), colorMapEntry.getValue());
            ++pos;
        }
        return colorMapEntries;
    }

    public double getTransparency() {
        return this.transparency;
    }

    public void setTransparency(double transparency) {
        this.transparency = transparency;
    }

    public Color getColor(double value) {
        if (this.colorMapType.equals(TYPE_RAMP)) {
            ColorMapEntry downColorMapEntry = this.getColorMapEntry(value);
            ColorMapEntry upColorMapEntry = this.getNextColorMapEntry(value);
            if (downColorMapEntry != null && upColorMapEntry == null) {
                return downColorMapEntry.getColor();
            }
            if (downColorMapEntry == null && upColorMapEntry != null) {
                return upColorMapEntry.getColor();
            }
            if (downColorMapEntry != null && upColorMapEntry != null) {
                if (downColorMapEntry.getColor() == null) {
                    return null;
                }
                if (upColorMapEntry.getColor() == null) {
                    return downColorMapEntry.getColor();
                }
                double distDown = value - downColorMapEntry.getUpperValue();
                double distUp = upColorMapEntry.getUpperValue() - value;
                double relDist = distDown / (distUp + distDown);
                Color newColor = RasterSymbology.calculateNewColor(downColorMapEntry.getColor(), upColorMapEntry.getColor(), relDist);
                return newColor;
            }
            return null;
        }
        if (this.colorMapType.equals(TYPE_INTERVALS)) {
            ColorMapEntry downColorMapEntry = this.getColorMapEntry(value);
            if (downColorMapEntry == null) {
                return null;
            }
            return downColorMapEntry.getColor();
        }
        if (this.colorMapType.equals(TYPE_SINGLE)) {
            ColorMapEntry downColorMapEntry = this.getColorMapEntry(value);
            if (downColorMapEntry == null) {
                return null;
            }
            return downColorMapEntry.getColor();
        }
        return null;
    }

    private static Color calculateNewColor(Color downColor, Color upColor, double relDist) {
        int red = (int)Math.round((double)(upColor.getRed() - downColor.getRed()) * relDist + (double)downColor.getRed());
        int green = (int)Math.round((double)(upColor.getGreen() - downColor.getGreen()) * relDist + (double)downColor.getGreen());
        int blue = (int)Math.round((double)(upColor.getBlue() - downColor.getBlue()) * relDist + (double)downColor.getBlue());
        return new Color(red, green, blue);
    }
}

