/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.rasterimage;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferFloat;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterFactory;

public class GridFloat {
    private String fltFullFileName = null;
    private String hdrFullFileName = null;
    private int nCols = 0;
    private int nRows = 0;
    private double xllCorner = 0.0;
    private double yllCorner = 0.0;
    private double cellSize = 0.0;
    private double noData = -9999.0;
    private ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
    private boolean origCorner = true;
    private float[] dataArray = null;
    private Raster raster = null;
    private long cellCount = 0L;
    private double minVal = Double.MAX_VALUE;
    private double maxVal = -1.7976931348623157E308;
    private double meanVal = 0.0;
    private double stDevVal = 0.0;
    private boolean isInteger = true;
    public static final String LSBFIRST = "LSBFIRST";
    public static final String MSBFIRST = "MSBFIRST";

    public GridFloat(String fltFullFileName) throws IOException {
        this.fltFullFileName = fltFullFileName;
        this.hdrFullFileName = fltFullFileName.substring(0, fltFullFileName.lastIndexOf(".")) + ".hdr";
        this.readHdr();
    }

    public GridFloat(String fltFullFileName, GridFloat gridFloat2) {
        this.fltFullFileName = fltFullFileName;
        this.hdrFullFileName = fltFullFileName.substring(0, fltFullFileName.lastIndexOf(".")) + ".hdr";
        this.nCols = gridFloat2.getnCols();
        this.nRows = gridFloat2.getnRows();
        this.xllCorner = gridFloat2.getXllCorner();
        this.yllCorner = gridFloat2.getYllCorner();
        this.cellSize = gridFloat2.getCellSize();
        this.noData = gridFloat2.getNoData();
        this.byteOrder = gridFloat2.getByteOrder();
    }

    public GridFloat(String fltFullFileName, int nCols, int nRows, boolean origCorner, double xllOrig, double yllOrig, double cellSize, double noData, ByteOrder byteOrder) {
        this.fltFullFileName = fltFullFileName;
        this.hdrFullFileName = fltFullFileName.substring(0, fltFullFileName.lastIndexOf(".")) + ".hdr";
        this.nCols = nCols;
        this.nRows = nRows;
        this.origCorner = origCorner;
        if (origCorner) {
            this.xllCorner = xllOrig;
            this.yllCorner = yllOrig;
        } else {
            this.xllCorner = xllOrig - 0.5 * cellSize;
            this.yllCorner = yllOrig - 0.5 * cellSize;
        }
        this.cellSize = cellSize;
        this.noData = noData;
        this.byteOrder = byteOrder;
    }

    private void readHdr() throws FileNotFoundException, IOException {
        String line;
        BufferedReader buffRead = new BufferedReader(new FileReader(this.hdrFullFileName));
        while ((line = buffRead.readLine()) != null) {
            String[] lines = line.split(" +");
            if (lines[0].toLowerCase().equals("ncols")) {
                this.nCols = Integer.parseInt(lines[1]);
                continue;
            }
            if (lines[0].toLowerCase().equals("nrows")) {
                this.nRows = Integer.parseInt(lines[1]);
                continue;
            }
            if (lines[0].toLowerCase().equals("xllcorner")) {
                this.xllCorner = Double.parseDouble(lines[1]);
                this.origCorner = true;
                continue;
            }
            if (lines[0].toLowerCase().equals("yllcorner")) {
                this.yllCorner = Double.parseDouble(lines[1]);
                continue;
            }
            if (lines[0].toLowerCase().equals("xllcenter")) {
                this.xllCorner = Double.parseDouble(lines[1]);
                this.origCorner = false;
                continue;
            }
            if (lines[0].toLowerCase().equals("yllcenter")) {
                this.yllCorner = Double.parseDouble(lines[1]);
                continue;
            }
            if (lines[0].toLowerCase().equals("cellsize")) {
                this.cellSize = Double.parseDouble(lines[1]);
                continue;
            }
            if (lines[0].toLowerCase().equals("nodata_value")) {
                this.noData = Double.parseDouble(lines[1]);
                continue;
            }
            if (!lines[0].toLowerCase().equals("byteorder")) continue;
            if (lines[1].equalsIgnoreCase(MSBFIRST)) {
                this.byteOrder = ByteOrder.BIG_ENDIAN;
                continue;
            }
            if (!lines[1].equalsIgnoreCase(LSBFIRST)) continue;
            this.byteOrder = ByteOrder.LITTLE_ENDIAN;
        }
        buffRead.close();
        if (!this.origCorner) {
            this.xllCorner = -0.5 * this.cellSize;
            this.yllCorner = -0.5 * this.cellSize;
        }
    }

    public void writeHdr() throws IOException {
        File fileHeader = new File(this.hdrFullFileName);
        FileWriter fileWriter = new FileWriter(fileHeader);
        BufferedWriter buffWrite = new BufferedWriter(fileWriter);
        buffWrite.write("ncols " + this.nCols);
        buffWrite.newLine();
        buffWrite.write("nrows " + this.nRows);
        buffWrite.newLine();
        if (this.origCorner) {
            buffWrite.write("xllcorner " + this.xllCorner);
            buffWrite.newLine();
            buffWrite.write("yllcorner " + this.yllCorner);
            buffWrite.newLine();
        } else {
            buffWrite.write("xllcenter " + this.xllCorner + 0.5 * this.cellSize);
            buffWrite.newLine();
            buffWrite.write("yllcenter " + this.yllCorner + 0.5 * this.cellSize);
            buffWrite.newLine();
        }
        buffWrite.write("cellsize " + this.cellSize);
        buffWrite.newLine();
        buffWrite.write("NODATA_value " + this.noData);
        buffWrite.newLine();
        buffWrite.write("byteorder " + this.byteOrder);
        buffWrite.newLine();
        buffWrite.close();
        fileWriter.close();
    }

    public void readGrid(Rectangle subset) throws FileNotFoundException, IOException {
        MappedByteBuffer mbb;
        long length;
        this.readHdr();
        double valSum = 0.0;
        double valSumSquare = 0.0;
        this.minVal = Double.MAX_VALUE;
        this.maxVal = -this.minVal;
        File fileFlt = new File(this.fltFullFileName);
        FileInputStream fileInStream = new FileInputStream(fileFlt);
        FileChannel fileChannel = fileInStream.getChannel();
        if (subset == null) {
            this.dataArray = new float[this.nCols * this.nRows];
            length = fileFlt.length();
            mbb = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, length);
            mbb.order(this.byteOrder);
            int i = 0;
            for (int p = 0; p < this.nCols * this.nRows; ++p) {
                this.dataArray[p] = mbb.getFloat(i);
                if ((double)this.dataArray[p] != this.noData) {
                    valSum += (double)this.dataArray[p];
                    valSumSquare += (double)(this.dataArray[p] * this.dataArray[p]);
                    ++this.cellCount;
                    if ((double)this.dataArray[p] < this.minVal) {
                        this.minVal = this.dataArray[p];
                    }
                    if ((double)this.dataArray[p] > this.maxVal) {
                        this.maxVal = this.dataArray[p];
                    }
                    if ((float)((int)this.dataArray[p]) != this.dataArray[p]) {
                        this.isInteger = false;
                    }
                }
                i += 4;
            }
            this.meanVal = valSum / (double)this.cellCount;
            this.stDevVal = Math.sqrt(valSumSquare / (double)this.cellCount - this.meanVal * this.meanVal);
        } else {
            this.dataArray = new float[subset.width * subset.height];
            length = subset.width * 4;
            for (int r = 0; r < subset.height; ++r) {
                long position = (subset.y + r) * this.nCols * 4 + subset.x * 4;
                mbb = fileChannel.map(FileChannel.MapMode.READ_ONLY, position, length);
                mbb.order(this.byteOrder);
                for (int c = 0; c < subset.width; ++c) {
                    int p = r * subset.width + c;
                    this.dataArray[p] = mbb.getFloat();
                    if ((double)this.dataArray[p] == this.noData) continue;
                    valSum += (double)this.dataArray[p];
                    valSumSquare += (double)(this.dataArray[p] * this.dataArray[p]);
                    ++this.cellCount;
                    if ((double)this.dataArray[p] < this.minVal) {
                        this.minVal = this.dataArray[p];
                    }
                    if ((double)this.dataArray[p] > this.maxVal) {
                        this.maxVal = this.dataArray[p];
                    }
                    if ((float)((int)this.dataArray[p]) == this.dataArray[p]) continue;
                    this.isInteger = false;
                }
            }
        }
        fileChannel.close();
        fileInStream.close();
        SampleModel sampleModel = RasterFactory.createBandedSampleModel((int)4, (int)this.nCols, (int)this.nRows, (int)1);
        DataBufferFloat db = new DataBufferFloat(this.dataArray, this.dataArray.length / 4);
        Point point = new Point();
        point.setLocation(0, 0);
        this.raster = WritableRaster.createWritableRaster(sampleModel, db, point);
    }

    public void writeGrid() throws IOException {
        if (this.raster == null) {
            SampleModel sampleModel = RasterFactory.createBandedSampleModel((int)5, (int)this.nCols, (int)this.nRows, (int)1);
            this.dataArray = new float[this.nCols * this.nRows];
            DataBufferFloat db = new DataBufferFloat(this.dataArray, this.nCols * this.nRows);
            Point point = new Point();
            point.setLocation(this.xllCorner, this.yllCorner);
            this.raster = RasterFactory.createRaster((SampleModel)sampleModel, (DataBuffer)db, (Point)point).createCompatibleWritableRaster();
        }
        this.writeHdr();
        File fileOut = new File(this.fltFullFileName);
        FileOutputStream fileOutStream = new FileOutputStream(fileOut);
        FileChannel fileChannelOut = fileOutStream.getChannel();
        ByteBuffer bb = ByteBuffer.allocateDirect(this.nCols * 4);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        for (int r = 0; r < this.nRows; ++r) {
            for (int c = 0; c < this.nCols; ++c) {
                if (bb.hasRemaining()) {
                    bb.putFloat(this.raster.getSampleFloat(c, r, 0));
                    continue;
                }
                --c;
                bb.compact();
                fileChannelOut.write(bb);
                bb.clear();
            }
        }
        bb.compact();
        fileChannelOut.write(bb);
        bb.clear();
        fileChannelOut.close();
        fileOutStream.close();
    }

    public void setFltFullFileName(String fltFullFileName) {
        this.fltFullFileName = fltFullFileName;
        this.hdrFullFileName = fltFullFileName.substring(0, fltFullFileName.lastIndexOf(".")) + ".hdr";
    }

    public boolean isSpatiallyEqualTo(GridFloat gridFloat2) {
        boolean isEqual = true;
        if (this.nCols != gridFloat2.getnCols()) {
            isEqual = false;
        }
        if (this.nRows != gridFloat2.getnRows()) {
            isEqual = false;
        }
        if (this.origCorner != gridFloat2.getOrigCorner()) {
            isEqual = false;
        }
        if (this.xllCorner != gridFloat2.getXllCorner()) {
            isEqual = false;
        }
        if (this.yllCorner != gridFloat2.getYllCorner()) {
            isEqual = false;
        }
        if (this.cellSize != gridFloat2.getCellSize()) {
            isEqual = false;
        }
        if (this.noData != gridFloat2.getNoData()) {
            isEqual = false;
        }
        if (!this.byteOrder.equals(gridFloat2.getByteOrder())) {
            isEqual = false;
        }
        return isEqual;
    }

    public BufferedImage getBufferedImage() {
        SampleModel sm = this.raster.getSampleModel();
        ColorModel colorModel = PlanarImage.createColorModel((SampleModel)sm);
        BufferedImage image = new BufferedImage(colorModel, WritableRaster.createWritableRaster(sm, this.raster.getDataBuffer(), new Point(0, 0)), false, null);
        return image;
    }

    public double readCellVal(Integer col, Integer row) throws FileNotFoundException, IOException {
        long offset = (row * this.nCols + col) * 4;
        File fileFlt = new File(this.fltFullFileName);
        FileInputStream fileInStream = new FileInputStream(fileFlt);
        FileChannel fileChannel = fileInStream.getChannel();
        long length = 4L;
        MappedByteBuffer mbb = fileChannel.map(FileChannel.MapMode.READ_ONLY, offset, length);
        mbb.order(ByteOrder.LITTLE_ENDIAN);
        fileChannel.close();
        fileInStream.close();
        return mbb.getFloat();
    }

    public int getnCols() {
        return this.nCols;
    }

    public void setnCols(int nCols) {
        this.nCols = nCols;
    }

    public int getnRows() {
        return this.nRows;
    }

    public void setnRows(int nRows) {
        this.nRows = nRows;
    }

    public double getXllCorner() {
        return this.xllCorner;
    }

    public void setXllCorner(double xllCorner) {
        this.xllCorner = xllCorner;
    }

    public double getYllCorner() {
        return this.yllCorner;
    }

    public void setYllCorner(double yllCorner) {
        this.yllCorner = yllCorner;
    }

    public boolean getOrigCorner() {
        return this.origCorner;
    }

    public void setOrigCorner(boolean origCorner) {
        this.origCorner = origCorner;
    }

    public double getCellSize() {
        return this.cellSize;
    }

    public void setCellSize(double cellSize) {
        this.cellSize = cellSize;
    }

    public double getNoData() {
        return this.noData;
    }

    public void setNoData(double noData) {
        this.noData = noData;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public Raster getRaster() {
        return this.raster;
    }

    public void setRas(Raster raster) {
        this.raster = raster;
        this.cellCount = 0L;
        DataBuffer db = raster.getDataBuffer();
        for (int e = 0; e < db.getSize(); ++e) {
            if (db.getElemDouble(e) == this.noData) continue;
            ++this.cellCount;
        }
    }

    public double getMinVal() {
        return this.minVal;
    }

    public double getMaxVal() {
        return this.maxVal;
    }

    public double getMeanVal() {
        return this.meanVal;
    }

    public double getStDevVal() {
        return this.stDevVal;
    }

    public long getCellCount() {
        return this.cellCount;
    }

    public boolean isInteger() {
        return this.isInteger;
    }

    public float[] getFloatArray() {
        return this.dataArray;
    }
}

