/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.rasterimage;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferFloat;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterFactory;

public class GridAscii {
    private String ascFullFileName = null;
    private boolean origCorner = false;
    private int nCols = 0;
    private int nRows = 0;
    private double xllCorner = 0.0;
    private double yllCorner = 0.0;
    private double cellSize = 0.0;
    private double noData = -9999.0;
    private float[] dataArray = null;
    private Raster raster = null;
    private long cellCount = 0L;
    private double minVal = Double.MAX_VALUE;
    private double maxVal = -1.7976931348623157E308;
    private double meanVal = 0.0;
    private double stDevVal = 0.0;
    private boolean isInteger = true;
    private Integer decimalPlaces = 0;
    private final String lineFeed = System.getProperty("line.separator");

    public GridAscii(String ascFullFileName) throws IOException {
        this.ascFullFileName = ascFullFileName;
        this.readHeader();
    }

    public GridAscii(String ascFullFileName, GridAscii gridAscii2) {
        this.ascFullFileName = ascFullFileName;
        this.nCols = gridAscii2.getnCols();
        this.nRows = gridAscii2.getnRows();
        this.xllCorner = gridAscii2.getXllCorner();
        this.yllCorner = gridAscii2.getYllCorner();
        this.cellSize = gridAscii2.getCellSize();
        this.noData = gridAscii2.getNoData();
    }

    public GridAscii(String ascFullFileName, int nCols, int nRows, boolean origCorner, double xllOrig, double yllOrig, double cellSize, double noData) {
        this.ascFullFileName = ascFullFileName;
        this.nCols = nCols;
        this.nRows = nRows;
        this.origCorner = origCorner;
        if (origCorner) {
            this.xllCorner = xllOrig;
            this.yllCorner = yllOrig;
        } else {
            this.xllCorner = xllOrig - 0.5 * cellSize;
            this.yllCorner = yllOrig - 0.5 * cellSize;
        }
        this.cellSize = cellSize;
        this.noData = noData;
    }

    public final void readHeader() throws FileNotFoundException, IOException {
        BufferedReader buffRead = new BufferedReader(new FileReader(this.ascFullFileName));
        String[] header = new String[6];
        for (int l = 0; l < 6; ++l) {
            String line = buffRead.readLine();
            String[] lines = line.split(" +");
            if (lines[0].trim().toLowerCase().equals("ncols")) {
                header[0] = lines[1];
            }
            if (lines[0].trim().toLowerCase().equals("nrows")) {
                header[1] = lines[1];
            }
            if (lines[0].trim().toLowerCase().equals("xllcorner")) {
                header[2] = lines[1];
                this.origCorner = true;
            }
            if (lines[0].trim().toLowerCase().equals("yllcorner")) {
                header[3] = lines[1];
                this.origCorner = true;
            }
            if (lines[0].trim().toLowerCase().equals("xllcenter")) {
                header[2] = lines[1];
                this.origCorner = false;
            }
            if (lines[0].trim().toLowerCase().equals("yllcenter")) {
                header[3] = lines[1];
                this.origCorner = false;
            }
            if (lines[0].trim().toLowerCase().equals("cellsize")) {
                header[4] = lines[1];
            }
            if (!lines[0].trim().toLowerCase().equals("nodata_value")) continue;
            header[5] = lines[1];
        }
        buffRead.close();
        this.nCols = Integer.parseInt(header[0]);
        this.nRows = Integer.parseInt(header[1]);
        this.xllCorner = Double.parseDouble(header[2]);
        this.yllCorner = Double.parseDouble(header[3]);
        this.cellSize = Double.parseDouble(header[4]);
        this.noData = Double.parseDouble(header[5]);
        if (!this.origCorner) {
            this.xllCorner += 0.5 * this.cellSize;
            this.yllCorner += 0.5 * this.cellSize;
        }
    }

    public void readGrid(Rectangle subset) throws FileNotFoundException, IOException {
        String dtmLine;
        this.readHeader();
        double valSum = 0.0;
        double valSumSquare = 0.0;
        this.minVal = Double.MAX_VALUE;
        this.maxVal = -this.minVal;
        BufferedReader buffRead = new BufferedReader(new FileReader(this.ascFullFileName));
        for (int l = 0; l <= 5; ++l) {
            buffRead.readLine();
        }
        int cell = 0;
        this.cellCount = 0L;
        int startCol = 0;
        int endCol = this.nCols;
        if (subset == null) {
            this.dataArray = new float[this.nCols * this.nRows];
        } else {
            this.dataArray = new float[subset.width * subset.height];
            startCol = subset.x;
            endCol = subset.x + subset.width;
        }
        int row = 0;
        while ((dtmLine = buffRead.readLine()) != null) {
            if (subset != null && (row < subset.y || row >= subset.y + subset.height)) {
                ++row;
                continue;
            }
            dtmLine = dtmLine.trim();
            String[] columns = dtmLine.split(" +");
            for (int c = startCol; c < endCol; ++c) {
                this.dataArray[cell] = Float.parseFloat(columns[c]);
                if ((double)this.dataArray[cell] != this.noData) {
                    valSum += (double)this.dataArray[cell];
                    valSumSquare += (double)(this.dataArray[cell] * this.dataArray[cell]);
                    ++this.cellCount;
                    if ((double)this.dataArray[cell] < this.minVal) {
                        this.minVal = this.dataArray[cell];
                    }
                    if ((double)this.dataArray[cell] > this.maxVal) {
                        this.maxVal = this.dataArray[cell];
                    }
                    if ((float)((int)this.dataArray[cell]) != this.dataArray[cell]) {
                        this.isInteger = false;
                    }
                }
                ++cell;
            }
            ++row;
        }
        buffRead.close();
        this.meanVal = valSum / (double)this.cellCount;
        this.stDevVal = Math.sqrt(valSumSquare / (double)this.cellCount - this.meanVal * this.meanVal);
        SampleModel sampleModel = subset == null ? RasterFactory.createBandedSampleModel((int)5, (int)this.nCols, (int)this.nRows, (int)1) : RasterFactory.createBandedSampleModel((int)5, (int)subset.width, (int)subset.height, (int)1);
        DataBufferFloat db = new DataBufferFloat(this.dataArray, this.dataArray.length / 4);
        Point point = new Point();
        point.setLocation(0, 0);
        this.raster = WritableRaster.createWritableRaster(sampleModel, db, point);
    }

    public void writeGrid() throws IOException, Exception {
        FileWriter fileWriter = new FileWriter(new File(this.ascFullFileName));
        BufferedWriter buffw = new BufferedWriter(fileWriter);
        this.writeHeader(buffw);
        DecimalFormat numberFormat = null;
        if (this.decimalPlaces != null && this.decimalPlaces > 0) {
            String pattern = "0.";
            for (int p = 0; p < this.decimalPlaces; ++p) {
                pattern = pattern.concat("0");
            }
            DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(Locale.ENGLISH);
            numberFormat = new DecimalFormat(pattern, decimalFormatSymbols);
        }
        for (int r = 0; r < this.nRows; ++r) {
            StringBuffer sb = new StringBuffer();
            for (int c = 0; c < this.nCols; ++c) {
                if (numberFormat == null) {
                    sb.append(" ").append(this.raster.getSampleFloat(c, r, 0));
                    continue;
                }
                sb.append(" ").append(numberFormat.format(this.raster.getSampleFloat(c, r, 0)));
            }
            buffw.write(sb + this.lineFeed);
        }
        buffw.close();
        fileWriter.close();
    }

    public void writeHeader(BufferedWriter bufferedWriter) throws Exception {
        String line = "ncols " + this.nCols;
        bufferedWriter.write(line + this.lineFeed);
        line = "nrows " + this.nRows;
        bufferedWriter.write(line + this.lineFeed);
        if (this.origCorner) {
            line = "xllcorner " + this.xllCorner;
            bufferedWriter.write(line + this.lineFeed);
            line = "yllcorner " + this.yllCorner;
            bufferedWriter.write(line + this.lineFeed);
        } else {
            line = "xllcenter " + (this.xllCorner + 0.5 * this.cellSize);
            bufferedWriter.write(line + this.lineFeed);
            line = "yllcenter " + (this.yllCorner + 0.5 * this.cellSize);
            bufferedWriter.write(line + this.lineFeed);
        }
        line = "cellsize " + this.cellSize;
        bufferedWriter.write(line + this.lineFeed);
        line = "nodata_value " + this.noData;
        bufferedWriter.write(line + this.lineFeed);
    }

    public void setHeaderEqualTo(GridAscii gridAscii) {
        this.nCols = gridAscii.getnCols();
        this.nRows = gridAscii.getnRows();
        this.xllCorner = gridAscii.getXllCorner();
        this.yllCorner = gridAscii.getYllCorner();
        this.cellSize = gridAscii.getCellSize();
        this.noData = gridAscii.getNoData();
        this.origCorner = gridAscii.origCorner;
    }

    public boolean isSpatiallyEqualTo(GridAscii gridAscii2) {
        boolean isEqual = true;
        if (this.nCols != gridAscii2.getnCols()) {
            isEqual = false;
        }
        if (this.nRows != gridAscii2.getnRows()) {
            isEqual = false;
        }
        if (this.origCorner != gridAscii2.getOrigCorner()) {
            isEqual = false;
        }
        if (this.xllCorner != gridAscii2.getXllCorner()) {
            isEqual = false;
        }
        if (this.yllCorner != gridAscii2.getYllCorner()) {
            isEqual = false;
        }
        if (this.cellSize != gridAscii2.getCellSize()) {
            isEqual = false;
        }
        if (this.noData != gridAscii2.getNoData()) {
            isEqual = false;
        }
        return isEqual;
    }

    public BufferedImage getBufferedImage() throws IOException {
        SampleModel sm = this.raster.getSampleModel();
        ColorModel colorModel = PlanarImage.createColorModel((SampleModel)sm);
        BufferedImage image = new BufferedImage(colorModel, WritableRaster.createWritableRaster(this.raster.getSampleModel(), this.raster.getDataBuffer(), new Point(0, 0)), false, null);
        return image;
    }

    public double readCellValue(int col, int row) throws FileNotFoundException, IOException {
        int r;
        BufferedReader buffRead = new BufferedReader(new FileReader(this.ascFullFileName));
        for (r = 0; r < 6; ++r) {
            buffRead.readLine();
        }
        for (r = 0; r < row; ++r) {
            buffRead.readLine();
        }
        String[] cellVals = buffRead.readLine().trim().split(" +");
        return Double.parseDouble(cellVals[col]);
    }

    public int getnCols() {
        return this.nCols;
    }

    public void setnCols(int nCols) {
        this.nCols = nCols;
    }

    public int getnRows() {
        return this.nRows;
    }

    public void setnRows(int nRows) {
        this.nRows = nRows;
    }

    public double getXllCorner() {
        return this.xllCorner;
    }

    public void setXllCorner(double xllCorner) {
        this.xllCorner = xllCorner;
    }

    public double getYllCorner() {
        return this.yllCorner;
    }

    public void setYllCorner(double yllCorner) {
        this.yllCorner = yllCorner;
    }

    public boolean getOrigCorner() {
        return this.origCorner;
    }

    public void setOrigCorner(boolean origCorner) {
        this.origCorner = origCorner;
    }

    public double getCellSize() {
        return this.cellSize;
    }

    public void setCellSize(double cellSize) {
        this.cellSize = cellSize;
    }

    public double getNoData() {
        return this.noData;
    }

    public void setNoData(double noData) {
        this.noData = noData;
    }

    public Raster getRaster() {
        return this.raster;
    }

    public void setRas(Raster raster) {
        this.raster = raster;
        this.cellCount = 0L;
        DataBuffer db = raster.getDataBuffer();
        for (int e = 0; e < db.getSize(); ++e) {
            if (db.getElemDouble(e) == this.noData) continue;
            ++this.cellCount;
        }
    }

    public double getMinVal() {
        return this.minVal;
    }

    public double getMaxVal() {
        return this.maxVal;
    }

    public double getMeanVal() {
        return this.meanVal;
    }

    public double getStDevVal() {
        return this.stDevVal;
    }

    public long getCellCount() {
        return this.cellCount;
    }

    public boolean isInteger() {
        return this.isInteger;
    }

    public float[] getFloatArray() {
        return this.dataArray;
    }

    public void setDecimalPlaces(Integer decimalPlaces) {
        this.decimalPlaces = decimalPlaces;
    }
}

