/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.graph.delauneySimplexInsert;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

class Simplex
extends AbstractSet
implements Set {
    private List vertices;
    private long idNumber;
    private static long idGenerator = 0L;
    public static boolean moreInfo = false;

    public Simplex(Collection collection) {
        this.vertices = Collections.unmodifiableList(new ArrayList(collection));
        this.idNumber = idGenerator++;
        HashSet noDups = new HashSet(this);
        if (noDups.size() != this.vertices.size()) {
            throw new IllegalArgumentException("Duplicate vertices in Simplex");
        }
    }

    public Simplex(Object[] vertices) {
        this(Arrays.asList(vertices));
    }

    @Override
    public String toString() {
        if (!moreInfo) {
            return "Simplex" + this.idNumber;
        }
        return "Simplex" + this.idNumber + super.toString();
    }

    public int dimension() {
        return this.vertices.size() - 1;
    }

    public boolean isNeighbor(Simplex simplex) {
        HashSet h = new HashSet(this);
        h.removeAll(simplex);
        return this.size() == simplex.size() && h.size() == 1;
    }

    public List facets() {
        LinkedList theFacets = new LinkedList();
        for (Object v : this) {
            HashSet facet = new HashSet(this);
            facet.remove(v);
            theFacets.add(facet);
        }
        return theFacets;
    }

    public static Set boundary(Set simplexSet) {
        HashSet<Set> theBoundary = new HashSet<Set>();
        for (Simplex simplex : simplexSet) {
            for (Set facet : simplex.facets()) {
                if (theBoundary.contains(facet)) {
                    theBoundary.remove(facet);
                    continue;
                }
                theBoundary.add(facet);
            }
        }
        return theBoundary;
    }

    @Override
    public Iterator iterator() {
        return this.vertices.iterator();
    }

    @Override
    public int size() {
        return this.vertices.size();
    }

    @Override
    public int hashCode() {
        return (int)(this.idNumber ^ this.idNumber >>> 32);
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }
}

