/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.geomutils.algorithm;

import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.IntersectionMatrix;
import org.locationtech.jts.geom.Polygon;

public class PolygonMerge {
    private boolean polys = false;
    private int mergeSuccesfull = 0;
    private Geometry outPolygon = null;

    public PolygonMerge(Geometry poly1, Geometry poly2) {
        if (poly1 instanceof Polygon && poly2 instanceof Polygon) {
            this.polys = true;
            IntersectionMatrix myIM = poly1.relate(poly2);
            if (myIM.matches("2********") || myIM.matches("****1****")) {
                Geometry geom;
                this.outPolygon = geom = poly1.union(poly2);
                this.mergeSuccesfull = geom instanceof Polygon ? 1 : 2;
            }
        }
    }

    public int isMergeSuccesfull() {
        return this.mergeSuccesfull;
    }

    public Geometry getOutPolygon() {
        return this.outPolygon;
    }

    public boolean isPolys() {
        return this.polys;
    }
}

