/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.geomutils.algorithm;

import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import java.util.ArrayList;
import java.util.Collection;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.openjump.core.geomutils.algorithm.GeometryConverter;

public class IntersectGeometries {
    /*
     * WARNING - void declaration
     */
    public static ArrayList<Geometry> intersectPolygons(ArrayList<Geometry> geomList, double accuracy, TaskMonitor monitor, PlugInContext context) {
        ArrayList<Geometry> withoutIntersection = new ArrayList<Geometry>();
        ArrayList<Geometry> tempList = new ArrayList<Geometry>();
        for (int i = 0; i < geomList.size(); ++i) {
            Geometry geom = (Geometry)geomList.get(i);
            if (geom instanceof GeometryCollection) {
                ArrayList<Geometry> parts = GeometryConverter.explodeGeomsIfMultiG(geom);
                tempList.addAll(parts);
                continue;
            }
            tempList.add(geom);
        }
        geomList = tempList;
        PrecisionModel pm = new PrecisionModel(PrecisionModel.FIXED);
        GeometryFactory gf = new GeometryFactory(pm);
        tempList = new ArrayList();
        for (Geometry geometry : geomList) {
            Geometry geomNew = IntersectGeometries.createGeometryWithFixedPrecision(gf, geometry);
            if (geomNew == null) continue;
            tempList.add(geomNew);
        }
        geomList = tempList;
        int totalCount = 0;
        while (geomList.size() > 1) {
            void var10_14;
            Geometry geometry = (Geometry)geomList.get(0);
            if (monitor != null) {
                if (monitor.isCancelRequested()) {
                    return withoutIntersection;
                }
                monitor.report("n: " + geomList.size());
            }
            while (var10_14 instanceof GeometryCollection) {
                ArrayList<Geometry> parts = GeometryConverter.explodeGeomsIfMultiG((Geometry)var10_14);
                geomList.addAll(parts);
                geomList.remove(0);
                Geometry geometry2 = (Geometry)geomList.get(0);
            }
            boolean checkNext = true;
            int count = 0;
            while (checkNext) {
                Geometry gtemp;
                boolean checkRes;
                ++totalCount;
                if (checkRes = IntersectGeometries.checkPolygonIntersection((Geometry)var10_14, gtemp = (Geometry)geomList.get(++count))) {
                    checkNext = false;
                    Geometry gnewI = null;
                    Geometry gnewNi = null;
                    gnewI = var10_14.intersection(gtemp);
                    gnewNi = var10_14.symDifference(gtemp);
                    ArrayList<Geometry> intersection = GeometryConverter.explodeGeomsIfMultiG(gnewI);
                    ArrayList<Geometry> nonIntersection = GeometryConverter.explodeGeomsIfMultiG(gnewNi);
                    geomList.remove(count);
                    geomList.remove(0);
                    geomList.addAll(intersection);
                    geomList.addAll(nonIntersection);
                }
                if (count + 1 != geomList.size() || !checkNext) continue;
                withoutIntersection.add((Geometry)var10_14.clone());
                geomList.remove(0);
                checkNext = false;
            }
        }
        withoutIntersection.add((Geometry)geomList.get(0));
        return withoutIntersection;
    }

    private static Geometry createGeometryWithFixedPrecision(GeometryFactory gf, Geometry geomOld) {
        if (geomOld instanceof Polygon) {
            Polygon po = (Polygon)geomOld;
            LinearRing shell = gf.createLinearRing(po.getExteriorRing().getCoordinates());
            LinearRing[] holes = null;
            if (po.getNumInteriorRing() > 0) {
                holes = new LinearRing[po.getNumInteriorRing()];
                for (int i = 0; i < po.getNumInteriorRing(); ++i) {
                    holes[i] = gf.createLinearRing(po.getInteriorRingN(i).getCoordinates());
                }
            }
            return gf.createPolygon(shell, holes);
        }
        if (geomOld instanceof Point) {
            return gf.createPoint(((Point)geomOld).getCoordinate());
        }
        if (geomOld instanceof LineString) {
            return gf.createLineString(((LineString)geomOld).getCoordinates());
        }
        return null;
    }

    public static boolean checkIntersectionByGeomTypeB(Geometry g1, Geometry g2) {
        if (g1 instanceof Polygon) {
            Geometry intersection = g1.intersection(g2);
            if (g2 instanceof Polygon) {
                Geometry diff = g1.difference(g2);
                return intersection.getArea() > 0.0;
            }
            if (g2 instanceof LineString) {
                Geometry diff = g1.difference(g2);
                if (diff instanceof GeometryCollection) {
                    return ((GeometryCollection)diff).getNumGeometries() > 1;
                }
                return false;
            }
            return g1.intersects(g2);
        }
        if (g1 instanceof LineString) {
            if (g2 instanceof Polygon) {
                Geometry diff = g2.difference(g1);
                if (diff instanceof GeometryCollection) {
                    return ((GeometryCollection)diff).getNumGeometries() > 1;
                }
                return false;
            }
            if (g2 instanceof LineString) {
                Geometry diff = g1.difference(g2);
                if (diff instanceof GeometryCollection) {
                    return ((GeometryCollection)diff).getNumGeometries() > 1;
                }
                return false;
            }
            if (g2 instanceof Point) {
                Geometry diff = g1.difference(g2);
                if (diff instanceof GeometryCollection) {
                    return ((GeometryCollection)diff).getNumGeometries() > 1;
                }
                return false;
            }
            return g1.intersects(g2);
        }
        if (g1 instanceof Point) {
            if (g2 instanceof LineString) {
                Geometry diff = g2.difference(g2);
                return ((GeometryCollection)diff).getNumGeometries() > 1;
            }
            return false;
        }
        return g1.intersects(g2);
    }

    public static boolean checkPolygonIntersection(Geometry g1, Geometry g2) {
        if (g1 instanceof Polygon) {
            Geometry intersection = g1.intersection(g2);
            if (g2 instanceof Polygon) {
                Geometry diff = g1.difference(g2);
                return intersection.getArea() > 0.0;
            }
            return false;
        }
        return false;
    }

    public static Collection nodeLines(Collection lines) {
        GeometryFactory fact = new GeometryFactory();
        MultiLineString linesGeom = fact.createMultiLineString(GeometryFactory.toLineStringArray((Collection)lines));
        MultiLineString unionInput = fact.createMultiLineString(null);
        Geometry point = IntersectGeometries.extractPoint(lines);
        if (point != null) {
            unionInput = point;
        }
        Geometry noded = linesGeom.union((Geometry)unionInput);
        ArrayList<Geometry> nodedList = new ArrayList<Geometry>();
        nodedList.add(noded);
        return nodedList;
    }

    private static Geometry extractPoint(Collection lines) {
        int minPts = Integer.MAX_VALUE;
        Point point = null;
        for (Geometry g : lines) {
            if (g.isEmpty()) continue;
            Coordinate p = g.getCoordinate();
            point = g.getFactory().createPoint(p);
        }
        return point;
    }
}

