/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.geomutils;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.openjump.core.geomutils.GeoUtils;

public class Arc {
    protected Coordinate center = new Coordinate(0.0, 0.0);
    protected Coordinate start = new Coordinate(0.0, 0.0);
    protected double radius = 0.0;
    protected double angle = 0.0;
    protected double arcTolerance = 0.1;

    public Arc(Coordinate center, Coordinate start, double angle) {
        this.center = center;
        this.start = start;
        this.angle = angle;
        this.radius = Math.sqrt(center.distance(start) * center.distance(start));
    }

    public void setArcTolerance(double arcTolerance) {
        this.arcTolerance = arcTolerance;
    }

    public Polygon getPoly() {
        if (this.angle == 360.0) {
            CoordinateList polyCoords = this.arcAnglePts(this.angle, this.start, this.center);
            return new GeometryFactory().createPolygon(new GeometryFactory().createLinearRing(polyCoords.toCoordinateArray()), null);
        }
        CoordinateList polyCoords = new CoordinateList();
        polyCoords.add((Object)this.center);
        polyCoords.add((Object)this.start);
        CoordinateList coordinates = this.arcAnglePts(this.angle, this.start, this.center);
        polyCoords.add(coordinates.toCoordinateArray(), true);
        polyCoords.add((Object)this.center);
        return new GeometryFactory().createPolygon(new GeometryFactory().createLinearRing(polyCoords.toCoordinateArray()), null);
    }

    public LineString getLineString() {
        CoordinateList coordinates = this.arcAnglePts(this.angle, this.start, this.center);
        return new GeometryFactory().createLineString(coordinates.toCoordinateArray());
    }

    public Point getLastPointArc() {
        if (this.angle == 360.0) {
            return new GeometryFactory().createPoint(new Coordinate(GeoUtils.rotPt(this.start, this.center, this.angle)));
        }
        CoordinateList polyCoords = new CoordinateList();
        CoordinateList coordinates = this.arcAnglePts(this.angle, this.start, this.center);
        polyCoords.add(coordinates.toCoordinateArray(), true);
        polyCoords.add((Object)new Coordinate(GeoUtils.rotPt(this.start, this.center, this.angle)));
        return new GeometryFactory().createPoint(new Coordinate(GeoUtils.rotPt(this.start, this.center, this.angle)));
    }

    public Point getMiddlePointArc() {
        if (this.angle == 360.0) {
            double anglem = this.angle / 2.0;
            return new GeometryFactory().createPoint(new Coordinate(GeoUtils.rotPt(this.start, this.center, anglem)));
        }
        double anglem = this.angle / 2.0;
        CoordinateList polyCoords = new CoordinateList();
        CoordinateList coordinates = this.arcAnglePts(anglem, this.start, this.center);
        polyCoords.add(coordinates.toCoordinateArray(), true);
        polyCoords.add((Object)new Coordinate(GeoUtils.rotPt(this.start, this.center, anglem)));
        return new GeometryFactory().createPoint(new Coordinate(GeoUtils.rotPt(this.start, this.center, anglem)));
    }

    public CoordinateList getCoordinates() {
        return this.arcAnglePts(this.angle, this.start, this.center);
    }

    protected CoordinateList arcAnglePts(double angle, Coordinate pt, Coordinate center) {
        CoordinateList coordinates = new CoordinateList();
        int n = this.getPtsFromTolerance(center.distance(pt), angle, this.arcTolerance);
        if (n < 3) {
            n = 3;
        }
        double ai = angle / (double)n;
        coordinates.add((Object)new Coordinate(pt));
        for (int i = 1; i < n; ++i) {
            Coordinate p2 = GeoUtils.rotPt(pt, center, ai * (double)i);
            coordinates.add((Object)new Coordinate(p2));
        }
        if (angle == 360.0) {
            coordinates.add((Object)new Coordinate(pt));
        } else {
            coordinates.add((Object)new Coordinate(GeoUtils.rotPt(pt, center, angle)));
        }
        return coordinates;
    }

    protected int getPtsFromTolerance(double radius, double angle, double tolerance) {
        double theta;
        double epsilon = 1.0E-5;
        int n = radius < 1.0E-5 ? 1 : (tolerance / radius > 0.333 ? 1 : ((theta = Math.toDegrees(2.0 * Math.acos((radius - tolerance) / radius))) < 1.0E-5 ? 0 : (int)Math.floor(Math.abs(angle) / theta) + 1));
        return n;
    }
}

