/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ccordsys.utils;

import org.openjump.core.ccordsys.Unit;
import org.openjump.core.ccordsys.utils.SridLookupTable;

public class SRSInfo {
    public static final String UNDEFINED = "0";
    public static final String USERDEFINED = "USER-DEFINED";
    private String source = "";
    private Registry registry = Registry.EPSG;
    private String code = "0";
    private String description = "";
    private Unit unit = Unit.UNKNOWN;

    public String getSource() {
        return this.source;
    }

    public SRSInfo setSource(String source) {
        this.source = source;
        return this;
    }

    public Registry getRegistry() {
        if (this.code == null && this.description == null) {
            throw new IllegalStateException("SRSInfo must have a code or a description");
        }
        if (this.registry != null) {
            return this.registry;
        }
        return SRSInfo.guessRegistry(this.getCode());
    }

    public SRSInfo setRegistry(Registry registry) {
        this.registry = registry;
        return this;
    }

    public SRSInfo setRegistry(String registry) {
        this.registry = Registry.valueOf(registry);
        return this;
    }

    public String getCode() {
        if (this.code == null && this.description == null) {
            throw new IllegalStateException("SRSInfo must have a code or a description");
        }
        return this.code;
    }

    public SRSInfo setCode(String code) {
        this.code = code;
        return this;
    }

    public String getDescription() {
        if (this.code == null && this.description == null) {
            throw new IllegalStateException("SRSInfo must have a code or a description");
        }
        return this.description;
    }

    public SRSInfo setDescription(String description) {
        this.description = description;
        return this;
    }

    public Unit getUnit() {
        if (this.code == null && this.description == null) {
            throw new IllegalStateException("SRSInfo must have a code or a description");
        }
        return this.unit;
    }

    public SRSInfo setUnit(Unit unit) {
        this.unit = unit;
        return this;
    }

    public SRSInfo setUnit(String unit) {
        this.unit = Unit.valueOf(unit);
        return this;
    }

    public SRSInfo complete() {
        SRSInfo sridTableInfo = SridLookupTable.getSrsAndUnitFromCode(this.code);
        if (sridTableInfo.getCode().equals(UNDEFINED)) {
            sridTableInfo = SridLookupTable.getSrsAndUnitFromName(this.description);
        }
        if (!sridTableInfo.getCode().equals(UNDEFINED)) {
            this.code = sridTableInfo.getCode();
            this.description = sridTableInfo.getDescription();
            this.unit = sridTableInfo.getUnit();
        }
        this.registry = SRSInfo.guessRegistry(this.code);
        return this;
    }

    public String toString() {
        return this.getRegistry().toString() + ':' + this.getCode() + ' ' + this.getDescription() + " [" + (Object)((Object)this.getUnit()) + ']';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SRSInfo srsInfo = (SRSInfo)o;
        if (this.registry != null ? !this.registry.equals((Object)srsInfo.registry) : srsInfo.registry != null) {
            return false;
        }
        if (this.code != null ? !this.code.equals(srsInfo.code) : srsInfo.code != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(srsInfo.description) : srsInfo.description != null) {
            return false;
        }
        return this.unit != null ? this.unit.equals((Object)srsInfo.unit) : srsInfo.unit == null;
    }

    public int hashCode() {
        int result = this.registry != null ? this.registry.hashCode() : 0;
        result = 31 * result + (this.code != null ? this.code.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.unit != null ? this.unit.hashCode() : 0);
        return result;
    }

    private static Registry guessRegistry(String code) {
        Registry registry = Registry.SRID;
        if (code != null && code.matches("\\d+")) {
            int srid = Integer.parseInt(code);
            if (srid < 32768 || srid > 5999999) {
                registry = Registry.EPSG;
            } else if (srid > 32999 && srid < 200000) {
                registry = Registry.ESRI;
            }
        }
        return registry;
    }

    public static enum Registry {
        SRID,
        EPSG,
        ESRI,
        IGNF,
        SRORG,
        LOCAL_CoordinateReferenceSystem;

    }
}

