/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.attributeoperations.statistics;

import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureSchema;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.openjump.core.apitools.FeatureCollectionTools;
import org.openjump.core.apitools.comparisonandsorting.ObjectComparator;
import org.openjump.core.attributeoperations.statistics.CorrelationDataPair;

public class CorrelationCoefficients {
    protected Object[] dataArray = null;
    protected String attrName1 = null;
    protected String attrName2 = null;
    protected double[] means = new double[2];
    protected Feature[] rawFeatures = null;

    public CorrelationCoefficients(Feature[] features, String attr1, String attr2) {
        this.attrName1 = attr1;
        this.attrName2 = attr2;
        this.rawFeatures = features;
        this.dataArray = this.initializeDataStorage(features);
    }

    protected CorrelationDataPair[] initializeDataStorage(Feature[] features) {
        ArrayList<CorrelationDataPair> points = new ArrayList<CorrelationDataPair>();
        Feature feature = features[0];
        FeatureSchema fs = feature.getSchema();
        int attrIndX = fs.getAttributeIndex(this.attrName1);
        int attrIndY = fs.getAttributeIndex(this.attrName2);
        this.means[0] = this.aritmeticMiddle(features, attrIndX);
        this.means[1] = this.aritmeticMiddle(features, attrIndY);
        for (int i = 0; i < features.length; ++i) {
            feature = features[i];
            double x = ObjectComparator.getDoubleValue(feature.getAttribute(attrIndX));
            double y = ObjectComparator.getDoubleValue(feature.getAttribute(attrIndY));
            points.add(new CorrelationDataPair(new double[]{x, y}, i));
        }
        return points.toArray(new CorrelationDataPair[0]);
    }

    public static double getDeviation(Feature[] features, String attr, double mean) {
        Feature feat = features[0];
        int attrIndex = feat.getSchema().getAttributeIndex(attr);
        if (!FeatureCollectionTools.isAttributeTypeNumeric(feat.getSchema().getAttributeType(attrIndex))) {
            throw new IllegalArgumentException("attribute is not numeric!");
        }
        double squareSum = 0.0;
        for (int i = 0; i < features.length; ++i) {
            feat = features[i];
            if (feat.getAttribute(attrIndex) == null) continue;
            squareSum += Math.pow(ObjectComparator.getDoubleValue(feat.getAttribute(attrIndex)) - mean, 2.0);
        }
        return Math.sqrt(1.0 / (double)(features.length - 1) * squareSum);
    }

    protected double getVariance(String attr) {
        return 0.0;
    }

    protected double aritmeticMiddle(Feature[] features, int attr) {
        return FeatureCollectionTools.getAritmeticMiddleForAttribute(features, attr);
    }

    public double getMean(int nr) {
        return this.means[nr];
    }

    public CorrelationInformation getPearsonCoefficient() {
        double coefficient = 0.0;
        double sumErrorProducts = 0.0;
        double sumXErrorSquares = 0.0;
        double sumYErrorSquares = 0.0;
        for (int i = 0; i < this.dataArray.length; ++i) {
            double y;
            double x;
            CorrelationDataPair pkt = (CorrelationDataPair)this.dataArray[i];
            try {
                x = pkt.getX();
                y = pkt.getY();
            }
            catch (Exception e) {
                continue;
            }
            double errorX = x - this.means[0];
            double errorY = y - this.means[1];
            sumErrorProducts += errorX * errorY;
            sumXErrorSquares += errorX * errorX;
            sumYErrorSquares += errorY * errorY;
        }
        coefficient = sumErrorProducts / (Math.sqrt(sumXErrorSquares) * Math.sqrt(sumYErrorSquares));
        return new CorrelationInformation(coefficient);
    }

    protected HashMap<Integer, Double> getRank2SpearmanRankMap(Object[] sortedValues, HashMap<Object, Integer> value2NumAppearances) {
        HashMap<Integer, Double> rank2SpearmanRank = new HashMap<Integer, Double>();
        int sumOfRanks = 0;
        for (int i = 0; i < sortedValues.length; ++i) {
            int numAppearances = value2NumAppearances.get(sortedValues[i]);
            double meanSum = 0.0;
            for (int sr = 0; sr < numAppearances; ++sr) {
                meanSum += (double)(sr + sumOfRanks + 1);
            }
            rank2SpearmanRank.put(i, meanSum / (double)numAppearances);
            sumOfRanks += numAppearances;
        }
        return rank2SpearmanRank;
    }

    public RankCorrelationInformation getSpearmansRhoCoefficient() {
        double coefficient = 0.0;
        FeatureSchema fs = this.rawFeatures[0].getSchema();
        int attributeIndex1 = fs.getAttributeIndex(this.attrName1);
        int attributeIndex2 = fs.getAttributeIndex(this.attrName2);
        ArrayList<Object> valuesA = Collections.list(Collections.enumeration(FeatureCollectionTools.getSetOfDifferentAttributeValues(this.rawFeatures, attributeIndex1)));
        ArrayList<Object> valuesB = Collections.list(Collections.enumeration(FeatureCollectionTools.getSetOfDifferentAttributeValues(this.rawFeatures, attributeIndex2)));
        Collections.sort(valuesA);
        Collections.sort(valuesB);
        Object[] valuesArrayA = valuesA.toArray();
        Object[] valuesArrayB = valuesB.toArray();
        HashMap<Object, Integer> value2NumAppearances1 = null;
        HashMap<Object, Integer> value2NumAppearances2 = null;
        HashMap<Object, Integer>[] maps = FeatureCollectionTools.getValueAppearancesCount(this.rawFeatures, new int[]{attributeIndex1, attributeIndex2});
        value2NumAppearances1 = maps[0];
        value2NumAppearances2 = maps[1];
        HashMap<Object, Object> rank2SpearmanRankA = new HashMap();
        HashMap<Object, Object> rank2SpearmanRankB = new HashMap();
        rank2SpearmanRankA = this.getRank2SpearmanRankMap(valuesArrayA, value2NumAppearances1);
        rank2SpearmanRankB = this.getRank2SpearmanRankMap(valuesArrayB, value2NumAppearances2);
        SpearmanRankNumberPair[] spearmanPairs = new SpearmanRankNumberPair[this.rawFeatures.length];
        for (int i = 0; i < this.rawFeatures.length; ++i) {
            int rankA = valuesA.indexOf(this.rawFeatures[i].getAttribute(attributeIndex1));
            int rankB = valuesB.indexOf(this.rawFeatures[i].getAttribute(attributeIndex2));
            spearmanPairs[i] = new SpearmanRankNumberPair((Double)rank2SpearmanRankA.get(rankA), (Double)rank2SpearmanRankB.get(rankB));
        }
        double sumOfSpearmanDifferences = 0.0;
        int numCon = 0;
        int numDis = 0;
        int numPairs = spearmanPairs.length;
        for (int i = 0; i < numPairs; ++i) {
            double difference = spearmanPairs[i].getDifference();
            sumOfSpearmanDifferences += Math.pow(difference, 2.0);
            if (difference > 0.0) {
                ++numCon;
                continue;
            }
            if (!(difference < 0.0)) continue;
            ++numDis;
        }
        return new RankCorrelationInformation(1.0 - 6.0 * sumOfSpearmanDifferences / (Math.pow(numPairs, 3.0) - (double)numPairs), numCon, numDis);
    }

    public RankCorrelationInformation getKendalsTauRankCoefficient() {
        int numConcordant = 0;
        int numDiscordant = 0;
        int numTiesX = 0;
        int numTiesY = 0;
        int numVergleiche = 0;
        for (int i = 0; i < this.dataArray.length; ++i) {
            double currY;
            double currX;
            CorrelationDataPair currentPair = (CorrelationDataPair)this.dataArray[i];
            try {
                currX = currentPair.getCoordinate(0);
                currY = currentPair.getCoordinate(1);
            }
            catch (Exception e1) {
                continue;
            }
            int j = i + 1;
            while (j < this.dataArray.length) {
                block15: {
                    double refY;
                    double refX;
                    CorrelationDataPair referncePair = (CorrelationDataPair)this.dataArray[j];
                    try {
                        refX = referncePair.getCoordinate(0);
                        refY = referncePair.getCoordinate(1);
                    }
                    catch (Exception e2) {
                        break block15;
                    }
                    if (currX < refX && currY < refY || currX > refX && currY > refY) {
                        ++numConcordant;
                    } else if (currX < refX && currY > refY || currX > refX && currY < refY) {
                        ++numDiscordant;
                    }
                    try {
                        if (currX == refX) {
                            ++numTiesX;
                        }
                        if (currY == refY) {
                            ++numTiesY;
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
                ++j;
                ++numVergleiche;
            }
        }
        if (numTiesX > 0) {
            // empty if block
        }
        if (numTiesY > 0) {
            // empty if block
        }
        double kendallsTau_alpha = (double)(numConcordant - numDiscordant) / (double)numVergleiche;
        double kendallsTau_beta = (double)(numConcordant - numDiscordant) / Math.sqrt((double)(numConcordant + numDiscordant + numTiesX) * (double)(numConcordant + numDiscordant + numTiesY));
        return new RankCorrelationInformation(kendallsTau_alpha, kendallsTau_beta, numConcordant, numDiscordant);
    }

    public class RankCorrelationInformation
    extends CorrelationInformation {
        double secondCoefficient;
        int numberOfConcordantPairs;
        int numberOfDiscordantPairs;

        public RankCorrelationInformation(double coefficient, double secondCoefficient, int numberOfConcordantPairs, int numberOfDiscordantPairs) {
            super(coefficient);
            this.secondCoefficient = Double.NaN;
            this.secondCoefficient = secondCoefficient;
            this.numberOfConcordantPairs = numberOfConcordantPairs;
            this.numberOfDiscordantPairs = numberOfDiscordantPairs;
        }

        public RankCorrelationInformation(double coefficient, int numberOfConcordantPairs, int numberOfDiscordantPairs) {
            super(coefficient);
            this.secondCoefficient = Double.NaN;
            this.numberOfConcordantPairs = numberOfConcordantPairs;
            this.numberOfDiscordantPairs = numberOfDiscordantPairs;
        }

        public int getNumberOfConcordantPairs() {
            return this.numberOfConcordantPairs;
        }

        public int getNumberOfDiscordantPairs() {
            return this.numberOfDiscordantPairs;
        }

        public double getSecondCoefficient() {
            return this.secondCoefficient;
        }
    }

    public class CorrelationInformation {
        protected double coefficient = 0.0;

        public CorrelationInformation(double coefficient) {
            this.coefficient = coefficient;
        }

        public double getCoefficient() {
            return this.coefficient;
        }
    }

    protected class SpearmanRankNumberPair {
        protected double a;
        protected double b;

        public SpearmanRankNumberPair(double a, double b) {
            this.a = a;
            this.b = b;
        }

        public double getDifference() {
            return this.a - this.b;
        }

        public double getA() {
            return this.a;
        }

        public double getB() {
            return this.b;
        }
    }
}

