/*
 * Decompiled with CFR 0.152.
 */
package it.betastudio.adbtoolbox.libs;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import javax.swing.JOptionPane;

public class DxfExport {
    private String dxfOut = null;
    private final String lineFeed = System.getProperty("line.separator");

    public DxfExport() {
        this.dxfOut = new String();
    }

    public void writeHeader(double minX, double minY, double maxX, double maxY) {
        this.dxfOut = "0";
        this.appString("SECTION");
        this.appString(2);
        this.appString("HEADER");
        this.appString(9);
        this.appString("$ACADVER");
        this.appString(1);
        this.appString("AC1009");
        this.appString(9);
        this.appString("$EXTMIN");
        this.appString(10);
        this.appString(minX);
        this.appString(20);
        this.appString(minY);
        this.appString(30);
        this.appString(0);
        this.appString(9);
        this.appString("$EXTMAX");
        this.appString(10);
        this.appString(maxX);
        this.appString(20);
        this.appString(maxY);
        this.appString(30);
        this.appString(0);
        this.appString(9);
        this.appString("$LIMMIN");
        this.appString(10);
        this.appString(minX);
        this.appString(20);
        this.appString(minY);
        this.appString(9);
        this.appString("$LIMMAX");
        this.appString(10);
        this.appString(maxX);
        this.appString(20);
        this.appString(maxY);
        this.appString(0);
        this.appString("ENDSEC");
    }

    public void writeStartSec() {
        this.appString(0);
        this.appString("SECTION");
    }

    public void writeEndSec() {
        this.appString(0);
        this.appString("ENDSEC");
    }

    public void writeTablesStart() {
        this.appString(2);
        this.appString("TABLES");
    }

    public void writeTableStart() {
        this.appString(0);
        this.appString("TABLE");
    }

    public void writeTableEnd() {
        this.appString(0);
        this.appString("ENDTAB");
    }

    public void writeLayersStart() {
        this.appString(2);
        this.appString("LAYER");
        this.appString(70);
        this.appString(1);
    }

    public void writeLayer(String layName, int colourNr) {
        this.appString(0);
        this.appString("LAYER");
        this.appString(2);
        this.appString(layName);
        this.appString(62);
        this.appString(colourNr);
        this.appString(70);
        this.appString(0);
        this.appString(6);
        this.appString("CONTINUOUS");
    }

    public void writeVPort(double centerX, double centerY, double minX, double minY, double maxX, double maxY) {
        this.appString(2);
        this.appString("VPORT");
        this.appString(5);
        this.appString(8);
        this.appString(100);
        this.appString("AcDbSymbolTable");
        this.appString(70);
        this.appString(2);
        this.appString(0);
        this.appString("VPORT");
        this.appString(5);
        this.appString("4A");
        this.appString(100);
        this.appString("AcDbSymbolTableRecord");
        this.appString(100);
        this.appString("AcDbViewportTableRecord");
        this.appString(2);
        this.appString("*Active");
        this.appString(70);
        this.appString(0);
        this.appString(10);
        this.appString(minX);
        this.appString(20);
        this.appString(minY);
        this.appString(11);
        this.appString(maxX);
        this.appString(21);
        this.appString(maxY);
        this.appString(12);
        this.appString(centerX);
        this.appString(22);
        this.appString(centerY);
        this.appString(13);
        this.appString(0.0);
        this.appString(23);
        this.appString(0.0);
        this.appString(14);
        this.appString(10.0);
        this.appString(24);
        this.appString(10.0);
        this.appString(15);
        this.appString(10.0);
        this.appString(25);
        this.appString(10.0);
        this.appString(16);
        this.appString(0.0);
        this.appString(26);
        this.appString(0.0);
        this.appString(36);
        this.appString(1.0);
        this.appString(17);
        this.appString(0.0);
        this.appString(27);
        this.appString(0.0);
        this.appString(37);
        this.appString(0.0);
        this.appString(40);
        this.appString(1009.022556390977);
        this.appString(41);
        this.appString(1.783132530120481);
        this.appString(42);
        this.appString(50.0);
        this.appString(43);
        this.appString(0.0);
        this.appString(44);
        this.appString(0.0);
        this.appString(50);
        this.appString(0.0);
        this.appString(51);
        this.appString(0.0);
        this.appString(71);
        this.appString(0);
        this.appString(72);
        this.appString(100);
        this.appString(73);
        this.appString(1);
        this.appString(74);
        this.appString(3);
        this.appString(75);
        this.appString(0);
        this.appString(76);
        this.appString(0);
        this.appString(77);
        this.appString(0);
        this.appString(78);
        this.appString(0);
    }

    public void writeEntStart() {
        this.appString(2);
        this.appString("ENTITIES");
    }

    public void writeAppId() {
        this.appString(2);
        this.appString("APPID");
        this.appString(5);
        this.appString(9);
        this.appString(100);
        this.appString("AcDbSymbolTable");
        this.appString(70);
        this.appString(1);
        this.appString(0);
        this.appString("APPID");
        this.appString(5);
        this.appString(12);
        this.appString(100);
        this.appString("AcDbSymbolTableRecord");
        this.appString(100);
        this.appString("AcDbRegAppTableRecord");
        this.appString(2);
        this.appString("ACAD");
        this.appString(70);
        this.appString(0);
    }

    public void writeEnding() {
        this.appString(0);
        this.appString("ENDSEC");
        this.appString(0);
        this.appString("EOF");
    }

    public void writeLine(String layName, double p1x, double p1y, double p2x, double p2y) {
        this.appString("0");
        this.appString("LINE");
        this.appString(8);
        this.appString(layName);
        this.appString("10");
        this.appString(p1x);
        this.appString("20");
        this.appString(p1y);
        this.appString("11");
        this.appString(p2x);
        this.appString("21");
        this.appString(p2y);
    }

    public void writeLineType(String layerName, String lineType, double p1x, double p1y, double p2x, double p2y) {
        this.appString("0");
        this.appString("LINE");
        this.appString(8);
        this.appString(layerName);
        this.appString(6);
        this.appString(lineType);
        this.appString("10");
        this.appString(p1x);
        this.appString("20");
        this.appString(p1y);
        this.appString("11");
        this.appString(p2x);
        this.appString("21");
        this.appString(p2y);
    }

    public void writePolyline(String layName, double[][] vertices) {
        this.appString(0);
        this.appString("POLYLINE");
        this.appString(8);
        this.appString(layName);
        this.appString(62);
        this.appString(5);
        this.appString(66);
        this.appString(1);
        for (double[] vertice : vertices) {
            this.appString(0);
            this.appString("VERTEX");
            this.appString(8);
            this.appString(layName);
            this.appString(10);
            this.appString(vertice[0]);
            this.appString(20);
            this.appString(vertice[1]);
            this.appString(70);
            this.appString(4);
        }
        this.appString("0");
        this.appString("SEQEND");
    }

    public void writePolyline(String layName, String lineType, double[][] vertices, int colourNr) {
        this.appString(0);
        this.appString("POLYLINE");
        this.appString(8);
        this.appString(layName);
        this.appString(lineType);
        this.appString(62);
        this.appString(colourNr);
        this.appString(66);
        this.appString(1);
        for (double[] vertice : vertices) {
            this.appString(0);
            this.appString("VERTEX");
            this.appString(8);
            this.appString(layName);
            this.appString(10);
            this.appString(vertice[0]);
            this.appString(20);
            this.appString(vertice[1]);
            this.appString(70);
            this.appString(4);
        }
        this.appString("0");
        this.appString("SEQEND");
    }

    public void writeLwPolyLine(double[][] vertices) {
    }

    public void writeText(String layName, double alignPoint1x, double alignPoint1y, double alignPoint1z, double alignPoint2x, double alignPoint2y, double alignPoint2z, int textHight, double textRotation, int horizJust, int vertAlign, String text) {
        this.appString(0);
        this.appString("TEXT");
        this.appString(8);
        this.appString(layName);
        this.appString(10);
        this.appString(alignPoint1x);
        this.appString(20);
        this.appString(alignPoint1y);
        this.appString(30);
        this.appString(alignPoint1z);
        this.appString(40);
        this.appString(textHight);
        this.appString(50);
        this.appString(textRotation);
        this.appString(1);
        this.appString(text);
        if (horizJust != 0 || vertAlign != 0) {
            this.appString(11);
            this.appString(alignPoint2x);
            this.appString(21);
            this.appString(alignPoint2y);
            this.appString(31);
            this.appString(alignPoint2z);
            this.appString(72);
            this.appString(horizJust);
            this.appString(73);
            this.appString(vertAlign);
        }
    }

    private void appString(String appEnd) {
        this.dxfOut = this.dxfOut + this.lineFeed + appEnd;
    }

    private void appString(int appEnd) {
        this.dxfOut = this.dxfOut + this.lineFeed + appEnd;
    }

    private void appString(double appEnd) {
        this.dxfOut = this.dxfOut + this.lineFeed + appEnd;
    }

    public int exportDxf(String dxfFullFileName) {
        try {
            BufferedWriter buffWrite = new BufferedWriter(new FileWriter(new File(dxfFullFileName)));
            buffWrite.write(this.dxfOut, 0, this.dxfOut.length());
            buffWrite.close();
            return 0;
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Errore durante la scrittura del DXF: " + ex, "Errore", 0);
            return 1;
        }
    }
}

