/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.wms;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.wms.AbstractParser;
import com.vividsolutions.wms.AxisOrder;
import com.vividsolutions.wms.BoundingBox;
import com.vividsolutions.wms.Capabilities;
import com.vividsolutions.wms.MapLayer;
import com.vividsolutions.wms.WMService;
import com.vividsolutions.wms.util.XMLTools;
import java.io.IOException;
import java.util.LinkedList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ParserWMS1_3
extends AbstractParser {
    @Override
    protected String getRootPath() {
        return "WMS_Capabilities";
    }

    @Override
    protected Capabilities parseCapabilities(WMService service, Document doc) throws IOException {
        String title = this.getTitle(doc);
        MapLayer topLayer = this.wmsLayerFromNode(XMLTools.simpleXPath(doc, "WMS_Capabilities/Capability/Layer"));
        LinkedList<String> formatList = this.getFormatList(doc);
        String getMapURL = this.getMapURL(doc);
        String getFeatureInfoURL = this.getFeatureInfoURL(doc);
        return new Capabilities(service, title, topLayer, formatList, this.getInfoFormats(doc), getMapURL, getFeatureInfoURL);
    }

    @Override
    protected LinkedList<String> getFormatList(Document doc) throws IOException {
        LinkedList<String> formatList = new LinkedList<String>();
        Node formatNode = XMLTools.simpleXPath(doc, "WMS_Capabilities/Capability/Request/GetMap");
        NodeList nl = formatNode.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            String format;
            Node n = nl.item(i);
            if (n.getNodeType() != 1 || !"Format".equals(n.getNodeName()) || !(format = n.getFirstChild().getNodeValue()).matches("^image/(png|jpeg|gif).*")) continue;
            formatList.add(format);
        }
        return formatList;
    }

    protected String getMapURL(Document doc) {
        Node getMapNode = XMLTools.simpleXPath(doc, "WMS_Capabilities/Capability/Request/GetMap");
        String xp = "DCPType/HTTP/Get/OnlineResource";
        String xlink = "http://www.w3.org/1999/xlink";
        Element e = (Element)XMLTools.simpleXPath(getMapNode, xp);
        return e.getAttributeNS(xlink, "href");
    }

    protected String getFeatureInfoURL(Document doc) {
        String xp = "WMS_Capabilities/Capability/Request/GetFeatureInfo/DCPType/HTTP/Get/OnlineResource";
        String xlink = "http://www.w3.org/1999/xlink";
        Element e = (Element)XMLTools.simpleXPath(doc, xp);
        return e == null ? "" : e.getAttributeNS(xlink, "href");
    }

    @Override
    protected BoundingBox boundingBoxFromNode(Node n) throws Exception {
        try {
            NamedNodeMap nm = n.getAttributes();
            String srs = nm.getNamedItem(this.getSRSName()).getNodeValue();
            AxisOrder order = AxisOrder.getAxisOrder(srs.toUpperCase());
            if (order == AxisOrder.LATLON) {
                double miny = this.getCoord("minx", nm);
                double minx = this.getCoord("miny", nm);
                double maxy = this.getCoord("maxx", nm);
                double maxx = this.getCoord("maxy", nm);
                return new BoundingBox(srs, minx, miny, maxx, maxy);
            }
            double minx = this.getCoord("minx", nm);
            double miny = this.getCoord("miny", nm);
            double maxx = this.getCoord("maxx", nm);
            double maxy = this.getCoord("maxy", nm);
            return new BoundingBox(srs, minx, miny, maxx, maxy);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(I18N.getInstance().get("com.vividsolutions.wms.Parser.invalid-bounding-box-element-node") + ": " + e.toString());
        }
    }

    @Override
    protected String getSRSName() {
        return "CRS";
    }
}

