/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.wms;

import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.wms.AbstractParser;
import com.vividsolutions.wms.Capabilities;
import com.vividsolutions.wms.MapLayer;
import com.vividsolutions.wms.WMService;
import com.vividsolutions.wms.util.XMLTools;
import java.io.IOException;
import java.util.LinkedList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ParserWMS1_1
extends AbstractParser {
    @Override
    protected String getRootPath() {
        return "WMT_MS_Capabilities";
    }

    @Override
    protected Capabilities parseCapabilities(WMService service, Document doc) throws IOException {
        String title = this.getTitle(doc);
        Node rootlayerNode = XMLTools.simpleXPath(doc, "WMT_MS_Capabilities/Capability/Layer");
        if (rootlayerNode != null) {
            MapLayer topLayer = this.wmsLayerFromNode(rootlayerNode);
            LinkedList<String> formatList = this.getFormatList(doc);
            String getMapURL = this.getMapURL(doc);
            String featureInfoURL = this.getFeatureInfoURL(doc);
            return new Capabilities(service, title, topLayer, formatList, this.getInfoFormats(doc), getMapURL, featureInfoURL);
        }
        throw new IOException(service.getServerUrl() + ":\n Element 'WMT_MS_Capabilities/Capability/Layer' has not been found !");
    }

    protected String getMapURL(Document doc) {
        Node getMapNode = XMLTools.simpleXPath(doc, "WMT_MS_Capabilities/Capability/Request/GetMap");
        String xp = "DCPType/HTTP/Get/OnlineResource";
        String xlink = "http://www.w3.org/1999/xlink";
        Element e = (Element)XMLTools.simpleXPath(getMapNode, xp);
        if (e != null) {
            return e.getAttributeNS(xlink, "href");
        }
        Logger.warn(doc.getBaseURI() + "\nElement 'DCPType/HTTP/Get/OnlineResource' has not been found");
        return null;
    }

    protected String getFeatureInfoURL(Document doc) {
        String xp = "WMT_MS_Capabilities/Capability/Request/GetFeatureInfo/DCPType/HTTP/Get/OnlineResource";
        String xlink = "http://www.w3.org/1999/xlink";
        Element e = (Element)XMLTools.simpleXPath(doc, xp);
        return e == null ? "" : e.getAttributeNS(xlink, "href");
    }

    @Override
    protected String getSRSName() {
        return "SRS";
    }
}

