/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.zoom;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.locationtech.jts.util.Assert;

public class ZoomNextPlugIn
extends AbstractPlugIn {
    public ZoomNextPlugIn() {
        this.setShortcutKeys(89);
        this.setShortcutModifiers(3);
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        Viewport viewport = context.getLayerViewPanel().getViewport();
        Assert.isTrue((boolean)viewport.getZoomHistory().hasNext());
        viewport.getZoomHistory().setAdding(false);
        try {
            viewport.zoom(viewport.getZoomHistory().next());
        }
        finally {
            viewport.getZoomHistory().setAdding(true);
        }
        return true;
    }

    public MultiEnableCheck createEnableCheck(final WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(new EnableCheck(){

            @Override
            public String check(JComponent component) {
                LayerViewPanel layerViewPanel = workbenchContext.getLayerViewPanel();
                return layerViewPanel == null || !layerViewPanel.getViewport().getZoomHistory().hasNext() ? I18N.getInstance().get("ui.zoom.ZoomNextPlugIn.already-at-end") : null;
            }
        });
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.icon("Right.gif");
    }
}

