/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.zoom;

import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.cursortool.DragTool;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.renderer.RenderingManager;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.Timer;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;

public abstract class AbstractZoomTool
extends DragTool {
    static final double WHEEL_ZOOM_IN_FACTOR = 1.15;
    static final int BOX_TOLERANCE = 4;
    static final double ZOOM_IN_FACTOR = 2.0;
    protected Image origImage;
    protected Image auxImage = null;
    protected double scale = 1.0;
    protected int mouseWheelCount = 0;
    protected Point2D.Double zoomTo = new Point2D.Double(0.0, 0.0);
    private boolean isAnimatingZoom = false;
    private Timer mouseWheelUpdateTimer = null;
    private Point2D cursor = null;

    public AbstractZoomTool(WorkbenchContext context) {
        super(context);
    }

    public boolean setAnimatingZoom(boolean animating) {
        boolean previousValue = this.isAnimatingZoom;
        this.isAnimatingZoom = animating;
        return previousValue;
    }

    public boolean getAnimatingZoom() {
        return this.isAnimatingZoom;
    }

    @Override
    public Icon getIcon() {
        return IconLoader.icon("Magnify.gif");
    }

    @Override
    public Cursor getCursor() {
        return AbstractZoomTool.createCursor(IconLoader.icon("MagnifyCursor.gif").getImage());
    }

    @Override
    protected void gestureFinished() throws NoninvertibleTransformException {
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        int nclicks = e.getWheelRotation();
        this.mouseWheelCount += nclicks;
        this.scale = this.mouseWheelCount == 0 ? 1.0 : (this.mouseWheelCount < 0 ? (double)Math.abs(this.mouseWheelCount) * 1.15 : 1.0 / ((double)this.mouseWheelCount * 1.15));
        try {
            this.cursor = e.getPoint();
            if (this.mouseWheelUpdateTimer == null) {
                RenderingManager renderManager = this.getPanel().getRenderingManager();
                renderManager.setPaintingEnabled(false);
                this.mouseWheelUpdateTimer = new Timer(700, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            AbstractZoomTool.this.zoomAt(AbstractZoomTool.this.cursor, AbstractZoomTool.this.scale, false);
                            AbstractZoomTool.this.mouseWheelUpdateTimer.stop();
                            AbstractZoomTool.this.mouseWheelUpdateTimer = null;
                            AbstractZoomTool.this.mouseWheelCount = 0;
                            AbstractZoomTool.this.origImage = null;
                            RenderingManager renderManager = AbstractZoomTool.this.getPanel().getRenderingManager();
                            renderManager.setPaintingEnabled(true);
                            renderManager.repaintPanel();
                        }
                        catch (NoninvertibleTransformException noninvertibleTransformException) {
                            // empty catch block
                        }
                    }
                });
                this.mouseWheelUpdateTimer.start();
                this.mouseWheelUpdateTimer.setRepeats(false);
                this.cacheImage();
                this.scaleImageAtPoint(this.cursor, this.scale);
            } else {
                this.mouseWheelUpdateTimer.restart();
                this.scaleImageAtPoint(this.cursor, this.scale);
            }
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    protected void scaleImageAtCentre(double zoomFactor) {
        double w = this.getPanel().getWidth();
        double h = this.getPanel().getHeight();
        double dx = (w - w * zoomFactor) / 2.0;
        double dy = (h - h * zoomFactor) / 2.0;
        this.drawImage((int)dx, (int)dy, zoomFactor);
    }

    protected void scaleImageAtPoint(Point2D p, double zoomFactor) {
        double w = this.getPanel().getWidth();
        double h = this.getPanel().getHeight();
        double dx = (w - w * zoomFactor) / 2.0;
        double dy = (h - h * zoomFactor) / 2.0;
        double cx = w / 2.0;
        double cy = h / 2.0;
        double x1 = p.getX() - cx;
        double y1 = p.getY() - cy;
        double x2 = x1 - x1 * zoomFactor;
        double y2 = y1 - y1 * zoomFactor;
        this.drawImage((int)(dx += x2), (int)(dy += y2), zoomFactor);
    }

    public Image createImageIfNeeded(Image currImage) {
        if (currImage == null || currImage.getHeight(null) != this.getPanel().getHeight() || currImage.getWidth(null) != this.getPanel().getWidth()) {
            Graphics2D g = (Graphics2D)this.getPanel().getGraphics();
            BufferedImage img = g.getDeviceConfiguration().createCompatibleImage(this.getPanel().getWidth(), this.getPanel().getHeight(), 1);
            return img;
        }
        return currImage;
    }

    public void cacheImage() {
        this.origImage = this.createImageIfNeeded(this.origImage);
        this.getPanel().paint(this.origImage.getGraphics());
    }

    protected Point2D getCentre() throws NoninvertibleTransformException {
        double x = (double)this.getPanel().getWidth() / 2.0;
        double y = (double)this.getPanel().getHeight() / 2.0;
        return new Point2D.Double(x, y);
    }

    protected void zoomAt(Point2D p, double zoomFactor, boolean animatingZoom) throws NoninvertibleTransformException {
        Viewport vp = this.getPanel().getViewport();
        Point2D zoomPoint = vp.toModelPoint(p);
        Envelope modelEnvelope = vp.getEnvelopeInModelCoordinates();
        Coordinate centre = modelEnvelope.centre();
        double width = modelEnvelope.getWidth();
        double height = modelEnvelope.getHeight();
        double dx = (zoomPoint.getX() - centre.x) / zoomFactor;
        double dy = (zoomPoint.getY() - centre.y) / zoomFactor;
        Envelope zoomModelEnvelope = new Envelope(zoomPoint.getX() - 0.5 * (width / zoomFactor) - dx, zoomPoint.getX() + 0.5 * (width / zoomFactor) - dx, zoomPoint.getY() - 0.5 * (height / zoomFactor) - dy, zoomPoint.getY() + 0.5 * (height / zoomFactor) - dy);
        vp.zoom(zoomModelEnvelope);
    }

    public void drawImage(int dx, int dy, double scale) {
        double w = this.origImage.getWidth(this.getPanel());
        double h = this.origImage.getHeight(this.getPanel());
        double w2 = w * scale;
        double h2 = h * scale;
        this.auxImage = this.createImageIfNeeded(this.auxImage);
        Graphics2D g = (Graphics2D)this.auxImage.getGraphics();
        RenderingHints rh = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.setRenderingHints(rh);
        g.setComposite(AlphaComposite.Src);
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.auxImage.getWidth(this.getPanel()), this.auxImage.getHeight(this.getPanel()));
        g.drawImage(this.origImage, dx, dy, (int)w2, (int)h2, this.getPanel());
        this.getPanel().getGraphics().drawImage(this.auxImage, 0, 0, this.getPanel());
    }
}

