/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.warp;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.JUMPException;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureUtil;
import com.vividsolutions.jump.task.DummyTaskMonitor;
import com.vividsolutions.jump.util.CollectionUtil;
import com.vividsolutions.jump.warp.AffineTransform;
import com.vividsolutions.jump.warp.BilinearInterpolatedTransform;
import com.vividsolutions.jump.warp.CoordinateTransform;
import com.vividsolutions.jump.warp.DummyTransform;
import com.vividsolutions.jump.warp.ProjectiveTransform;
import com.vividsolutions.jump.warp.Triangulator;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.model.CategoryEvent;
import com.vividsolutions.jump.workbench.model.FeatureEvent;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerEvent;
import com.vividsolutions.jump.workbench.model.LayerListener;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerNamePanel;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelListener;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelProxy;
import com.vividsolutions.jump.workbench.ui.LayerNameRenderer;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelProxy;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.CopySelectedLayersToWarpingVectorsPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.generate.ShowTriangulationPlugIn;
import com.vividsolutions.jump.workbench.ui.toolbox.ToolboxDialog;
import com.vividsolutions.jump.workbench.ui.warp.AffineTransformPlugIn;
import com.vividsolutions.jump.workbench.ui.warp.DeleteIncrementalWarpingVectorTool;
import com.vividsolutions.jump.workbench.ui.warp.DeleteWarpingVectorTool;
import com.vividsolutions.jump.workbench.ui.warp.DrawIncrementalWarpingVectorTool;
import com.vividsolutions.jump.workbench.ui.warp.DrawWarpingVectorTool;
import com.vividsolutions.jump.workbench.ui.warp.IncrementalWarpingVectorLayerFinder;
import com.vividsolutions.jump.workbench.ui.warp.ProjectiveTransformPlugIn;
import com.vividsolutions.jump.workbench.ui.warp.WarpingVectorLayerFinder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.util.Assert;
import org.saig.core.gui.swing.sldeditor.util.FormUtils;

public class WarpingPanel
extends JPanel {
    public static final String MODIFIED_OUTSIDE_WARP_KEY = WarpingPanel.class.getName() + " - MODIFIED_OUTSIDE_WARP";
    public static final String RECONSTRUCTION_VECTORS_KEY = WarpingPanel.class.getName() + " - RECONSTRUCTION VECTORS";
    private DummyTaskMonitor dummyMonitor = new DummyTaskMonitor();
    private Triangulator triangulator = new Triangulator();
    private boolean warping = false;
    private static final String LAST_SOURCE_LAYER_KEY = WarpingPanel.class.getName() + " - LAST SOURCE LAYER";
    private boolean initializingSourceLayerComboBox = false;
    private DefaultComboBoxModel sourceLayerComboBoxModel = new DefaultComboBoxModel();
    private ToolboxDialog toolbox;
    private JPanel triangulationPanel;
    private JPanel warpIncrementallyCheckPanel;
    private JPanel autoHideCheckPanel;
    private JCheckBox autoHideCheckBox = new JCheckBox();
    private JPanel buttonPanel = new JPanel();
    private JButton clearOutputButton = new JButton();
    private JButton copyLayerButton = new JButton();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private GridLayout gridLayout1 = new GridLayout();
    private JLabel layerLabel = new JLabel();
    private JLabel transformLabel = new JLabel();
    private JComboBox sourceLayerComboBox = new JComboBox();
    private JCheckBox triangulationCheckBox = new JCheckBox();
    private JButton warpButton = new JButton();
    private JCheckBox warpIncrementallyCheckBox = new JCheckBox();
    private LayerNamePanelListener layerNamePanelListener = new LayerNamePanelListener(){

        @Override
        public void layerSelectionChanged() {
            WarpingPanel.this.updateComponents();
        }
    };
    private LayerNamePanel lastLayerNamePanel = null;
    private static String TransformationType = I18N.getInstance().get("ui.warp.WarpingPanel.transformation") + ":";
    private static String Affine = I18N.getInstance().get("ui.warp.WarpingPanel.affine");
    private static String Perspective = I18N.getInstance().get("ui.warp.WarpingPanel.perspective");
    private static String Bilinear = I18N.getInstance().get("ui.warp.WarpingPanel.bilinear_interpolated");
    private static String AffineTooltip = I18N.getInstance().get("ui.warp.WarpingPanel.warning_1");
    private static String PerspectiveTooltip = I18N.getInstance().get("You must draw exactly 4 vectors to apply a perspective transformation");
    private static String BilinearTooltip = I18N.getInstance().get("ui.warp.WarpingPanel.bilinear_interpolated");
    public static String[] transformations = new String[]{Affine, Perspective, Bilinear};
    public static String[] transformationsTooltips = new String[]{AffineTooltip, PerspectiveTooltip, BilinearTooltip};
    public static JComboBox transComboBox = new JComboBox<String>(transformations);

    private void addModificationListener(final Layer outputLayer) {
        outputLayer.getLayerManager().addLayerListener(new LayerListener(){

            @Override
            public void categoryChanged(CategoryEvent e) {
            }

            @Override
            public void layerChanged(LayerEvent e) {
            }

            @Override
            public void featuresChanged(FeatureEvent e) {
                if (e.getLayer() != outputLayer) {
                    return;
                }
                if (WarpingPanel.this.warping) {
                    return;
                }
                outputLayer.getBlackboard().put(MODIFIED_OUTSIDE_WARP_KEY, true);
                outputLayer.getBlackboard().put(RECONSTRUCTION_VECTORS_KEY, new ArrayList());
            }
        });
    }

    public UndoableCommand addWarping(final UndoableCommand wrappeeCommand) {
        return new UndoableCommand(wrappeeCommand.getName()){
            private Boolean warping;
            UndoableCommand warpCommand;
            {
                super(name);
                this.warping = null;
                this.warpCommand = null;
            }

            private boolean warping() {
                if (this.warping == null) {
                    this.warping = WarpingPanel.this.isWarpingIncrementally() && WarpingPanel.this.warpConditionsMet();
                    if (this.warping.booleanValue()) {
                        this.warpCommand = WarpingPanel.this.executeCommand();
                    }
                }
                return this.warping;
            }

            @Override
            public void execute() {
                wrappeeCommand.execute();
                if (this.warping()) {
                    this.warpCommand.execute();
                }
            }

            @Override
            public void unexecute() {
                if (this.warping()) {
                    this.warpCommand.unexecute();
                }
                wrappeeCommand.unexecute();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearOutputButton_actionPerformed(ActionEvent e) {
        this.toolbox.getContext().getLayerManager().getUndoableEditReceiver().startReceiving();
        try {
            this.toolbox.getContext().getLayerManager().getUndoableEditReceiver().reportNothingToUndoYet();
            final Layer sourceLayer = this.currentSourceLayer();
            final Layer outputLayer = this.currentOutputLayer();
            final boolean outputLayerExistedOriginally = this.currentOutputLayer() != null;
            final ArrayList reconstructionVectors = new ArrayList();
            if (outputLayerExistedOriginally) {
                if (outputLayer.getBlackboard().getBoolean(MODIFIED_OUTSIDE_WARP_KEY)) {
                    this.toolbox.getContext().getLayerManager().getUndoableEditReceiver().reportIrreversibleChange();
                } else {
                    reconstructionVectors.addAll((Collection)outputLayer.getBlackboard().get(RECONSTRUCTION_VECTORS_KEY));
                }
            }
            final boolean willShowSourceLayer = this.isAutoHidingLayers() && sourceLayer != null && !sourceLayer.isVisible();
            UndoableCommand command = Layer.addUndo(this.warpingVectorLayerFinder().getLayerName(), this.toolbox.getContext(), Layer.addUndo(this.incrementalWarpingVectorLayerFinder().getLayerName(), this.toolbox.getContext(), ShowTriangulationPlugIn.addUndo(new UndoableCommand(this.clearOutputButton.getText()){

                @Override
                public void execute() {
                    if (WarpingPanel.this.warpingVectorLayerFinder().getLayer() != null) {
                        WarpingPanel.this.toolbox.getContext().getLayerManager().remove(WarpingPanel.this.warpingVectorLayerFinder().getLayer());
                    }
                    if (WarpingPanel.this.incrementalWarpingVectorLayerFinder().getLayer() != null) {
                        WarpingPanel.this.toolbox.getContext().getLayerManager().remove(WarpingPanel.this.incrementalWarpingVectorLayerFinder().getLayer());
                    }
                    if (outputLayerExistedOriginally) {
                        WarpingPanel.this.toolbox.getContext().getLayerManager().remove(WarpingPanel.this.toolbox.getContext().getLayerManager().getLayer(outputLayer.getName()));
                    }
                    if (willShowSourceLayer) {
                        sourceLayer.setVisible(true);
                    }
                    if (WarpingPanel.this.toolbox.getContext().getLayerManager().getLayer(ShowTriangulationPlugIn.SOURCE_LAYER_NAME) != null) {
                        WarpingPanel.this.toolbox.getContext().getLayerManager().remove(WarpingPanel.this.toolbox.getContext().getLayerManager().getLayer(ShowTriangulationPlugIn.SOURCE_LAYER_NAME));
                    }
                    if (WarpingPanel.this.toolbox.getContext().getLayerManager().getLayer(ShowTriangulationPlugIn.DESTINATION_LAYER_NAME) != null) {
                        WarpingPanel.this.toolbox.getContext().getLayerManager().remove(WarpingPanel.this.toolbox.getContext().getLayerManager().getLayer(ShowTriangulationPlugIn.DESTINATION_LAYER_NAME));
                    }
                }

                @Override
                public void unexecute() {
                    try {
                        if (willShowSourceLayer) {
                            sourceLayer.setVisible(false);
                        }
                        if (outputLayerExistedOriginally) {
                            WarpingPanel.this.bilinearTransformVector(sourceLayer, reconstructionVectors, false);
                        }
                    }
                    catch (Throwable t) {
                        WarpingPanel.this.toolbox.getContext().getErrorHandler().handleThrowable(t);
                        WarpingPanel.this.toolbox.getContext().getLayerManager().getUndoableEditReceiver().reportIrreversibleChange();
                    }
                }
            }, this.toolbox.getContext())));
            command.execute();
            this.toolbox.getContext().getLayerManager().getUndoableEditReceiver().receive(command.toUndoableEdit());
        }
        finally {
            this.toolbox.getContext().getLayerManager().getUndoableEditReceiver().stopReceiving();
        }
    }

    private void clearWarpingFlag() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WarpingPanel.this.warping = false;
            }
        });
    }

    private Collection clone(Collection features) {
        ArrayList<Feature> clone = new ArrayList<Feature>();
        for (Feature feature : features) {
            clone.add(feature.clone());
        }
        return clone;
    }

    private Collection collapseToTip(Collection vectors) {
        ArrayList<Feature> collapsedVectors = new ArrayList<Feature>();
        for (Feature vector : vectors) {
            Feature collapsedVector = vector.clone();
            this.tail(collapsedVector).setCoordinate(this.tip(collapsedVector));
            collapsedVector.getGeometry().geometryChanged();
            collapsedVectors.add(collapsedVector);
        }
        return collapsedVectors;
    }

    void copyLayerButton_actionPerformed(ActionEvent e) {
        this.toolbox.getContext().getLayerManager().getUndoableEditReceiver().startReceiving();
        try {
            new CopySelectedLayersToWarpingVectorsPlugIn().execute(this.toolbox.getContext().createPlugInContext());
        }
        catch (Throwable t) {
            this.toolbox.getContext().getErrorHandler().handleThrowable(t);
        }
        finally {
            this.toolbox.getContext().getLayerManager().getUndoableEditReceiver().stopReceiving();
        }
    }

    public UndoableCommand generateWarpingVectorsCommand() {
        List<Object> reconstructionVectors;
        Collection collection = reconstructionVectors = this.currentOutputLayer() == null || this.currentOutputLayer().getBlackboard().getBoolean(MODIFIED_OUTSIDE_WARP_KEY) ? new ArrayList() : (Collection)this.currentOutputLayer().getBlackboard().get(RECONSTRUCTION_VECTORS_KEY);
        if (this.isWarpingIncrementally() && this.warpingVectorLayerFinder().getLayer() != null) {
            reconstructionVectors = this.warpingVectorLayerFinder().getLayer().getFeatureCollectionWrapper().getFeatures();
        }
        final Collection newWarpingVectors = this.toWarpingVectors(this.incrementalWarpingVectorLayerFinder().getLayer().getFeatureCollectionWrapper().getFeatures(), reconstructionVectors, this.currentSourceLayer());
        return Layer.addUndo(this.warpingVectorLayerFinder().getLayerName(), this.toolbox.getContext(), new UndoableCommand(I18N.getInstance().get("ui.warp.WarpingPanel.generate-warping-vectors-from-incremental-warping-vectors")){

            @Override
            public void execute() {
                try {
                    if (WarpingPanel.this.warpingVectorLayerFinder().getLayer() == null) {
                        WarpingPanel.this.warpingVectorLayerFinder().createLayer();
                    } else {
                        WarpingPanel.this.warpingVectorLayerFinder().getLayer().getFeatureCollectionWrapper().clear();
                    }
                    WarpingPanel.this.warpingVectorLayerFinder().getLayer().getFeatureCollectionWrapper().addAll(newWarpingVectors);
                }
                catch (Throwable t) {
                    WarpingPanel.this.toolbox.getContext().getErrorHandler().handleThrowable(t);
                    WarpingPanel.this.toolbox.getContext().getLayerManager().getUndoableEditReceiver().reportIrreversibleChange();
                }
            }

            @Override
            public void unexecute() {
            }
        });
    }

    private void hideTriangulation() {
        if (!(this.toolbox.getContext().getWorkbench().getFrame().getActiveInternalFrame() instanceof LayerViewPanelProxy)) {
            return;
        }
        this.toolbox.getContext().getLayerManager().getUndoableEditReceiver().startReceiving();
        try {
            UndoableCommand command = ShowTriangulationPlugIn.addUndo(new UndoableCommand(I18N.getInstance().get("ui.warp.WarpingPanel.hide-triangulation")){

                @Override
                public void execute() {
                    if (WarpingPanel.this.toolbox.getContext().getLayerManager().getLayer(ShowTriangulationPlugIn.SOURCE_LAYER_NAME) != null) {
                        WarpingPanel.this.toolbox.getContext().getLayerManager().remove(WarpingPanel.this.toolbox.getContext().getLayerManager().getLayer(ShowTriangulationPlugIn.SOURCE_LAYER_NAME));
                    }
                    if (WarpingPanel.this.toolbox.getContext().getLayerManager().getLayer(ShowTriangulationPlugIn.DESTINATION_LAYER_NAME) != null) {
                        WarpingPanel.this.toolbox.getContext().getLayerManager().remove(WarpingPanel.this.toolbox.getContext().getLayerManager().getLayer(ShowTriangulationPlugIn.DESTINATION_LAYER_NAME));
                    }
                }

                @Override
                public void unexecute() {
                }
            }, this.toolbox.getContext());
            command.execute();
            this.toolbox.getContext().getLayerManager().getUndoableEditReceiver().receive(command.toUndoableEdit());
        }
        catch (Throwable t) {
            this.toolbox.getContext().getErrorHandler().handleThrowable(t);
        }
        finally {
            this.toolbox.getContext().getLayerManager().getUndoableEditReceiver().stopReceiving();
        }
    }

    public boolean isAutoHidingLayers() {
        return this.autoHideCheckBox.isSelected();
    }

    private boolean layerViewPanelProxyActive() {
        return this.toolbox.getContext().getWorkbench().getFrame().getActiveInternalFrame() instanceof LayerViewPanelProxy;
    }

    private Layer outputLayer(String sourceLayerName) {
        Layer outputLayer = this.toolbox.getContext().getLayerManager().getLayer(this.outputLayerName(sourceLayerName));
        if (outputLayer == null) {
            return null;
        }
        if (outputLayer.getBlackboard().get(MODIFIED_OUTSIDE_WARP_KEY) == null) {
            outputLayer.getBlackboard().put(MODIFIED_OUTSIDE_WARP_KEY, true);
            outputLayer.getBlackboard().put(RECONSTRUCTION_VECTORS_KEY, new ArrayList());
            this.addModificationListener(outputLayer);
        }
        return outputLayer;
    }

    private String outputLayerName(String sourceLayerName) {
        return I18N.getInstance().get("ui.warp.WarpingPanel.warped") + " " + sourceLayerName;
    }

    private void setWarpingFlag() {
        this.warping = true;
    }

    private void showTriangulation() {
        if (transComboBox.getSelectedItem().toString().equals(Bilinear)) {
            ShowTriangulationPlugIn showTriangulationPlugIn = new ShowTriangulationPlugIn(this);
            if (showTriangulationPlugIn.createEnableCheck(this.toolbox.getContext()).check(null) != null) {
                return;
            }
            this.toolbox.getContext().getLayerManager().getUndoableEditReceiver().startReceiving();
            try {
                showTriangulationPlugIn.execute(this.toolbox.getContext().createPlugInContext());
            }
            catch (Throwable t) {
                this.toolbox.getContext().getErrorHandler().handleThrowable(t);
            }
            finally {
                this.toolbox.getContext().getLayerManager().getUndoableEditReceiver().stopReceiving();
            }
        }
    }

    private Coordinate tail(Feature vector) {
        return ((LineString)vector.getGeometry()).getCoordinateN(0);
    }

    private Coordinate tip(Feature vector) {
        return ((LineString)vector.getGeometry()).getCoordinateN(1);
    }

    private Collection toWarpingVectors(Collection incrementalWarpingVectors, Collection reconstructionVectors, Layer sourceLayer) {
        ArrayList<Feature> warpingVectors = new ArrayList<Feature>();
        CoordinateTransform transform = reconstructionVectors.isEmpty() || sourceLayer == null ? new DummyTransform() : new BilinearInterpolatedTransform(CollectionUtil.inverse(this.triangleMap(sourceLayer.getFeatureCollectionWrapper().getEnvelope(), reconstructionVectors, new ArrayList(), Triangulator.taggedVectorVertices(false, FeatureUtil.toGeometries(incrementalWarpingVectors)))), new DummyTaskMonitor());
        List reconstructionVectorTips = Triangulator.taggedVectorVertices(true, FeatureUtil.toGeometries(reconstructionVectors));
        warpingVectors.addAll(reconstructionVectors);
        for (Feature incrementalWarpingVector : incrementalWarpingVectors) {
            Coordinate tip;
            Feature warpingVector = incrementalWarpingVector.clone();
            Coordinate tail = ((LineString)warpingVector.getGeometry()).getCoordinateN(0);
            if (tail.equals((Object)(tip = ((LineString)warpingVector.getGeometry()).getCoordinateN(1))) && reconstructionVectorTips.contains(tip)) continue;
            tail.setCoordinate(transform.transform(tail));
            warpingVector.getGeometry().geometryChanged();
            warpingVectors.add(warpingVector);
        }
        return warpingVectors;
    }

    public Map triangleMap(Envelope sourceLayerEnvelope, Collection vectorFeatures, Collection sourceHints, Collection destinationHints) {
        List<Geometry> vectorLineStrings = FeatureUtil.toGeometries(CopySelectedLayersToWarpingVectorsPlugIn.removeNonVectorFeaturesAndWarn(vectorFeatures, this.toolbox.getContext().getWorkbench().getFrame()));
        Map triangleMap = this.triangulator.triangleMap(sourceLayerEnvelope, vectorLineStrings, sourceHints, destinationHints, this.dummyMonitor);
        Assert.isTrue((boolean)this.triangulator.getIgnoredVectors().isEmpty(), (String)(!this.triangulator.getIgnoredVectors().isEmpty() ? this.triangulator.getIgnoredVectors().iterator().next().toString() : ""));
        return triangleMap;
    }

    void triangulationCheckBox_actionPerformed(ActionEvent e) {
        if (this.triangulationCheckBox.isSelected()) {
            this.showTriangulation();
        } else {
            this.hideTriangulation();
        }
    }

    private void warp() {
        this.toolbox.getContext().getLayerManager().getUndoableEditReceiver().startReceiving();
        try {
            this.toolbox.getContext().getLayerManager().getUndoableEditReceiver().reportNothingToUndoYet();
            UndoableCommand command = transComboBox.getSelectedItem().toString().equals(Bilinear) ? this.executeCommand() : this.executeAffineProjectiveCommand();
            command.execute();
            this.toolbox.getContext().getLayerManager().getUndoableEditReceiver().receive(command.toUndoableEdit());
        }
        finally {
            this.toolbox.getContext().getLayerManager().getUndoableEditReceiver().stopReceiving();
        }
    }

    void warpButton_actionPerformed(ActionEvent e) {
        try {
            if (this.warpConditionsMet()) {
                Feature f;
                if (this.currentSourceLayer() != null && this.currentSourceLayer().getFeatureCollectionWrapper().size() == 1 && (f = this.currentSourceLayer().getFeatureCollectionWrapper().getFeatures().get(0)).getGeometry() instanceof Point) {
                    String sWarning = I18N.getInstance().get("ui.warp.WarpingPanel.initerror-for-one-point");
                    this.toolbox.getContext().getWorkbench().getFrame().warnUser(sWarning);
                }
                this.warp();
            }
        }
        catch (Throwable t) {
            this.toolbox.getContext().getErrorHandler().handleThrowable(t);
        }
    }

    public boolean warpConditionsMet() {
        return this.layerViewPanelProxyActive() && this.sourceLayerComboBox.getSelectedIndex() > -1;
    }

    private Layer currentOutputLayer() {
        if (this.currentSourceLayer() == null) {
            return null;
        }
        return this.outputLayer(this.currentSourceLayer().getName());
    }

    public Layer currentSourceLayer() {
        return (Layer)this.sourceLayerComboBox.getSelectedItem();
    }

    public UndoableCommand executeCommand() {
        ArrayList newVectors;
        Assert.isTrue((this.currentSourceLayer() != null ? 1 : 0) != 0);
        Layer outputLayer = this.currentOutputLayer();
        final boolean outputLayerExistedOriginally = outputLayer != null;
        final ArrayList oldVectors = outputLayer != null ? new ArrayList((Collection)outputLayer.getBlackboard().get(RECONSTRUCTION_VECTORS_KEY)) : new ArrayList();
        ArrayList<Object> arrayList = newVectors = this.warpingVectorLayerFinder().getLayer() == null ? new ArrayList() : new ArrayList<Feature>(this.warpingVectorLayerFinder().getLayer().getFeatureCollectionWrapper().getFeatures());
        if (outputLayerExistedOriginally && outputLayer.getBlackboard().getBoolean(MODIFIED_OUTSIDE_WARP_KEY)) {
            this.toolbox.getContext().getLayerManager().getUndoableEditReceiver().reportIrreversibleChange();
        }
        final Layer sourceLayer = this.currentSourceLayer();
        final boolean willHideWarpingVectorLayer = this.isAutoHidingLayers() && this.warpingVectorLayerFinder().getLayer() != null && this.warpingVectorLayerFinder().getLayer().isVisible() && this.isWarpingIncrementally();
        final boolean willHideIncrementalWarpingVectorLayer = this.isAutoHidingLayers() && this.incrementalWarpingVectorLayerFinder().getLayer() != null && this.incrementalWarpingVectorLayerFinder().getLayer().isVisible() && !this.isWarpingIncrementally();
        final boolean willHideSourceLayer = this.isAutoHidingLayers() && sourceLayer != null && sourceLayer.isVisible();
        final boolean warpingIncrementally = this.isWarpingIncrementally();
        return Layer.addUndo(this.incrementalWarpingVectorLayerFinder().getLayerName(), this.toolbox.getContext(), new ShowTriangulationPlugIn(this).addLayerGeneration(new UndoableCommand(this.warpButton.getText()){

            @Override
            public void execute() {
                try {
                    WarpingPanel.this.bilinearTransformVector(sourceLayer, newVectors, warpingIncrementally);
                    if (willHideIncrementalWarpingVectorLayer) {
                        WarpingPanel.this.incrementalWarpingVectorLayerFinder().getLayer().setVisible(false);
                    }
                    if (willHideWarpingVectorLayer) {
                        WarpingPanel.this.warpingVectorLayerFinder().getLayer().setVisible(false);
                    }
                    if (willHideSourceLayer) {
                        sourceLayer.setVisible(false);
                    }
                }
                catch (Throwable t) {
                    WarpingPanel.this.toolbox.getContext().getErrorHandler().handleThrowable(t);
                    WarpingPanel.this.toolbox.getContext().getLayerManager().getUndoableEditReceiver().reportIrreversibleChange();
                }
                System.out.println("main : end");
            }

            @Override
            public void unexecute() {
                try {
                    if (willHideSourceLayer) {
                        sourceLayer.setVisible(true);
                    }
                    if (willHideWarpingVectorLayer) {
                        WarpingPanel.this.warpingVectorLayerFinder().getLayer().setVisible(true);
                    }
                    if (outputLayerExistedOriginally) {
                        WarpingPanel.this.bilinearTransformVector(sourceLayer, oldVectors, false);
                        if (willHideIncrementalWarpingVectorLayer) {
                            WarpingPanel.this.incrementalWarpingVectorLayerFinder().getLayer().setVisible(true);
                        }
                    } else {
                        WarpingPanel.this.toolbox.getContext().getLayerManager().remove(WarpingPanel.this.outputLayer(sourceLayer.getName()));
                    }
                }
                catch (Throwable t) {
                    WarpingPanel.this.toolbox.getContext().getErrorHandler().handleThrowable(t);
                    WarpingPanel.this.toolbox.getContext().getLayerManager().getUndoableEditReceiver().reportIrreversibleChange();
                }
            }
        }, this.toolbox.getContext(), false));
    }

    public boolean isWarpingIncrementally() {
        return this.warpIncrementallyCheckBox.isEnabled() && this.warpIncrementallyCheckBox.isSelected();
    }

    void sourceComboBox_actionPerformed(ActionEvent e) {
        if (this.initializingSourceLayerComboBox) {
            return;
        }
        if (this.sourceLayerComboBoxModel.getSize() == 0) {
            return;
        }
        ((Layer)this.sourceLayerComboBoxModel.getSelectedItem()).getLayerManager().getBlackboard().put(LAST_SOURCE_LAYER_KEY, this.sourceLayerComboBoxModel.getSelectedItem());
    }

    private IncrementalWarpingVectorLayerFinder incrementalWarpingVectorLayerFinder() {
        return new IncrementalWarpingVectorLayerFinder(this.toolbox.getContext());
    }

    private WarpingVectorLayerFinder warpingVectorLayerFinder() {
        return new WarpingVectorLayerFinder(this.toolbox.getContext());
    }

    private boolean excludingFromLayerList(Layer layer) {
        if (layer == this.warpingVectorLayerFinder().getLayer()) {
            return true;
        }
        if (layer == this.incrementalWarpingVectorLayerFinder().getLayer()) {
            return true;
        }
        if (layer.getName().equals(ShowTriangulationPlugIn.SOURCE_LAYER_NAME)) {
            return true;
        }
        return layer.getName().equals(ShowTriangulationPlugIn.DESTINATION_LAYER_NAME);
    }

    public WarpingPanel(final ToolboxDialog toolbox) {
        this.toolbox = toolbox;
        toolbox.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                WarpingPanel.this.updateComponents();
            }
        });
        GUIUtil.addInternalFrameListener(toolbox.getContext().getWorkbench().getFrame().getDesktopPane(), GUIUtil.toInternalFrameListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WarpingPanel.this.updateComponents();
            }
        }));
        this.sourceLayerComboBox.setModel(this.sourceLayerComboBoxModel);
        LayerNameRenderer layerListCellRenderer = new LayerNameRenderer();
        layerListCellRenderer.setCheckBoxVisible(false);
        layerListCellRenderer.setProgressIconLabelVisible(false);
        this.sourceLayerComboBox.setRenderer(layerListCellRenderer);
        this.warpButton.setIcon(IconLoader.icon("GoalFlag.gif"));
        this.layerLabel.setText(I18N.getInstance().get("ui.warp.WarpingPanel.source-layer"));
        this.transformLabel.setText(TransformationType);
        this.setLayout(this.gridBagLayout1);
        this.warpIncrementallyCheckBox.setToolTipText(I18N.getInstance().get("ui.warp.WarpingPanel.warps-relative-to-the-output-layer-as-soon-as-a-vector-is-drawn"));
        this.warpIncrementallyCheckBox.setSelected(false);
        this.warpIncrementallyCheckBox.setText(I18N.getInstance().get("ui.warp.WarpingPanel.warp-incrementally"));
        this.warpIncrementallyCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WarpingPanel.this.warpIncrementallyCheckBox_actionPerformed(e);
            }
        });
        this.sourceLayerComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WarpingPanel.this.sourceComboBox_actionPerformed(e);
            }
        });
        this.buttonPanel.setLayout(this.gridLayout1);
        this.gridLayout1.setColumns(1);
        this.gridLayout1.setRows(2);
        this.warpButton.setText(I18N.getInstance().get("ui.warp.WarpingPanel.warp"));
        this.warpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WarpingPanel.this.warpButton_actionPerformed(e);
            }
        });
        this.clearOutputButton.setText(I18N.getInstance().get("ui.warp.WarpingPanel.clear-all-vectors"));
        this.clearOutputButton.setToolTipText(I18N.getInstance().get("ui.warp.WarpingPanel.deletes-the-warp-output-layer-and-the-vectors"));
        this.clearOutputButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WarpingPanel.this.clearOutputButton_actionPerformed(e);
            }
        });
        this.autoHideCheckBox.setToolTipText(I18N.getInstance().get("ui.warp.WarpingPanel.auto-hides-the-source-layer-and-the-warping-vectors"));
        this.autoHideCheckBox.setSelected(true);
        this.autoHideCheckBox.setText(I18N.getInstance().get("ui.warp.WarpingPanel.auto-hide-layers"));
        this.triangulationCheckBox.setToolTipText(I18N.getInstance().get("ui.warp.WarpingPanel.shows-the-initial-and-final-triangulation-layers"));
        this.triangulationCheckBox.setText(I18N.getInstance().get("ui.warp.WarpingPanel.display-triangulation"));
        this.triangulationCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WarpingPanel.this.triangulationCheckBox_actionPerformed(e);
            }
        });
        this.copyLayerButton.setToolTipText(I18N.getInstance().get("ui.warp.WarpingPanel.copies-the-feature-in-the-selected-layer-to-the-warping-vectors-layer"));
        this.copyLayerButton.setText(I18N.getInstance().get("ui.warp.WarpingPanel.copy-layer-to-vectors"));
        this.copyLayerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WarpingPanel.this.copyLayerButton_actionPerformed(e);
            }
        });
        transComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                toolbox.updateEnabledState();
                WarpingPanel.this.updateTransformationComponents();
            }
        });
        JPanel warpPanel = new JPanel();
        warpPanel.setLayout(new BorderLayout());
        JPanel option = new JPanel();
        option.add(this.warpButton);
        transComboBox.setRenderer(new ComboBoxRenderer());
        transComboBox.setSelectedIndex(2);
        this.add((Component)this.layerLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.sourceLayerComboBox, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.transformLabel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)transComboBox, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.autoHideCheckBox, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
        this.add((Component)this.warpIncrementallyCheckBox, new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 4, 0, 4), 0, 0));
        this.add((Component)this.triangulationCheckBox, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 4), 0, 0));
        this.add((Component)this.buttonPanel, new GridBagConstraints(0, 8, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.warpButton, new GridBagConstraints(0, 10, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 4, 4, 4), 0, 0));
        this.add((Component)this.clearOutputButton, new GridBagConstraints(0, 11, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 4, 0, 4), 0, 0));
        this.add((Component)this.copyLayerButton, new GridBagConstraints(0, 12, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 4, 4, 4), 0, 0));
    }

    private JPanel triangulationPanel() {
        if (this.triangulationPanel == null) {
            this.triangulationPanel = new JPanel(new GridBagLayout());
            FormUtils.addRowInGBL(this.triangulationPanel, 1, 0, this.triangulationCheckBox);
        }
        return this.triangulationPanel;
    }

    private JPanel warpIncrementallyCheckPanel() {
        if (this.warpIncrementallyCheckPanel == null) {
            this.warpIncrementallyCheckPanel = new JPanel(new GridBagLayout());
            FormUtils.addRowInGBL(this.warpIncrementallyCheckPanel, 1, 0, this.warpIncrementallyCheckBox);
        }
        return this.warpIncrementallyCheckPanel;
    }

    private JPanel autoHideCheckPanel() {
        if (this.autoHideCheckPanel == null) {
            this.autoHideCheckPanel = new JPanel(new GridBagLayout());
            FormUtils.addRowInGBL(this.autoHideCheckPanel, 1, 0, this.autoHideCheckBox);
        }
        return this.autoHideCheckPanel;
    }

    void warpIncrementallyCheckBox_actionPerformed(ActionEvent e) {
        this.updateComponents();
    }

    public void updateComponents() {
        this.toolbox.updateEnabledState();
        this.clearOutputButton.setEnabled(this.toolbox.getContext().getWorkbench().getFrame().getActiveInternalFrame() instanceof TaskFrame);
        if (this.toolbox.getContext().getWorkbench().getFrame().getActiveInternalFrame() instanceof TaskFrame) {
            if (this.lastLayerNamePanel != null) {
                this.lastLayerNamePanel.removeListener(this.layerNamePanelListener);
            }
            this.lastLayerNamePanel = ((LayerNamePanelProxy)((Object)this.toolbox.getContext().getWorkbench().getFrame().getActiveInternalFrame())).getLayerNamePanel();
            this.lastLayerNamePanel.addListener(this.layerNamePanelListener);
        }
        this.copyLayerButton.setEnabled(null == new CopySelectedLayersToWarpingVectorsPlugIn().createEnableCheck(this.toolbox.getContext()).check(null));
        this.triangulationCheckBox.setSelected(this.toolbox.getContext().getLayerViewPanel() != null && this.toolbox.getContext().getLayerManager() != null && this.toolbox.getContext().getLayerManager().getLayer(ShowTriangulationPlugIn.SOURCE_LAYER_NAME) != null && this.toolbox.getContext().getLayerManager().getLayer(ShowTriangulationPlugIn.SOURCE_LAYER_NAME).isVisible() && this.toolbox.getContext().getLayerManager().getLayer(ShowTriangulationPlugIn.DESTINATION_LAYER_NAME) != null && this.toolbox.getContext().getLayerManager().getLayer(ShowTriangulationPlugIn.DESTINATION_LAYER_NAME).isVisible());
        this.updateSourceLayerComboBox();
        if (this.toolbox.getButton(DrawIncrementalWarpingVectorTool.class).isSelected() && !this.toolbox.getButton(DrawIncrementalWarpingVectorTool.class).isEnabled()) {
            this.toolbox.getButton(DrawWarpingVectorTool.class).doClick();
        }
        if (this.toolbox.getButton(DeleteIncrementalWarpingVectorTool.class).isSelected() && !this.toolbox.getButton(DeleteIncrementalWarpingVectorTool.class).isEnabled()) {
            this.toolbox.getButton(DeleteWarpingVectorTool.class).doClick();
        }
        if (this.toolbox.getButton(DrawWarpingVectorTool.class).isSelected() && !this.toolbox.getButton(DrawWarpingVectorTool.class).isEnabled()) {
            this.toolbox.getButton(DrawIncrementalWarpingVectorTool.class).doClick();
        }
        if (this.toolbox.getButton(DeleteWarpingVectorTool.class).isSelected() && !this.toolbox.getButton(DeleteWarpingVectorTool.class).isEnabled()) {
            this.toolbox.getButton(DeleteIncrementalWarpingVectorTool.class).doClick();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSourceLayerComboBox() {
        this.initializingSourceLayerComboBox = true;
        try {
            this.sourceLayerComboBoxModel.removeAllElements();
            if (!(this.toolbox.getContext().getWorkbench().getFrame().getActiveInternalFrame() instanceof LayerViewPanelProxy)) {
                return;
            }
            LayerViewPanelProxy proxy = (LayerViewPanelProxy)((Object)this.toolbox.getContext().getWorkbench().getFrame().getActiveInternalFrame());
            for (Layer layer : proxy.getLayerViewPanel().getLayerManager().getLayers()) {
                if (this.excludingFromLayerList(layer)) continue;
                this.sourceLayerComboBoxModel.addElement(layer);
            }
            if (this.sourceLayerComboBoxModel.getSize() > 0) {
                Layer lastSourceLayer = (Layer)proxy.getLayerViewPanel().getLayerManager().getBlackboard().get(LAST_SOURCE_LAYER_KEY);
                if (lastSourceLayer == null || !proxy.getLayerViewPanel().getLayerManager().getLayers().contains(lastSourceLayer)) {
                    proxy.getLayerViewPanel().getLayerManager().getBlackboard().put(LAST_SOURCE_LAYER_KEY, this.sourceLayerComboBoxModel.getElementAt(0));
                }
                this.sourceLayerComboBoxModel.setSelectedItem(proxy.getLayerViewPanel().getLayerManager().getBlackboard().get(LAST_SOURCE_LAYER_KEY));
            }
            String listenerAddedKey = this.getClass().getName() + " - LISTENER ADDED";
            if (!proxy.getLayerViewPanel().getLayerManager().getBlackboard().get(listenerAddedKey, false)) {
                proxy.getLayerViewPanel().getLayerManager().addLayerListener(new LayerListener(){

                    @Override
                    public void categoryChanged(CategoryEvent e) {
                    }

                    @Override
                    public void layerChanged(LayerEvent e) {
                        WarpingPanel.this.updateSourceLayerComboBox();
                    }

                    @Override
                    public void featuresChanged(FeatureEvent e) {
                    }
                });
                proxy.getLayerViewPanel().getLayerManager().getBlackboard().put(listenerAddedKey, true);
            }
        }
        finally {
            this.initializingSourceLayerComboBox = false;
        }
    }

    public UndoableCommand addWarpingVectorGeneration(final UndoableCommand wrappeeCommand) throws NoninvertibleTransformException {
        return new UndoableCommand(wrappeeCommand.getName()){
            private UndoableCommand generateWarpingVectorsCommand;
            {
                super(name);
                this.generateWarpingVectorsCommand = null;
            }

            private UndoableCommand generateWarpingVectorsCommand() {
                if (this.generateWarpingVectorsCommand == null) {
                    this.generateWarpingVectorsCommand = WarpingPanel.this.generateWarpingVectorsCommand();
                }
                return this.generateWarpingVectorsCommand;
            }

            @Override
            public void execute() {
                wrappeeCommand.execute();
                this.generateWarpingVectorsCommand().execute();
            }

            @Override
            public void unexecute() {
                this.generateWarpingVectorsCommand().unexecute();
                wrappeeCommand.unexecute();
            }
        };
    }

    private void projectiveTransformVector(Collection<Feature> warpingVectors) throws JUMPException {
        ProjectiveTransform transform = ProjectiveTransformPlugIn.getTransform();
        FeatureCollection featureCollection = transform.transform(this.currentSourceLayer().getFeatureCollectionWrapper());
        Layer outputLayer = this.outputLayer(this.currentSourceLayer().getName());
        if (outputLayer == null) {
            outputLayer = this.toolbox.getContext().getLayerManager().addLayer(StandardCategoryNames.RESULT_SUBJECT, this.outputLayerName(this.currentSourceLayer().getName()), featureCollection);
            outputLayer.setStyles(this.currentSourceLayer().cloneStyles());
            this.addModificationListener(outputLayer);
        } else {
            outputLayer.setFeatureCollection(featureCollection);
        }
        outputLayer.getBlackboard().put(MODIFIED_OUTSIDE_WARP_KEY, false);
        outputLayer.getBlackboard().put(RECONSTRUCTION_VECTORS_KEY, this.clone(warpingVectors));
        WarpingPanel.checkValid(featureCollection);
    }

    private void affineTransformVector(Collection<Feature> warpingVectors) throws JUMPException {
        AffineTransform transform = AffineTransformPlugIn.getTransform();
        FeatureCollection featureCollection = transform.transform(this.currentSourceLayer().getFeatureCollectionWrapper());
        Layer outputLayer = this.outputLayer(this.currentSourceLayer().getName());
        if (outputLayer == null) {
            outputLayer = this.toolbox.getContext().getLayerManager().addLayer(StandardCategoryNames.RESULT_SUBJECT, this.outputLayerName(this.currentSourceLayer().getName()), featureCollection);
            outputLayer.setStyles(this.currentSourceLayer().cloneStyles());
            this.addModificationListener(outputLayer);
        } else {
            outputLayer.setFeatureCollection(featureCollection);
        }
        outputLayer.getBlackboard().put(MODIFIED_OUTSIDE_WARP_KEY, false);
        outputLayer.getBlackboard().put(RECONSTRUCTION_VECTORS_KEY, this.clone(warpingVectors));
        WarpingPanel.checkValid(featureCollection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bilinearTransformVector(Layer sourceLayer, Collection<Feature> warpingVectors, boolean generateIncrementalWarpingVectors) throws JUMPException {
        this.setWarpingFlag();
        try {
            Map triangleMap = this.triangleMap(sourceLayer.getFeatureCollectionWrapper().getEnvelope(), warpingVectors, new ArrayList(), new ArrayList());
            BilinearInterpolatedTransform transform = new BilinearInterpolatedTransform(triangleMap, this.dummyMonitor);
            FeatureCollection outputFeatureCollection = transform.transform(sourceLayer.getFeatureCollectionWrapper());
            Layer outputLayer = this.outputLayer(sourceLayer.getName());
            if (outputLayer == null) {
                outputLayer = this.toolbox.getContext().getLayerManager().addLayer(StandardCategoryNames.RESULT_SUBJECT, this.outputLayerName(sourceLayer.getName()), outputFeatureCollection);
                outputLayer.setStyles(sourceLayer.cloneStyles());
                this.addModificationListener(outputLayer);
            } else {
                outputLayer.setFeatureCollection(outputFeatureCollection);
            }
            outputLayer.getBlackboard().put(MODIFIED_OUTSIDE_WARP_KEY, false);
            outputLayer.getBlackboard().put(RECONSTRUCTION_VECTORS_KEY, this.clone(warpingVectors));
            if (generateIncrementalWarpingVectors) {
                if (this.incrementalWarpingVectorLayerFinder().getLayer() == null) {
                    this.incrementalWarpingVectorLayerFinder().createLayer();
                }
                this.incrementalWarpingVectorLayerFinder().getLayer().getFeatureCollectionWrapper().clear();
                this.incrementalWarpingVectorLayerFinder().getLayer().getFeatureCollectionWrapper().addAll(this.collapseToTip(warpingVectors));
            }
        }
        finally {
            this.clearWarpingFlag();
        }
    }

    public void updateTransformationComponents() {
        Layer sourceLayer = this.currentSourceLayer();
        Layer outputLayer = this.currentOutputLayer();
        boolean outputLayerExistedOriginally = this.currentOutputLayer() != null;
        ArrayList reconstructionVectors = new ArrayList();
        this.toolbox.updateEnabledState();
        String str = transComboBox.getSelectedItem().toString();
        if (Arrays.asList(Affine, Perspective).contains(str)) {
            boolean willShowSourceLayer;
            this.warpIncrementallyCheckBox.setSelected(false);
            this.triangulationCheckBox.setSelected(false);
            this.triangulationCheckBox.setEnabled(false);
            this.warpIncrementallyCheckBox.setEnabled(false);
            this.hideTriangulation();
            this.toolbox.getButton(DrawIncrementalWarpingVectorTool.class).setEnabled(false);
            this.toolbox.getButton(DeleteIncrementalWarpingVectorTool.class).setEnabled(false);
            this.toolbox.getButton(DrawWarpingVectorTool.class).setEnabled(true);
            this.toolbox.getButton(DeleteWarpingVectorTool.class).setEnabled(true);
            if (this.incrementalWarpingVectorLayerFinder().getLayer() != null) {
                this.incrementalWarpingVectorLayerFinder().getLayer().setVisible(false);
            }
            if (this.warpingVectorLayerFinder().getLayer() != null) {
                this.warpingVectorLayerFinder().getLayer().setVisible(true);
            }
            if (this.toolbox.getContext().getLayerManager().getLayer(ShowTriangulationPlugIn.SOURCE_LAYER_NAME) != null) {
                this.toolbox.getContext().getLayerManager().remove(this.toolbox.getContext().getLayerManager().getLayer(ShowTriangulationPlugIn.SOURCE_LAYER_NAME));
            }
            if (this.toolbox.getContext().getLayerManager().getLayer(ShowTriangulationPlugIn.DESTINATION_LAYER_NAME) != null) {
                this.toolbox.getContext().getLayerManager().remove(this.toolbox.getContext().getLayerManager().getLayer(ShowTriangulationPlugIn.DESTINATION_LAYER_NAME));
            }
            if (outputLayerExistedOriginally) {
                if (outputLayer.getBlackboard().getBoolean(MODIFIED_OUTSIDE_WARP_KEY)) {
                    this.toolbox.getContext().getLayerManager().getUndoableEditReceiver().reportIrreversibleChange();
                } else {
                    reconstructionVectors.addAll((Collection)outputLayer.getBlackboard().get(RECONSTRUCTION_VECTORS_KEY));
                }
                this.toolbox.getContext().getLayerManager().remove(this.toolbox.getContext().getLayerManager().getLayer(outputLayer.getName()));
            }
            boolean bl = willShowSourceLayer = this.isAutoHidingLayers() && sourceLayer != null && !sourceLayer.isVisible();
            if (willShowSourceLayer) {
                sourceLayer.setVisible(true);
            }
            this.toolbox.pack();
            this.toolbox.repaint();
        } else if (str.equals(Bilinear)) {
            boolean willShowSourceLayer;
            this.triangulationCheckBox.setEnabled(true);
            this.warpIncrementallyCheckBox.setEnabled(true);
            if (outputLayerExistedOriginally) {
                if (outputLayer.getBlackboard().getBoolean(MODIFIED_OUTSIDE_WARP_KEY)) {
                    this.toolbox.getContext().getLayerManager().getUndoableEditReceiver().reportIrreversibleChange();
                } else {
                    reconstructionVectors.addAll((Collection)outputLayer.getBlackboard().get(RECONSTRUCTION_VECTORS_KEY));
                }
                this.toolbox.getContext().getLayerManager().remove(this.toolbox.getContext().getLayerManager().getLayer(outputLayer.getName()));
            }
            boolean bl = willShowSourceLayer = this.isAutoHidingLayers() && sourceLayer != null && !sourceLayer.isVisible();
            if (willShowSourceLayer) {
                sourceLayer.setVisible(true);
            }
            this.toolbox.pack();
            this.toolbox.repaint();
        }
    }

    public UndoableCommand executeAffineProjectiveCommand() {
        ArrayList newVectors;
        Assert.isTrue((this.currentSourceLayer() != null ? 1 : 0) != 0);
        Layer outputLayer = this.currentOutputLayer();
        final boolean outputLayerExistedOriginally = outputLayer != null;
        ArrayList oldVectors = outputLayer != null ? new ArrayList((Collection)outputLayer.getBlackboard().get(RECONSTRUCTION_VECTORS_KEY)) : new ArrayList();
        ArrayList<Object> arrayList = newVectors = this.warpingVectorLayerFinder().getLayer() == null ? new ArrayList() : new ArrayList<Feature>(this.warpingVectorLayerFinder().getLayer().getFeatureCollectionWrapper().getFeatures());
        if (outputLayerExistedOriginally && outputLayer.getBlackboard().getBoolean(MODIFIED_OUTSIDE_WARP_KEY)) {
            this.toolbox.getContext().getLayerManager().getUndoableEditReceiver().reportIrreversibleChange();
        }
        final Layer sourceLayer = this.currentSourceLayer();
        final boolean willHideWarpingVectorLayer = this.isAutoHidingLayers() && this.warpingVectorLayerFinder().getLayer() != null && this.warpingVectorLayerFinder().getLayer().isVisible();
        final boolean willHideSourceLayer = this.isAutoHidingLayers() && sourceLayer != null && sourceLayer.isVisible();
        return Layer.addUndo(this.warpingVectorLayerFinder().getLayerName(), this.toolbox.getContext(), new ShowTriangulationPlugIn(this).addLayerGeneration(new UndoableCommand(this.warpButton.getText()){

            @Override
            public void execute() {
                try {
                    if (transComboBox.getSelectedItem().toString().equals(Perspective)) {
                        try {
                            WarpingPanel.this.projectiveTransformVector(newVectors);
                        }
                        catch (Exception e) {
                            return;
                        }
                    }
                    try {
                        WarpingPanel.this.affineTransformVector(newVectors);
                    }
                    catch (Exception e) {
                        return;
                    }
                    if (willHideWarpingVectorLayer) {
                        WarpingPanel.this.warpingVectorLayerFinder().getLayer().setVisible(false);
                    }
                    if (willHideSourceLayer) {
                        sourceLayer.setVisible(false);
                    }
                }
                catch (Throwable t) {
                    WarpingPanel.this.toolbox.getContext().getErrorHandler().handleThrowable(t);
                    WarpingPanel.this.toolbox.getContext().getLayerManager().getUndoableEditReceiver().reportIrreversibleChange();
                }
            }

            @Override
            public void unexecute() {
                try {
                    if (willHideSourceLayer) {
                        sourceLayer.setVisible(true);
                    }
                    if (willHideWarpingVectorLayer) {
                        WarpingPanel.this.warpingVectorLayerFinder().getLayer().setVisible(true);
                    }
                    if (outputLayerExistedOriginally) {
                        if (transComboBox.getSelectedItem().toString().equals(Perspective)) {
                            // empty if block
                        }
                    } else {
                        WarpingPanel.this.toolbox.getContext().getLayerManager().remove(WarpingPanel.this.outputLayer(sourceLayer.getName()));
                    }
                }
                catch (Throwable t) {
                    WarpingPanel.this.toolbox.getContext().getErrorHandler().handleThrowable(t);
                    WarpingPanel.this.toolbox.getContext().getLayerManager().getUndoableEditReceiver().reportIrreversibleChange();
                }
            }
        }, this.toolbox.getContext(), false));
    }

    public static void checkValid(FeatureCollection featureCollection) {
        for (Feature feature : featureCollection) {
            if (feature.getGeometry().isValid()) continue;
            JUMPWorkbench.getInstance().getFrame().getContext().getLayerViewPanel().getContext().warnUser(I18N.getInstance().get("ui.warp.AffineTransformPlugIn.some-geometries-are-not-valid"));
            return;
        }
    }

    class ComboBoxRenderer
    extends BasicComboBoxRenderer {
        private static final long serialVersionUID = 1L;

        ComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
                if (-1 < index) {
                    list.setToolTipText(transformationsTooltips[index]);
                }
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setFont(list.getFont());
            this.setText(value == null ? "" : value.toString());
            return this;
        }
    }
}

