/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.toolbox;

import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.WorkbenchToolBar;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;

public class ToolboxDialog
extends JDialog {
    private ArrayList pluginsTools = new ArrayList();
    private WorkbenchContext context;
    private JPanel northPanel = new JPanel();
    private JPanel centerPanel = new JPanel();
    private JPanel southPanel = new JPanel();
    private JPanel toolbarsPanel = new JPanel();
    private JSeparator northPanelSeparator = new JSeparator(0);
    private GridLayout gridLayout1 = new GridLayout();
    private ArrayList<AbstractButton> buttons = new ArrayList();
    private ArrayList<WorkbenchToolBar> toolBars = new ArrayList();
    private boolean locationInitializedBeforeMakingDialogVisible = false;
    private GUIUtil.Location initialLocation = new GUIUtil.Location(0, false, 0, false);

    public ToolboxDialog(final WorkbenchContext context) {
        super(context.getWorkbench().getFrame(), "", false);
        this.jbInit();
        this.context = context;
        this.setResizable(true);
        this.setDefaultCloseOperation(1);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                if (ToolboxDialog.this.buttons.contains(context.getWorkbench().getFrame().getToolBar().getSelectedCursorToolButton())) {
                    context.getWorkbench().getFrame().getToolBar().getButtonGroup().getElements().nextElement().doClick();
                }
            }
        });
    }

    private void jbInit() {
        this.getContentPane().setLayout(new BorderLayout());
        this.northPanel.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.northPanel, "North");
        this.centerPanel.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.centerPanel, "Center");
        this.southPanel.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.southPanel, "South");
        this.toolbarsPanel.setLayout(this.gridLayout1);
        this.toolbarsPanel.setBorder(BorderFactory.createEmptyBorder(2, 10, 2, 10));
        this.gridLayout1.setColumns(1);
        this.northPanel.add((Component)this.toolbarsPanel, "Center");
        this.northPanel.add((Component)this.northPanelSeparator, "South");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                ToolboxDialog.this.northPanelSeparator.setVisible(ToolboxDialog.this.pluginsTools.size() > 0);
            }
        });
    }

    public JPanel getNorthPanel() {
        return this.northPanel;
    }

    public JPanel getSouthPanel() {
        return this.southPanel;
    }

    public JPanel getCenterPanel() {
        return this.centerPanel;
    }

    public void finishAddingComponents() {
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible && !this.locationInitializedBeforeMakingDialogVisible) {
            this.addComponentListener(new ComponentListener(){

                @Override
                public void componentShown(ComponentEvent e) {
                    ToolboxDialog.this.pack();
                    ToolboxDialog.this.removeComponentListener(this);
                }

                @Override
                public void componentResized(ComponentEvent e) {
                }

                @Override
                public void componentMoved(ComponentEvent e) {
                }

                @Override
                public void componentHidden(ComponentEvent e) {
                }
            });
            this.pack();
            this.initializeLocation();
            this.locationInitializedBeforeMakingDialogVisible = true;
        }
        super.setVisible(visible);
    }

    public AbstractButton getButton(Class cursorToolClass) {
        for (WorkbenchToolBar toolBar : this.toolBars) {
            AbstractButton button = toolBar.getButton(cursorToolClass);
            if (button == null) continue;
            return button;
        }
        return null;
    }

    public WorkbenchToolBar getToolBar() {
        if (this.toolBars.isEmpty()) {
            this.addToolBar();
        }
        return this.toolBars.get(this.toolBars.size() - 1);
    }

    public WorkbenchContext getContext() {
        return this.context;
    }

    public WorkbenchToolBar.ToolConfig add(CursorTool tool) {
        return this.add(tool, null);
    }

    public WorkbenchToolBar.ToolConfig add(CursorTool tool, EnableCheck enableCheck) {
        WorkbenchToolBar.ToolConfig config = this.getToolBar().addCursorTool(tool);
        JToggleButton button = config.getButton();
        this.getToolBar().setEnableCheck(button, enableCheck != null ? enableCheck : new MultiEnableCheck());
        this.registerButton(button, enableCheck);
        this.pluginsTools.add(tool);
        return config;
    }

    public void addPlugIn(PlugIn plugIn, EnableCheck enableCheck, Icon icon) {
        this.registerButton(this.getToolBar().addPlugIn(icon, plugIn, enableCheck, this.context), enableCheck);
        this.pluginsTools.add(plugIn);
    }

    public List getPluginsTools() {
        return new ArrayList(this.pluginsTools);
    }

    private void registerButton(AbstractButton button, EnableCheck enableCheck) {
        this.buttons.add(button);
    }

    public List<AbstractButton> getButtons() {
        return this.buttons;
    }

    public List<WorkbenchToolBar> getToolBars() {
        return this.toolBars;
    }

    public void addToolBar() {
        this.toolBars.add(new WorkbenchToolBar(this.context, this.context.getWorkbench().getFrame().getToolBar().getButtonGroup()));
        this.getToolBar().setBorder(null);
        this.getToolBar().setFloatable(false);
        this.gridLayout1.setRows(this.toolBars.size());
        this.toolbarsPanel.add(this.getToolBar());
    }

    private void initializeLocation() {
        GUIUtil.setLocation(this, this.initialLocation, this.context.getWorkbench().getFrame().getDesktopPane());
    }

    public void updateEnabledState() {
        for (WorkbenchToolBar toolBar : this.toolBars) {
            toolBar.updateEnabledState();
        }
    }

    public void setInitialLocation(GUIUtil.Location location) {
        this.initialLocation = location;
    }
}

