/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.task;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.task.TaskMonitorDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Date;
import javax.swing.JOptionPane;
import javax.swing.Timer;

public class TaskMonitorManager {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ThreadedPlugIn plugIn, PlugInContext context) {
        final TaskMonitorDialog progressDialog = new TaskMonitorDialog((Frame)context.getWorkbenchFrame(), context.getErrorHandler());
        progressDialog.setTitle(plugIn.getName());
        final TaskWrapper taskWrapper = new TaskWrapper(plugIn, context, progressDialog);
        progressDialog.addWindowListener(new WindowAdapter(){
            private int attempts = 0;

            @Override
            public void windowClosing(WindowEvent e) {
                if (1 == JOptionPane.showConfirmDialog(progressDialog, I18N.getInstance().get("com.vividsolutions.jump.workbench.ui.task.TaskMonitorManager.kill-process-warning"), I18N.getInstance().get("com.vividsolutions.jump.workbench.ui.task.TaskMonitorManager.kill-process"), 0, 2)) {
                    return;
                }
                ++this.attempts;
                if (this.attempts > 1) {
                    progressDialog.setVisible(false);
                    progressDialog.dispose();
                }
                taskWrapper.stop();
            }
        });
        progressDialog.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                taskWrapper.start();
            }
        });
        GUIUtil.centreOnWindow(progressDialog);
        Timer timer = this.timer(new Date(), plugIn, context.getWorkbenchFrame());
        timer.start();
        try {
            progressDialog.setVisible(true);
        }
        finally {
            timer.stop();
            progressDialog.dispose();
        }
    }

    private Timer timer(final Date start, final ThreadedPlugIn plugIn, final WorkbenchFrame workbenchFrame) {
        return new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String message = "";
                message = message + StringUtil.toTimeString(new Date().getTime() - start.getTime());
                message = message + " (" + plugIn.getName() + ")";
                workbenchFrame.setTimeMessage(message);
            }
        });
    }

    private class TaskWrapper
    extends Thread {
        private ThreadedPlugIn plugIn;
        private PlugInContext context;
        private TaskMonitorDialog dialog;

        public TaskWrapper(ThreadedPlugIn plugIn, PlugInContext context, TaskMonitorDialog dialog) {
            this.plugIn = plugIn;
            this.context = context;
            this.dialog = dialog;
        }

        @Override
        public void run() {
            Throwable throwable = null;
            try {
                this.plugIn.run(this.dialog, this.context);
            }
            catch (Throwable t) {
                throwable = t;
            }
            finally {
                this.dialog.setVisible(false);
                if (throwable != null && !(throwable instanceof ThreadDeath)) {
                    this.context.getErrorHandler().handleThrowable(throwable);
                }
                this.dialog.dispose();
                this.context = null;
            }
        }
    }
}

