/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer.style;

import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.renderer.style.ChoosableStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.LineStringStyle;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import javax.swing.Icon;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;

public abstract class LineStringSegmentStyle
extends LineStringStyle
implements ChoosableStyle {
    protected String name;
    protected Icon icon;

    public LineStringSegmentStyle(String name, Icon icon) {
        super(name, icon);
        this.name = name;
        this.icon = icon;
    }

    @Override
    protected void paintLineString(LineString lineString, Viewport viewport, Graphics2D graphics) throws Exception {
        double scale = viewport.getScale();
        Coordinate mid = null;
        Coordinate previous = null;
        double length = lineString.getLength();
        if (length * scale < 6.0) {
            return;
        }
        for (int i = 0; i < lineString.getNumPoints() - 1; ++i) {
            Coordinate c0 = lineString.getCoordinateN(i);
            Coordinate c1 = lineString.getCoordinateN(i + 1);
            mid = new Coordinate((c0.x + c1.x) / 2.0, (c0.y + c1.y) / 2.0);
            if (previous != null && previous.distance(mid) * scale < 12.0) continue;
            this.paint(c0, c1, viewport, graphics);
            previous = mid;
        }
    }

    protected void paint(Coordinate p0, Coordinate p1, Viewport viewport, Graphics2D graphics) throws Exception {
        this.paint(viewport.toViewPoint(new Point2D.Double(p0.x, p0.y)), viewport.toViewPoint(new Point2D.Double(p1.x, p1.y)), viewport, graphics);
    }

    protected abstract void paint(Point2D var1, Point2D var2, Viewport var3, Graphics2D var4) throws Exception;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }
}

