/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.wms;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.ui.InputChangedFirer;
import com.vividsolutions.jump.workbench.ui.InputChangedListener;
import com.vividsolutions.jump.workbench.ui.plugin.wms.SRSUtils;
import com.vividsolutions.jump.workbench.ui.wizard.WizardPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.locationtech.jts.util.Assert;

public class OneSRSWizardPanel
extends JPanel
implements WizardPanel {
    private InputChangedFirer inputChangedFirer = new InputChangedFirer();
    private Map dataMap;
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JLabel srsLabel = new JLabel();
    private DefaultComboBoxModel formatBoxModel = new DefaultComboBoxModel();
    private JLabel formatLabel;
    private JComboBox formatBox;
    private JPanel fillerPanel = new JPanel();
    private JTextField textField = new JTextField();

    public OneSRSWizardPanel() {
        try {
            this.jbInit();
            this.textField.setFont(new JLabel().getFont());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void add(InputChangedListener listener) {
        this.inputChangedFirer.add(listener);
    }

    @Override
    public void remove(InputChangedListener listener) {
        this.inputChangedFirer.remove(listener);
    }

    @Override
    public String getInstructions() {
        return I18N.getInstance().get("ui.plugin.wms.OneSRSWizardPanel.the-layers-you-have-chosen-support-only-one-coordinate-system");
    }

    void jbInit() throws Exception {
        this.srsLabel.setText(I18N.getInstance().get("ui.plugin.wms.OneSRSWizardPanel.select-coordinate-reference-system"));
        this.formatLabel = new JLabel(I18N.getInstance().get("ui.plugin.wms.SRSWizardPanel.image-format"));
        this.formatBox = new JComboBox();
        this.setLayout(this.gridBagLayout1);
        this.textField.setEnabled(false);
        this.textField.setOpaque(false);
        this.textField.setPreferredSize(new Dimension(125, 21));
        this.textField.setDisabledTextColor(Color.black);
        this.textField.setEditable(false);
        this.textField.setText("jTextField1");
        GridBagConstraints gb = new GridBagConstraints();
        gb.anchor = 17;
        gb.gridx = 0;
        gb.gridy = 0;
        gb.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.srsLabel, gb);
        ++gb.gridx;
        this.add((Component)this.textField, gb);
        ++gb.gridy;
        gb.gridx = 0;
        this.add((Component)this.formatLabel, gb);
        ++gb.gridx;
        this.add((Component)this.formatBox, gb);
    }

    @Override
    public void exitingToRight() {
        this.dataMap.put("FORMAT", this.formatBox.getSelectedItem());
    }

    public void enteredFromLeft(Map dataMap) {
        this.dataMap = dataMap;
        List commonSRSList = (List)dataMap.get("SRS_LIST");
        Assert.isTrue((commonSRSList.size() == 1 ? 1 : 0) != 0);
        String srs = (String)commonSRSList.get(0);
        dataMap.put("SRS", srs);
        String stringToShow = SRSUtils.getName(srs);
        this.textField.setText(stringToShow);
        String[] formats = (String[])dataMap.get("FORMAT_LIST");
        this.formatBoxModel.removeAllElements();
        for (String f : formats) {
            this.formatBoxModel.addElement(f);
        }
        this.formatBox.setModel(this.formatBoxModel);
    }

    @Override
    public String getTitle() {
        return I18N.getInstance().get("ui.plugin.wms.OneSRSWizardPanel.select-coordinate-reference-system");
    }

    @Override
    public String getID() {
        return this.getClass().getName();
    }

    @Override
    public boolean isInputValid() {
        return true;
    }

    @Override
    public String getNextID() {
        return null;
    }
}

