/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.imagery;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.imagery.ImageryLayerDataset;
import com.vividsolutions.jump.workbench.imagery.ReferencedImageStyle;
import com.vividsolutions.jump.workbench.imagery.ReferencedImagesLayer;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.TreeLayerNamePanel;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.imagery.ImageLayerManagerPlugIn;
import java.awt.Color;
import javax.swing.Icon;
import org.openjump.core.ui.plugin.AbstractUiPlugIn;
import org.openjump.core.ui.util.TaskUtil;

public class AddImageLayerPlugIn
extends AbstractUiPlugIn {
    private static int nameCounter = 1;

    @Override
    public String getName() {
        return I18N.getInstance().get("ui.plugin.imagery.AddImageLayerPlugIn.Add-Image-Layer");
    }

    @Override
    public Icon getIcon() {
        return IconLoader.icon("map_add_16.png");
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        LayerManager lm = context.getLayerManager();
        lm.setFiringEvents(false);
        Layer layer = this.createLayer(lm);
        lm.setFiringEvents(true);
        Category category = TaskUtil.getSelectedCategoryName(this.workbenchContext);
        lm.addLayerable(category.getName(), layer);
        TreeLayerNamePanel lnp = (TreeLayerNamePanel)context.getWorkbenchContext().getLayerableNamePanel();
        lnp.setSelectedLayerables(new Layerable[]{layer});
        boolean success = new ImageLayerManagerPlugIn().execute(context);
        return success;
    }

    private String chooseCategory(PlugInContext context) {
        return context.getLayerNamePanel() == null ? StandardCategoryNames.WORKING : (context.getLayerNamePanel().getSelectedCategories().isEmpty() ? StandardCategoryNames.WORKING : context.getLayerNamePanel().getSelectedCategories().iterator().next().toString());
    }

    private Layer createLayer(LayerManager lm) {
        String newLayerName = I18N.getInstance().get("ui.plugin.imagery.AddImageLayerPlugIn.Image") + "_" + nameCounter++;
        ReferencedImagesLayer layer = new ReferencedImagesLayer(newLayerName, Color.black, new FeatureDataset(ImageryLayerDataset.getSchema()), lm);
        layer.setEditable(true);
        layer.getBasicStyle().setRenderingFill(false);
        layer.getBasicStyle().setEnabled(false);
        layer.addStyle(new ReferencedImageStyle());
        return layer;
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerManagerMustBeActiveCheck());
    }
}

