/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.datastore;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.datastore.AdhocQuery;
import com.vividsolutions.jump.datastore.DataStoreConnection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.io.FeatureInputStream;
import com.vividsolutions.jump.io.datasource.DataSourceQuery;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.datastore.ConnectionDescriptor;
import com.vividsolutions.jump.workbench.datastore.ConnectionManager;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.datastore.AbstractAddDatastoreLayerPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.datastore.ConnectionPanel;
import com.vividsolutions.jump.workbench.ui.plugin.datastore.DataStoreQueryDataSource;
import com.vividsolutions.jump.workbench.ui.plugin.datastore.RunDatastoreQueryPanel;
import javax.swing.Icon;

public class RunDatastoreQueryPlugIn
extends AbstractAddDatastoreLayerPlugIn {
    @Override
    protected ConnectionPanel createPanel(PlugInContext context) {
        return new RunDatastoreQueryPanel(context.getWorkbenchContext());
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        context.getFeatureInstaller().addMainMenuPlugin(this, new String[]{MenuNames.FILE});
    }

    @Override
    protected Layerable createLayerable(ConnectionPanel panel, TaskMonitor monitor, PlugInContext context) throws Exception {
        return this.createLayer((RunDatastoreQueryPanel)panel, monitor, context);
    }

    @Override
    public String getName() {
        return I18N.getInstance().get("jump.workbench.ui.plugin.datastore.RunDatastoreQueryPlugIn.Run-Datastore-Query");
    }

    @Override
    public Icon getIcon() {
        return IconLoader.icon("sql.png");
    }

    private Layer createLayer(RunDatastoreQueryPanel panel, TaskMonitor monitor, PlugInContext context) throws Exception {
        panel.saveQuery();
        monitor.allowCancellationRequests();
        monitor.report(I18N.getInstance().get("jump.workbench.ui.plugin.datastore.AddDatastoreLayerPlugIn.Creating-layer"));
        String driver = panel.getConnectionDescriptor().getDataStoreDriverClassName();
        String query = panel.getQuery();
        if (driver.contains("Postgis") && query.matches("(?s).*\\$\\{[^\\{\\}]*\\}.*")) {
            query = DataStoreQueryDataSource.expandQuery(query, context);
        }
        AdhocQuery adhocQuery = new AdhocQuery(query);
        ConnectionDescriptor desc = panel.getConnectionDescriptor();
        DataStoreConnection dscon = ConnectionManager.instance(context.getWorkbenchContext()).getOpenConnection(desc);
        RunnableQuery rQuery = new RunnableQuery(dscon, adhocQuery);
        boolean isFiringEvents = context.getLayerManager().isFiringEvents();
        context.getLayerManager().setFiringEvents(false);
        try {
            rQuery.start();
            while (rQuery.getState() == Thread.State.RUNNABLE) {
                Thread.sleep(1000L);
                if (!monitor.isCancelRequested()) continue;
                throw new InterruptedException("The following query has been interrupted :\n" + adhocQuery.getQuery());
            }
            rQuery.join();
            if (rQuery.getThrowable() != null) {
                throw new Exception(rQuery.getThrowable());
            }
            FeatureInputStream featureInputStream = rQuery.getFeatureInputStream();
            FeatureDataset featureDataset = new FeatureDataset(featureInputStream.getFeatureSchema());
            int i = 0;
            while (featureInputStream.hasNext() && !monitor.isCancelRequested()) {
                featureDataset.add(featureInputStream.next());
                monitor.report(++i, -1, I18N.getInstance().get("jump.workbench.ui.plugin.datastore.RunDatastoreQueryPlugIn.features"));
            }
            String name = panel.getLayerName();
            Layer layer = new Layer(name, context.getLayerManager().generateLayerFillColor(), featureDataset, context.getLayerManager());
            layer.setDataSourceQuery(new DataSourceQuery(new DataStoreQueryDataSource(name, panel.getQuery(), panel.getConnectionDescriptor(), context.getWorkbenchContext()), panel.getQuery(), name));
            Layer layer2 = layer;
            return layer2;
        }
        catch (Error err) {
            throw new Exception(err);
        }
        finally {
            context.getLayerManager().setFiringEvents(isFiringEvents);
            dscon.close();
        }
    }

    class RunnableQuery
    extends Thread {
        DataStoreConnection connection;
        AdhocQuery query;
        FeatureInputStream featureInputStream;
        Throwable throwable;

        RunnableQuery(DataStoreConnection connection, AdhocQuery query) {
            this.connection = connection;
            this.query = query;
        }

        @Override
        public void run() {
            try {
                this.featureInputStream = this.connection.execute(this.query);
            }
            catch (Throwable e) {
                this.throwable = e;
            }
        }

        FeatureInputStream getFeatureInputStream() {
            return this.featureInputStream;
        }

        Throwable getThrowable() {
            return this.throwable;
        }
    }
}

