/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.datastore;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.datastore.DataStoreConnection;
import com.vividsolutions.jump.datastore.DataStoreException;
import com.vividsolutions.jump.workbench.datastore.ConnectionDescriptor;
import com.vividsolutions.jump.workbench.datastore.ConnectionManager;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.SwingUtilities;
import org.locationtech.jts.util.Assert;

public class PasswordPrompter {
    public DataStoreConnection getOpenConnection(ConnectionManager connectionManager, ConnectionDescriptor connectionDescriptor, Component parentComponent) throws Exception {
        return connectionManager.getOpenConnection(this.promptForPasswordIfNecessary(connectionDescriptor, connectionManager, parentComponent));
    }

    private ConnectionDescriptor promptForPasswordIfNecessary(ConnectionDescriptor connectionDescriptor, ConnectionManager connectionManager, Component parentComponent) throws DataStoreException {
        String passwordParameterName = ConnectionDescriptor.passwordParameterName(connectionDescriptor.getParameterList().getSchema());
        if (passwordParameterName == null) {
            return connectionDescriptor;
        }
        if (connectionDescriptor.getParameterList().getParameterString(passwordParameterName) != null) {
            return connectionDescriptor;
        }
        connectionDescriptor.getParameterList().setParameter(passwordParameterName, this.promptForPassword(this.identifier(connectionDescriptor), parentComponent));
        return connectionDescriptor;
    }

    private String identifier(ConnectionDescriptor connectionDescriptor) {
        for (String name : Arrays.asList(connectionDescriptor.getParameterList().getSchema().getNames())) {
            if (!name.toLowerCase().matches("user.*")) continue;
            return connectionDescriptor.getParameterList().getParameter(name).toString();
        }
        return connectionDescriptor.getParameterList().getParameter(connectionDescriptor.getParameterList().getSchema().getNames()[0]).toString();
    }

    private String promptForPassword(String identifier, Component parent) {
        Assert.isTrue((boolean)SwingUtilities.isEventDispatchThread());
        JPasswordField passwordField = new JPasswordField(15);
        final JDialog dialog = this.createDialog(I18N.getInstance().get("jump.workbench.ui.plugin.datastore.PasswordPrompter.Password"), parent);
        dialog.getContentPane().setLayout(new GridBagLayout());
        dialog.getContentPane().add((Component)new JLabel(I18N.getInstance().get("jump.workbench.ui.plugin.datastore.PasswordPrompter.Enter-password-for") + " " + identifier + ": "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        dialog.getContentPane().add((Component)passwordField, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        dialog.getContentPane().add((Component)new JButton(I18N.getInstance().get("jump.workbench.ui.plugin.datastore.PasswordPrompter.OK")){
            {
                super(arg0);
                this.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        dialog.setVisible(false);
                    }
                });
                dialog.getRootPane().setDefaultButton(this);
            }
        }, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        dialog.pack();
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        return new String(passwordField.getPassword());
    }

    private JDialog createDialog(String title, Component parent) {
        return this.window(parent) instanceof Frame ? new JDialog((Frame)this.window(parent), title, true) : new JDialog((Dialog)this.window(parent), title, true);
    }

    private Window window(Component component) {
        return component instanceof Window ? (Window)component : SwingUtilities.windowForComponent(component);
    }

    public static void main(String[] args) throws InterruptedException, InvocationTargetException {
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                GUIUtil.centreOnScreen(frame);
                new PasswordPrompter().promptForPassword("scott", frame);
            }
        });
    }
}

