/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.datastore;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.datastore.DataStoreConnection;
import com.vividsolutions.jump.datastore.DataStoreDriver;
import com.vividsolutions.jump.datastore.DataStoreException;
import com.vividsolutions.jump.util.Block;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.datastore.ConnectionDescriptor;
import com.vividsolutions.jump.workbench.datastore.ConnectionManager;
import com.vividsolutions.jump.workbench.registry.Registry;
import com.vividsolutions.jump.workbench.ui.ErrorHandler;
import com.vividsolutions.jump.workbench.ui.OKCancelDialog;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.datastore.ConnectionDescriptorPanel;
import com.vividsolutions.jump.workbench.ui.plugin.datastore.PasswordPrompter;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;

public class ConnectionManagerPanel
extends JPanel {
    private static final Icon CONNECTED_ICON = IconLoader.icon("connect.png");
    private static final Icon DISCONNECTED_ICON = IconLoader.icon("disconnect.png");
    private final Icon DBS_ICON = IconLoader.icon("famfam/database_edit.png");
    private final Icon NEW_DB_ICON = IconLoader.icon("famfam/database_add.png");
    private final Icon DELETE_DB_ICON = IconLoader.icon("famfam/database_delete.png");
    private JScrollPane scrollPane = null;
    private JList<ConnectionDescriptor> connectionJList = null;
    private JPanel buttonPanel = null;
    private JButton addButton = null;
    private JButton copyButton = null;
    private JButton deleteButton = null;
    private JButton connectButton = null;
    private JPanel fillerPanel = null;
    private JButton disconnectButton = null;
    private final ConnectionManager connectionManager;
    private final ErrorHandler errorHandler;
    private final Registry registry;
    private final WorkbenchContext context;

    public ConnectionManagerPanel(ConnectionManager connectionManager, Registry registry, ErrorHandler errorHandler, WorkbenchContext context) {
        this.initialize();
        this.connectionManager = connectionManager;
        this.registry = registry;
        this.errorHandler = errorHandler;
        this.context = context;
        this.initializeConnectionJList();
        this.updateButtons();
        this.connectionJList.getSelectionModel().addListSelectionListener(e -> this.updateButtons());
    }

    private void initializeConnectionJList() {
        this.connectionJList.setModel(this.createListModel());
    }

    private void updateButtons() {
        boolean hasDrivers = !this.registry.getEntries(DataStoreDriver.REGISTRY_CLASSIFICATION).isEmpty();
        boolean hasSelected = !this.getSelectedConnectionDescriptors().isEmpty();
        this.addButton.setEnabled(hasDrivers);
        this.copyButton.setEnabled(hasDrivers && hasSelected);
        this.deleteButton.setEnabled(!this.getSelectedConnectionDescriptors().isEmpty());
        this.connectButton.setEnabled(this.findSelectedConnection(new Block(){

            @Override
            public Object yield(Object connection) {
                try {
                    return ((DataStoreConnection)connection).isClosed();
                }
                catch (DataStoreException e) {
                    ConnectionManagerPanel.this.errorHandler.handleThrowable(e);
                    return Boolean.FALSE;
                }
            }
        }));
        this.disconnectButton.setEnabled(this.findSelectedConnection(new Block(){

            @Override
            public Object yield(Object connection) {
                try {
                    return !((DataStoreConnection)connection).isClosed();
                }
                catch (DataStoreException e) {
                    ConnectionManagerPanel.this.errorHandler.handleThrowable(e);
                    return Boolean.FALSE;
                }
            }
        }));
    }

    private boolean findSelectedConnection(Block criterion) {
        for (ConnectionDescriptor connectionDescriptor : this.getSelectedConnectionDescriptors()) {
            if (criterion.yield(this.connectionManager.getConnection(connectionDescriptor)) != Boolean.TRUE) continue;
            return true;
        }
        return false;
    }

    private ListModel<ConnectionDescriptor> createListModel() {
        DefaultListModel<ConnectionDescriptor> listModel = new DefaultListModel<ConnectionDescriptor>();
        for (ConnectionDescriptor connectionDescriptor : this.sort(new ArrayList<ConnectionDescriptor>(this.connectionManager.getConnectionDescriptors()), Comparator.comparing(Object::toString))) {
            listModel.addElement(connectionDescriptor);
        }
        return listModel;
    }

    private List<ConnectionDescriptor> sort(List<ConnectionDescriptor> collection, Comparator<ConnectionDescriptor> comparator) {
        collection.sort(comparator);
        return collection;
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(400, 300));
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.gridheight = 2;
        gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.gridy = 1;
        gridBagConstraints4.weighty = 1.0;
        gridBagConstraints4.fill = 1;
        gridBagConstraints1.insets = new Insets(5, 0, 0, 5);
        this.add((Component)this.getScrollPane(), gridBagConstraints2);
        this.add((Component)this.getButtonPanel(), gridBagConstraints1);
        this.add((Component)this.getFillerPanel(), gridBagConstraints4);
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setViewportView(this.getConnectionJList());
        }
        return this.scrollPane;
    }

    private JList<ConnectionDescriptor> getConnectionJList() {
        if (this.connectionJList == null) {
            this.connectionJList = new JList();
            this.connectionJList.setCellRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    ConnectionDescriptor connectionDescriptor = (ConnectionDescriptor)value;
                    super.getListCellRendererComponent((JList<?>)list, connectionDescriptor, index, isSelected, cellHasFocus);
                    try {
                        Icon icon = ConnectionManagerPanel.getConnectionIcon(connectionDescriptor, ConnectionManagerPanel.this.connectionManager.getConnection(connectionDescriptor).isClosed(), ConnectionManagerPanel.this.context);
                        this.setIcon(icon);
                    }
                    catch (DataStoreException e) {
                        ConnectionManagerPanel.this.errorHandler.handleThrowable(e);
                    }
                    return this;
                }
            });
        }
        return this.connectionJList;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            GridLayout gridLayout3 = new GridLayout();
            gridLayout3.setRows(6);
            gridLayout3.setVgap(5);
            gridLayout3.setColumns(1);
            gridLayout3.setHgap(0);
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(gridLayout3);
            this.buttonPanel.add((Component)this.getAddButton(), null);
            this.buttonPanel.add((Component)this.getCopyButton(), null);
            this.buttonPanel.add((Component)this.getDeleteButton(), null);
            this.buttonPanel.add(new JLabel());
            this.buttonPanel.add((Component)this.getConnectButton(), null);
            this.buttonPanel.add((Component)this.getDisconnectButton(), null);
        }
        return this.buttonPanel;
    }

    private JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new JButton();
            this.addButton.setIcon(this.NEW_DB_ICON);
            this.addButton.setText(I18N.getInstance().get("jump.workbench.ui.plugin.datastore.ConnectionManagerPanel.Add"));
            this.addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConnectionDescriptor connectionDescriptor = ConnectionManagerPanel.this.addConnection();
                    ConnectionManagerPanel.this.initializeConnectionJList();
                    if (connectionDescriptor != null) {
                        ConnectionManagerPanel.this.getConnectionJList().setSelectedValue(connectionDescriptor, true);
                    }
                    ConnectionManagerPanel.this.updateButtons();
                }
            });
        }
        return this.addButton;
    }

    private JButton getCopyButton() {
        if (this.copyButton == null) {
            this.copyButton = new JButton();
            this.copyButton.setIcon(this.DBS_ICON);
            this.copyButton.setText(I18N.getInstance().get("jump.workbench.ui.plugin.datastore.ConnectionManagerPanel.Copy"));
            this.copyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConnectionDescriptor connectionDescriptor = ConnectionManagerPanel.this.copyConnection();
                    ConnectionManagerPanel.this.initializeConnectionJList();
                    if (connectionDescriptor != null) {
                        ConnectionManagerPanel.this.getConnectionJList().setSelectedValue(connectionDescriptor, true);
                    }
                    ConnectionManagerPanel.this.updateButtons();
                }
            });
        }
        return this.copyButton;
    }

    private ConnectionDescriptor copyConnection() {
        return this.addOrCopyConnection(I18N.getInstance().get("jump.workbench.ui.plugin.datastore.ConnectionManagerPanel.Copy-Connection"), this.getSelectedConnection());
    }

    private ConnectionDescriptor addConnection() {
        if (this.registry.getEntries(DataStoreDriver.REGISTRY_CLASSIFICATION).isEmpty()) {
            JOptionPane.showMessageDialog(SwingUtilities.windowForComponent(this), I18N.getInstance().get("jump.workbench.ui.plugin.datastore.ConnectionManagerPanel.No-datastore-drivers-are-loaded"));
            return null;
        }
        return this.addOrCopyConnection(I18N.getInstance().get("jump.workbench.ui.plugin.datastore.ConnectionManagerPanel.Add-Connection"), null);
    }

    private ConnectionDescriptor addOrCopyConnection(String title, ConnectionDescriptor connDesc) {
        Window window = SwingUtilities.windowForComponent(this);
        OKCancelDialog.Validator validator = new OKCancelDialog.Validator(){

            @Override
            public String validateInput(Component component) {
                return ((ConnectionDescriptorPanel)component).validateInput();
            }
        };
        ConnectionDescriptorPanel connectionDescriptorPanel = new ConnectionDescriptorPanel(this.registry, this.context);
        if (connDesc != null) {
            connectionDescriptorPanel.setParameters(connDesc);
        }
        OKCancelDialog dialog = window instanceof Dialog ? new OKCancelDialog((Dialog)window, title, true, (Component)connectionDescriptorPanel, validator) : new OKCancelDialog((Frame)window, title, true, (Component)connectionDescriptorPanel, validator);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return null;
        }
        try {
            this.connectionManager.getOpenConnection(connectionDescriptorPanel.getConnectionDescriptor());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            this.connectionManager.getConnection(connectionDescriptorPanel.getConnectionDescriptor());
        }
        return connectionDescriptorPanel.getConnectionDescriptor();
    }

    private JButton getDeleteButton() {
        if (this.deleteButton == null) {
            this.deleteButton = new JButton();
            this.deleteButton.setIcon(this.DELETE_DB_ICON);
            this.deleteButton.setText(I18N.getInstance().get("jump.workbench.ui.plugin.datastore.ConnectionManagerPanel.Delete"));
            this.deleteButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        ConnectionManagerPanel.this.deleteSelectedConnections();
                    }
                    catch (DataStoreException x) {
                        ConnectionManagerPanel.this.errorHandler.handleThrowable(x);
                    }
                    ConnectionManagerPanel.this.initializeConnectionJList();
                    ConnectionManagerPanel.this.updateButtons();
                }
            });
        }
        return this.deleteButton;
    }

    private JButton getConnectButton() {
        if (this.connectButton == null) {
            this.connectButton = new JButton();
            this.connectButton.setIcon(CONNECTED_ICON);
            this.connectButton.setText(I18N.getInstance().get("jump.workbench.ui.plugin.datastore.ConnectionManagerPanel.Connect"));
            this.connectButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        ConnectionManagerPanel.this.openSelectedConnections();
                    }
                    catch (Exception x) {
                        ConnectionManagerPanel.this.errorHandler.handleThrowable(x);
                    }
                    ConnectionManagerPanel.this.updateButtons();
                    ConnectionManagerPanel.this.repaintConnectionJList();
                }
            });
        }
        return this.connectButton;
    }

    private JPanel getFillerPanel() {
        if (this.fillerPanel == null) {
            this.fillerPanel = new JPanel();
            this.fillerPanel.setLayout(new GridBagLayout());
        }
        return this.fillerPanel;
    }

    private JButton getDisconnectButton() {
        if (this.disconnectButton == null) {
            this.disconnectButton = new JButton();
            this.disconnectButton.setIcon(DISCONNECTED_ICON);
            this.disconnectButton.setText(I18N.getInstance().get("jump.workbench.ui.plugin.datastore.ConnectionManagerPanel.Disconnect"));
            this.disconnectButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        ConnectionManagerPanel.this.closeSelectedConnections();
                    }
                    catch (DataStoreException x) {
                        ConnectionManagerPanel.this.errorHandler.handleThrowable(x);
                    }
                    ConnectionManagerPanel.this.updateButtons();
                    ConnectionManagerPanel.this.repaintConnectionJList();
                }
            });
        }
        return this.disconnectButton;
    }

    private void repaintConnectionJList() {
        this.connectionJList.repaint();
    }

    private ConnectionDescriptor getSelectedConnection() {
        Iterator<ConnectionDescriptor> iterator = this.getSelectedConnectionDescriptors().iterator();
        if (iterator.hasNext()) {
            ConnectionDescriptor connectionDescriptor = iterator.next();
            return connectionDescriptor;
        }
        return null;
    }

    private void deleteSelectedConnections() throws DataStoreException {
        for (ConnectionDescriptor connectionDescriptor : this.getSelectedConnectionDescriptors()) {
            this.connectionManager.deleteConnectionDescriptor(connectionDescriptor);
        }
    }

    private void openSelectedConnections() throws Exception {
        for (ConnectionDescriptor connectionDescriptor : this.getSelectedConnectionDescriptors()) {
            if (!this.connectionManager.getConnection(connectionDescriptor).isClosed()) continue;
            new PasswordPrompter().getOpenConnection(this.connectionManager, connectionDescriptor, this);
        }
    }

    private void closeSelectedConnections() throws DataStoreException {
        for (ConnectionDescriptor connectionDescriptor : this.getSelectedConnectionDescriptors()) {
            if (this.connectionManager.getConnection(connectionDescriptor).isClosed()) continue;
            this.connectionManager.getConnection(connectionDescriptor).close();
        }
    }

    public Collection<ConnectionDescriptor> getSelectedConnectionDescriptors() {
        return this.connectionJList.getSelectedValuesList();
    }

    public static Icon getConnectionIcon(ConnectionDescriptor desc, boolean isClosed, WorkbenchContext context) throws DataStoreException {
        String driverClassName = desc.getDataStoreDriverClassName();
        for (Object object : context.getRegistry().getEntries(DataStoreDriver.REGISTRY_CLASSIFICATION)) {
            DataStoreDriver driver = (DataStoreDriver)object;
            if (!driver.getClass().getName().equals(driverClassName)) continue;
            return isClosed ? driver.getDisconnectedIcon() : driver.getConnectedIcon();
        }
        return isClosed ? DISCONNECTED_ICON : CONNECTED_ICON;
    }
}

